/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.external.status;

import com.teamscale.core.rest.EHttpMethod;
import com.teamscale.core.user.User;
import com.teamscale.service.external.input.SessionBasedExternalAnalysisServiceBase;
import com.teamscale.service.external.input.SessionBasedExternalAnalysisServiceQueryOptions;
import com.teamscale.service.framework.util.BodyPartWrapper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.conqat.lib.commons.string.StringUtils;

public class ExternalAnalysisStatusLogManager {
    private static final int REPORT_FILE_CONTENTS_MAX_BYTES_COUNT = 300;
    private final List<String> processingMessages = new ArrayList<String>();

    public void logError(Throwable e) {
        this.processingMessages.add("Server error: " + e.getMessage());
    }

    public void logSuccess() {
        this.processingMessages.add("Service returned successfully");
    }

    public void logUploadStepInitiation(Class<? extends SessionBasedExternalAnalysisServiceBase> initiatingService, User initiatingUser) {
        this.processingMessages.add("Initiated upload step using service " + initiatingService.getSimpleName() + " by user " + initiatingUser.getUsername() + " at " + String.valueOf(new Date()));
    }

    public void logSessionId(String sessionId) {
        this.processingMessages.add("Parameter session: " + sessionId);
    }

    public void logSessionCreation(String sessionId) {
        this.processingMessages.add("Created session with ID " + sessionId);
    }

    public void logSessionFetch(String sessionId) {
        this.processingMessages.add("Fetched session with ID " + sessionId);
    }

    public void logSessionCommit(String sessionId) {
        this.processingMessages.add("Committed session with session ID " + sessionId);
    }

    public void logHttpMethod(EHttpMethod method) {
        this.processingMessages.add("HTTP Method: " + String.valueOf(method));
    }

    public void logParameter(String parameterName, String parameterValue) {
        this.processingMessages.add("Parameter " + parameterName + ": " + parameterValue);
    }

    public void logParameters(EHttpMethod method, SessionBasedExternalAnalysisServiceQueryOptions parameters) {
        this.logHttpMethod(method);
        this.processingMessages.add("Parameter t: " + String.valueOf(parameters.getCommit()));
        this.processingMessages.add("Parameter repository: " + parameters.getRepository());
        this.processingMessages.add("Parameter revision: " + parameters.getRevision());
        this.processingMessages.add("Parameter message: " + parameters.getUploadMessage());
        this.processingMessages.add("Parameter partition: " + parameters.getPartition());
    }

    public void logReports(List<BodyPartWrapper> bodyParts) {
        for (BodyPartWrapper bodyPartWrapper : bodyParts) {
            String parameterValue = StringUtils.truncateWithThreeDots((String)bodyPartWrapper.getBodyPart(), (int)300);
            this.processingMessages.add("Parameter report: " + parameterValue);
        }
    }

    public List<String> getProcessingMessages() {
        return this.processingMessages;
    }
}

