/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings;

import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.option.project.ProjectOptionIndex;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.options.BlacklistingOption;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.index.blacklisting.EFindingBlacklistType;
import com.teamscale.index.blacklisting.EFindingBlacklistUpdateType;
import com.teamscale.index.blacklisting.FindingBlacklistChangeRetriever;
import com.teamscale.index.blacklisting.FindingBlacklistCommit;
import com.teamscale.index.blacklisting.FindingBlacklistEvent;
import com.teamscale.index.blacklisting.FindingBlacklistIndex;
import com.teamscale.index.blacklisting.FindingBlacklistInfo;
import com.teamscale.index.blacklisting.FindingBlacklistStagingIndex;
import com.teamscale.index.blacklisting.FindingExclusionApprovalOption;
import com.teamscale.index.blacklisting.UserResolvedFindingBlacklistInfo;
import com.teamscale.index.merge_request.MergeBaseCacheIndex;
import com.teamscale.index.repository.MergeBaseInfo;
import com.teamscale.index.tracking.index.TrackedFindingsByIdIndex;
import com.teamscale.index.user.UserAliasLookup;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.findings.EFindingBlacklistOperation;
import com.teamscale.service.findings.FindingBlacklistRequestBody;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.io.Serializable;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.IBranchingLayer;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class FindingsBlacklistServiceBase
extends ApiBase {
    public static final String OPERATION_PARAMETER_NAME = "operation";
    protected static final String UNKNOWN_BRANCH_ERROR_DESCRIPTION = "Operation is performed on unknown branch.";
    protected static final String FINDING_PARAMETER_DESCRIPTION = "Id of the finding the information is requested for.";
    protected static final String OPERATION_PARAMETER_DESCRIPTION = "Request operation to perform (e.g. add or remove flagging information).";
    protected static final String BLACKLIST_TYPE_PARAMETER_DESCRIPTION = "The type of flagging (optional for an unflag operation, findings of both types will be unflagged)";
    protected static final String BLACKLIST_TYPE_PARAMETER_NAME = "type";
    protected static final String MERGE_BASE_KEY_PARAMETER_DESCRIPTION = "Key of a precomputed (using the \"merge-requests/parent-info\" endpoint) merge-base info. Should be provided in case the finding delta is requested for a (possible) merge request. ";
    protected static final String MERGE_BASE_KEY_PARAMETER_NAME = "merge-base-cache-key";
    protected static final String FROM_PARAMETER_NAME = "from";
    protected static final String FROM_PARAMETER_DESCRIPTION = "Commit denoting the start of the flagged finding interval, or the source commit in case of a (possible) merge. Must be present when \"merge-base-cache-key\" is provided.";
    protected static final String TO_PARAMETER_NAME = "to";
    protected static final String TO_PARAMETER_DESCRIPTION = "Commit denoting the end of the flagged finding interval, or the target commit in case of a (possible) merge.";
    private static final Logger LOGGER = LogManager.getLogger();

    private static void validateFromAndMergeBaseKeyParameterCombination(String mergeBaseKey, UnresolvedCommitDescriptor from) throws BadRequestException {
        if (mergeBaseKey != null && from == null) {
            throw new BadRequestException(String.format("\"%s\" must be provided when \"%s\" is present.", FROM_PARAMETER_NAME, MERGE_BASE_KEY_PARAMETER_NAME));
        }
    }

    protected @NonNull List<FindingBlacklistInfo> getBlacklistedFindings(@Nullable String mergeBaseKey, @Nullable UnresolvedCommitDescriptor from, @NonNull UnresolvedCommitDescriptor to, @Nullable EFindingBlacklistType blacklistType) throws StorageException {
        CCSMAssert.isNotNull((Object)to, () -> String.format("Expected \"%s\" to be not null", TO_PARAMETER_NAME));
        if (from != null && from.isDefaultAtHead()) {
            from = null;
        }
        FindingsBlacklistServiceBase.validateFromAndMergeBaseKeyParameterCombination(mergeBaseKey, from);
        UnresolvedCommitDescriptor source = from;
        UnresolvedCommitDescriptor target = to;
        if (mergeBaseKey != null) {
            source = to;
            target = from;
        }
        long startTimestamp = this.getStartTimestamp(mergeBaseKey, source);
        List<FindingBlacklistInfo> flaggedFindings = this.getFilteredFindingBlacklistInfos(target, startTimestamp, blacklistType);
        if (source == null) {
            return flaggedFindings;
        }
        return new ArrayList<FindingBlacklistInfo>(CollectionUtils.difference(FindingBlacklistInfo::getFindingId, flaggedFindings, (Collection[])new Collection[]{this.getFilteredFindingBlacklistInfos(source, startTimestamp, blacklistType)}));
    }

    private long getStartTimestamp(@Nullable String mergeBaseKey, @Nullable UnresolvedCommitDescriptor from) throws StorageException {
        if (mergeBaseKey != null) {
            return this.getTimestampOfMergeBase(mergeBaseKey);
        }
        if (from != null) {
            return from.getTimestamp();
        }
        return -1L;
    }

    private long getTimestampOfMergeBase(@NonNull String mergeBaseKey) throws StorageException {
        MergeBaseInfo mergeBaseInfo = (MergeBaseInfo)this.openProjectIndex(MergeBaseCacheIndex.class, null).getValue(mergeBaseKey).orElseThrow(() -> new WebApplicationException(String.format("No merge base info entry found for key \"%s\". Maybe the entry expired?", mergeBaseKey), Response.Status.GONE));
        return mergeBaseInfo.getBranchPoint().orElseGet(() -> ((MergeBaseInfo)mergeBaseInfo).getMergeBase()).getTimestamp();
    }

    protected List<String> getBlacklistedFindingIds(UnresolvedCommitDescriptor commit) throws StorageException {
        Collection<FindingBlacklistInfo> blacklistInfos = this.getAllFindingBlacklistInfos(commit);
        return CollectionUtils.map(blacklistInfos, FindingBlacklistInfo::getFindingId);
    }

    protected void performBlacklistingOperation(String branch, EFindingBlacklistOperation operation, FindingBlacklistRequestBody findingBlacklistRequestBody, EFindingBlacklistType blacklistType) throws StorageException, BadRequestException, NotFoundException {
        if (branch == null) {
            branch = this.getDefaultBranchName();
        }
        HistoryAccessOption historyAccessOption = HistoryAccessOption.readHead((String)branch);
        TrackedFindingsByIdIndex trackedFindingsByIdIndex = this.openProjectIndex(TrackedFindingsByIdIndex.class, historyAccessOption);
        List findings = trackedFindingsByIdIndex.getFindings(findingBlacklistRequestBody.getFindingIds());
        PairList findingIdsToFindings = PairList.zip(findingBlacklistRequestBody.getFindingIds(), (List)findings);
        this.checkEditBlacklistPermissions(findings);
        if (operation == EFindingBlacklistOperation.REMOVE) {
            FindingBlacklistIndex blacklistIndex = this.openProjectIndex(FindingBlacklistIndex.class, historyAccessOption);
            this.removeFindingsFromBlacklist((PairList<String, TrackedFinding>)findingIdsToFindings, blacklistIndex, blacklistType, branch);
        } else if (blacklistType != null) {
            this.checkAddRequestAgainstServerOption(findingBlacklistRequestBody, blacklistType);
            this.addFindingsToBlacklist((PairList<String, TrackedFinding>)findingIdsToFindings, findingBlacklistRequestBody, blacklistType, branch);
        } else {
            throw new BadRequestException("Request to flag finding without the specification of the flagging type: TOLERATION or FALSE_POSITIVE");
        }
    }

    private void checkAddRequestAgainstServerOption(FindingBlacklistRequestBody findingBlacklistRequestBody, EFindingBlacklistType blacklistType) throws StorageException {
        BlacklistingOption blacklistingOption = BlacklistingOption.getBlacklistingOption((ServerOptionIndex)this.openGlobalIndex(ServerOptionIndex.class));
        FindingsBlacklistServiceBase.checkNonEmptyRationale(findingBlacklistRequestBody.getRationale(), blacklistingOption);
        if (blacklistingOption.disableFalsePositives && blacklistType == EFindingBlacklistType.FALSE_POSITIVE) {
            throw new BadRequestException("Reporting of false positives is disabled for this instance!");
        }
        if (blacklistingOption.disableTolerations && blacklistType == EFindingBlacklistType.TOLERATION) {
            throw new BadRequestException("Reporting of tolerated findings is disabled for this instance!");
        }
    }

    protected void checkNonEmptyRationale(String rationale) throws StorageException {
        BlacklistingOption blacklistingOption = BlacklistingOption.getBlacklistingOption((ServerOptionIndex)this.openGlobalIndex(ServerOptionIndex.class));
        FindingsBlacklistServiceBase.checkNonEmptyRationale(rationale, blacklistingOption);
    }

    private static void checkNonEmptyRationale(String rationale, BlacklistingOption blacklistingOption) {
        if (StringUtils.isEmpty((String)rationale) && blacklistingOption.disableEmptyRationale) {
            throw new BadRequestException("Non-empty rationale is required!");
        }
    }

    protected UserResolvedFindingBlacklistInfo getBlacklistedFindingInfo(String findingId, UnresolvedCommitDescriptor commit) throws StorageException {
        FindingBlacklistIndex blacklistIndex = this.openProjectIndex(FindingBlacklistIndex.class, this.determineHistoryOption(commit));
        FindingBlacklistInfo blacklistInfo = blacklistIndex.getBlacklistInfo(findingId);
        if (blacklistInfo == null) {
            return null;
        }
        return new UserResolvedFindingBlacklistInfo(blacklistInfo, EFindingBlacklistUpdateType.ADD, UserAliasLookup.createInstance((GlobalStorageSystem)this.getGlobalStorageSystem()));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected List<@NonNull FindingBlacklistInfo> getFlaggedFindingsInfos(List<String> findingIds, UnresolvedCommitDescriptor commit, @Nullable EFindingBlacklistType blacklistType) throws StorageException {
        FindingBlacklistIndex blacklistIndex = this.openProjectIndex(FindingBlacklistIndex.class, this.determineHistoryOption(commit));
        @NonNull List findingBlacklistInfos = CollectionUtils.filterNullEntries((Collection)blacklistIndex.getBlacklistInfos(findingIds));
        return findingBlacklistInfos.stream().filter(blacklistInfo -> blacklistType == null || blacklistInfo.getType() == blacklistType).toList();
    }

    List<FindingBlacklistInfo> getFilteredFindingBlacklistInfos(UnresolvedCommitDescriptor endCommit, long startTimestamp, @Nullable EFindingBlacklistType blacklistType) throws StorageException {
        return CollectionUtils.filter(this.getAllFindingBlacklistInfos(endCommit), findingBlacklistInfo -> (blacklistType == null || findingBlacklistInfo.getType() == blacklistType) && findingBlacklistInfo.getTimestamp() >= startTimestamp);
    }

    protected Collection<FindingBlacklistInfo> getAllFindingBlacklistInfos(UnresolvedCommitDescriptor commit) throws StorageException {
        FindingBlacklistIndex blacklistIndex = this.openProjectIndex(FindingBlacklistIndex.class, this.determineHistoryOption(commit));
        return blacklistIndex.getAllBlacklistInfos().values();
    }

    protected void removeFindingsFromBlacklist(PairList<String, TrackedFinding> findingIdsToFindings, FindingBlacklistIndex blacklistIndex, EFindingBlacklistType blacklistType, String branch) throws StorageException, BadRequestException, NotFoundException {
        ArrayList<FindingBlacklistEvent> blacklistEvents = new ArrayList<FindingBlacklistEvent>();
        for (Pair pair : findingIdsToFindings) {
            String findingId = (String)pair.getFirst();
            UserResolvedFindingBlacklistInfo blacklistInfo = this.getBlacklistedFindingInfo(findingId, new UnresolvedCommitDescriptor(branch, Long.MAX_VALUE));
            if (blacklistInfo == null) {
                LOGGER.warn("Request to unflag finding {}, but the finding is no longer flagged. Skipping.", (Object)findingId);
                continue;
            }
            if (blacklistType != null && blacklistInfo.getInfo().getType() != blacklistType) {
                String requiredBlacklistTypeName = blacklistType.getReadableName();
                throw new BadRequestException("Finding " + findingId + " is not of " + requiredBlacklistTypeName + " type. This endpoint can only remove findings of " + requiredBlacklistTypeName + " type.");
            }
            TrackedFinding trackedFinding = (TrackedFinding)pair.getSecond();
            if (trackedFinding == null) {
                LOGGER.warn("Could not unflag finding {} because it no longer exists. Skipping.", (Object)findingId);
                continue;
            }
            blacklistEvents.add(FindingBlacklistEvent.createRemovedEvent((String)findingId, (String)trackedFinding.getMessage(), (String)this.getUser().getUsername(), (String)trackedFinding.getLocation().getUniformPath(), (FindingBlacklistInfo)blacklistIndex.getBlacklistInfo(findingId)));
        }
        this.createFlaggingCommitAndSchedule(branch, blacklistEvents);
    }

    private void addFindingsToBlacklist(PairList<String, TrackedFinding> findingIdsToFindings, FindingBlacklistRequestBody findingBlacklistRequestBody, EFindingBlacklistType blacklistType, String branch) throws StorageException, BadRequestException, NotFoundException {
        long timestamp = DateTimeUtils.millisNow();
        String username = this.getUser().getUsername();
        ArrayList<FindingBlacklistEvent> blacklistEvents = new ArrayList<FindingBlacklistEvent>();
        ArrayList<String> nonExistentFindingIds = new ArrayList<String>();
        for (Pair pair : findingIdsToFindings) {
            String findingId = (String)pair.getFirst();
            TrackedFinding trackedFinding = (TrackedFinding)pair.getSecond();
            if (trackedFinding == null) {
                nonExistentFindingIds.add(findingId);
                continue;
            }
            blacklistEvents.add(FindingBlacklistEvent.createAddedEvent((String)findingId, (String)trackedFinding.getMessage(), (String)username, (String)trackedFinding.getLocation().getUniformPath(), (FindingBlacklistInfo)new FindingBlacklistInfo(findingId, timestamp, username, findingBlacklistRequestBody.getRationale(), blacklistType, this.getApprovalState(trackedFinding, timestamp, findingBlacklistRequestBody.shouldAutoApprove()), false)));
        }
        if (!nonExistentFindingIds.isEmpty()) {
            throw new NotFoundException("Could not flag non-existent finding(s): " + String.valueOf(nonExistentFindingIds));
        }
        this.createFlaggingCommitAndSchedule(branch, blacklistEvents);
    }

    private FindingBlacklistInfo.IApprovalState getApprovalState(TrackedFinding finding, long timestamp, boolean autoApprove) throws StorageException {
        FindingExclusionApprovalOption approvalOption = FindingExclusionApprovalOption.getInstance((ProjectOptionIndex)this.openProjectIndex(ProjectOptionIndex.class, null));
        if (!approvalOption.shouldUseApprovalWorkflow(finding)) {
            return new FindingBlacklistInfo.IApprovalState.Approved(this.getUser().getUsername(), timestamp, null);
        }
        if (autoApprove) {
            if (!approvalOption.isAllowSelfApproval()) {
                throw new BadRequestException("It is not allowed to approve own pending exclusions");
            }
            ETrafficLightColor eTrafficLightColor = finding.getAssessment();
            int n = 0;
            switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"RED", "YELLOW"}, (ETrafficLightColor)eTrafficLightColor, n)) {
                case 0: {
                    this.getPermissions().checkProjectPermission(EProjectPermission.APPROVE_RED_FINDINGS_EXCLUSION);
                    break;
                }
                case 1: {
                    this.getPermissions().checkProjectPermission(EProjectPermission.APPROVE_YELLOW_FINDINGS_EXCLUSION);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            return new FindingBlacklistInfo.IApprovalState.Approved(this.getUser().getUsername(), timestamp, null);
        }
        return new FindingBlacklistInfo.IApprovalState.Pending();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createFlaggingCommitAndSchedule(String branch, List<FindingBlacklistEvent> flaggingEvents) throws BadRequestException, StorageException {
        Optional latestCommit = this.openCommitDescriptorIndex().getLatestCommitForBranch(branch);
        if (latestCommit.isEmpty()) {
            throw new BadRequestException("Performing flagging on unknown branch: " + branch);
        }
        Lock lock = this.serviceInfo.getLockProvider().obtainLock(FindingsBlacklistServiceBase.class.getSimpleName());
        lock.lock();
        try {
            long timestamp = this.findNextUnusedTimestamp(branch, DateTimeUtils.millisNow());
            FindingBlacklistCommit findingBlacklistCommit = new FindingBlacklistCommit(new CommitDescriptor(branch, timestamp), flaggingEvents);
            this.storeFindingBlacklistCommitAndScheduleChangeRetriever(findingBlacklistCommit);
        }
        finally {
            lock.unlock();
        }
    }

    private void storeFindingBlacklistCommitAndScheduleChangeRetriever(@NonNull FindingBlacklistCommit findingBlacklistCommit) throws StorageException {
        CommitDescriptor blackListCommit = findingBlacklistCommit.getCommit();
        FindingBlacklistStagingIndex blacklistStagingIndex = this.openProjectIndex(FindingBlacklistStagingIndex.class, HistoryAccessOption.readHeadWriteTimestamp((String)blackListCommit.getBranchName(), (long)blackListCommit.getTimestamp()));
        blacklistStagingIndex.setCommitInfo((Serializable)findingBlacklistCommit);
        this.scheduleChangeRetriever();
    }

    private void scheduleChangeRetriever() throws StorageException {
        InternalProjectId currentInternalId = this.serviceInfo.getInternalId();
        ProjectIndex projectIndex = this.openGlobalIndex(ProjectIndex.class);
        for (InternalProjectId projectId : projectIndex.getRelatedInternalProjectIds(currentInternalId)) {
            ISchedulerCommunicator.getInstance().scheduleExternallyStartedTrigger(this.serviceInfo.getIndexLayer(), projectId, FindingBlacklistChangeRetriever.class);
        }
    }

    private long findNextUnusedTimestamp(String branchName, long timestamp) throws StorageException {
        IBranchingLayer blacklistStagingBranchingLayer = this.openBranchingLayerInProject("finding-blacklist-staging", FindingBlacklistStagingIndex.class);
        while (blacklistStagingBranchingLayer.commitExists(branchName, timestamp)) {
            ++timestamp;
        }
        return timestamp;
    }

    private void checkEditBlacklistPermissions(List<TrackedFinding> findings) throws StorageException {
        for (TrackedFinding finding : findings) {
            if (finding == null || finding.getAssessment() == null) continue;
            switch (finding.getAssessment()) {
                case RED: {
                    this.getPermissions().checkEditRedBlacklistFindings();
                    break;
                }
                case YELLOW: {
                    this.getPermissions().checkEditYellowBlacklistFindings();
                    break;
                }
            }
        }
    }
}

