/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings;

import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.tracking.ExtendedTrackedFinding;
import com.teamscale.service.findings.PaginatedFindingsWithCount;
import com.teamscale.service.findings.options.FindingsExportRequestOptions;
import com.teamscale.service.findings.options.FindingsRequestOptions;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.versioning.PublicApi;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;

public interface IElementFindingsServiceApi {
    public static final String GENERIC_DESCRIPTION = "For recursive queries, these are all findings found in the sub-tree. Filter parameters allow to only retrieve findings in a specific category and/or group. There is an upper limit for the number of returned findings.";
    public static final String BAD_REQUEST_DESCRIPTION = "One of the filter options is invalid.";

    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @PublicApi(since=ETeamscaleVersion.VERSION_5_6_0)
    @Operation(summary="Get findings", description="Gets a list of all findings. Findings can be filtered by path prefix. For recursive queries, these are all findings found in the sub-tree. Filter parameters allow to only retrieve findings in a specific category and/or group. There is an upper limit for the number of returned findings.", tags={"Findings"}, responses={@ApiResponse(responseCode="400", description="One of the filter options is invalid.")})
    public List<ExtendedTrackedFinding> getFindings(@BeanParam FindingsRequestOptions var1) throws StorageException;

    @POST
    @Path(value="with-ids")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @PublicApi(since=ETeamscaleVersion.VERSION_6_0_0)
    @Operation(summary="Get findings with provided ids", description="Gets a list of all findings with provided ids.", tags={"Findings"}, responses={@ApiResponse(responseCode="400", description="One of the filter options is invalid.")})
    public List<TrackedFinding> getFindingsWithIds(@RequestBody List<String> var1, @QueryParam(value="t") @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") UnresolvedCommitDescriptor var2, @Parameter(description="If this is true, only spec item findings are to be shown.") @QueryParam(value="only-spec-item-findings") @DefaultValue(value="false") boolean var3) throws StorageException;

    @GET
    @Path(value="with-count")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get findings with false positive counts", description="Gets a list of all findings with additional information on . For recursive queries, these are all findings found in the sub-tree. Filter parameters allow to only retrieve findings in a specific category and/or group. There is an upper limit for the number of returned findings.", tags={"Findings"}, responses={@ApiResponse(responseCode="400", description="One of the filter options is invalid.")})
    @PublicApi(since=ETeamscaleVersion.VERSION_5_6_0)
    public PaginatedFindingsWithCount getFindingsWithCount(@BeanParam FindingsRequestOptions var1) throws StorageException;

    @GET
    @Path(value="export/{format}")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Export findings", description="Exports findings for the element with the provided uniform path in the given format.", tags={"Findings"}, responses={@ApiResponse(responseCode="400", description="One of the filter options is invalid.")})
    public Response getFindingsExport(@BeanParam FindingsExportRequestOptions var1) throws StorageException;
}

