/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings;

import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import org.conqat.engine.commons.findings.DetachedFinding;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class SetupVerificationServiceUtils {
    private static final Comparator<? super IndexFinding> FINDING_COMPARATOR = Comparator.comparing(DetachedFinding::getLocationString).thenComparing(DetachedFinding::getMessage);

    public static File setupCleanTargetDir(String directoryPath) throws IOException {
        File targetDir = new File(directoryPath);
        if (!targetDir.exists()) {
            FileSystemUtils.ensureDirectoryExists((File)targetDir);
        } else {
            File[] subFiles = targetDir.listFiles();
            CCSMAssert.isNotNull((Object)subFiles, (String)"target directory is not a directory");
            for (File subFile : subFiles) {
                FileSystemUtils.deleteRecursively((File)subFile);
            }
        }
        return targetDir;
    }

    public static void printVersionInformation(StringBuilder resultMessage, String defaultExecutableName, String executableName, String expectedVersion, String vmPropertyName) {
        resultMessage.append("Using executable ").append(executableName);
        resultMessage.append("\n");
        resultMessage.append("The default executable is ").append(defaultExecutableName).append(".\nIf Teamscale should use another executable, configure it via JVM parameter ").append(vmPropertyName).append(".\nTo use this JVM option, add -D").append(vmPropertyName).append("=\\\"C:\\path-to-linter\\linter.exe\\\" to config/jvm.properties in your Teamscale setup.\n");
        resultMessage.append("Required version ").append(expectedVersion);
        resultMessage.append("\n");
        resultMessage.append("Verify version...");
    }

    public static boolean linesAreEqualAnyOrder(String actualFindings, String expectedFindings) {
        List actualLines = StringUtils.splitLinesAsList((String)actualFindings);
        List expectedLines = StringUtils.splitLinesAsList((String)expectedFindings);
        if (actualLines.size() != expectedLines.size()) {
            return false;
        }
        for (String line : expectedLines) {
            if (actualLines.contains(line)) continue;
            return false;
        }
        return true;
    }

    public static String formatFindingsString(List<IndexFinding> findings) {
        StringBuilder formattedFindings = new StringBuilder();
        for (IndexFinding finding : CollectionUtils.sort(findings, FINDING_COMPARATOR)) {
            formattedFindings.append("\t").append(finding.getMessage()).append(" at ").append(finding.getLocation().toLocationString()).append("\n");
        }
        return formattedFindings.toString();
    }

    private SetupVerificationServiceUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

