/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.metrics.treemap;

import com.teamscale.core.index.CommitAssociatedObjectBase;
import com.teamscale.core.metrics.schema.MetricSchemaRetrieverFactory;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.user.User;
import com.teamscale.index.repository.ECommitType;
import com.teamscale.index.repository.RepositoryLogEntryAggregate;
import com.teamscale.index.repository.RepositoryLogFileEntry;
import com.teamscale.index.repository.RepositoryLogFileIndex;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.index.resource.VirtualCodePathUtils;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import com.teamscale.index.resource.retrieval_strategy.MetricRetrievalStrategyFactory;
import com.teamscale.index.testgap.treemap.TreeMapNode;
import com.teamscale.service.base.TimeRange;
import com.teamscale.service.base.TimeRangeResourceServiceQueryOptions;
import com.teamscale.service.findings.DeltaAnalysisServiceBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.metrics.treemap.builder.ChangeTreeMapBuilder;
import com.teamscale.service.metrics.treemap.builder.TreeMapBuilderException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/change-treemap")
public class ChangeTreeMapService
extends DeltaAnalysisServiceBase {
    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get change treemap", description="Retrieves a treemap of change frequencies.", tags={"Delta"}, responses={@ApiResponse(responseCode="400", description="Value for the area metric parameter must be positive."), @ApiResponse(responseCode="400", description="Neither start timestamp nor time range provided."), @ApiResponse(responseCode="400", description="Provided end timestamp is smaller than start timestamp.")})
    public TreeMapNode getChangeTreemap(@Parameter(description="The index of the metric used to determine the area of the displayed nodes.") @QueryParam(value="area-metric") int areaMetric, @BeanParam TimeRangeResourceServiceQueryOptions timeRangeParameters) throws StorageException {
        if (areaMetric < 0) {
            throw new BadRequestException("Value " + areaMetric + " for parameter area-metric must be positive");
        }
        TimeRange range = this.createTimeRange(timeRangeParameters);
        CommitDescriptor start = range.start().cloneWithIncrementedTimestamp();
        CommitDescriptor end = range.end().cloneWithIncrementedTimestamp();
        UniformPath uniformPath = timeRangeParameters.getUniformPath();
        Map<UniformPath, Integer> changeCount = this.getChangeCount(start, end, uniformPath, uniformPath.isSpecItemPath());
        IMetricRetrievalStrategy metricRetrievalStrategy = MetricRetrievalStrategyFactory.getStrategy((UniformPath.EType)uniformPath.getType(), (ProjectStorageSystem)this.getProjectStorageSystem(), (GlobalStorageSystem)this.getGlobalStorageSystem(), (User)this.getUser(), (MetricSchemaRetrieverFactory)new MetricSchemaRetrieverFactory((ProjectStorageSystem)this.getProjectStorageSystem()));
        ChangeTreeMapBuilder changeTreeMapBuilder = new ChangeTreeMapBuilder(HistoryAccessOption.readCommit((CommitDescriptor)start), metricRetrievalStrategy, HistoryAccessOption.readCommit((CommitDescriptor)end), areaMetric, changeCount);
        try {
            return changeTreeMapBuilder.buildTreeMap(uniformPath);
        }
        catch (TreeMapBuilderException e) {
            throw new InternalServerErrorException("Exception during creation of treemap.", (Throwable)((Object)e));
        }
    }

    private Map<UniformPath, Integer> getChangeCount(CommitDescriptor start, CommitDescriptor end, UniformPath path, boolean isSpecItemDelta) throws StorageException {
        RepositoryLogFileIndex logFileIndex = this.openProjectIndex(RepositoryLogFileIndex.class, null);
        List<CommitDescriptor> commits = this.filterCommits(this.getRelevantCommits(start, end, path, isSpecItemDelta));
        if (path.isVirtualCodePath()) {
            return this.getChangeCountForVirtualPath(path, logFileIndex, commits, HistoryAccessOption.readCommit((CommitDescriptor)end));
        }
        CounterSet result = new CounterSet();
        for (Map.Entry entry : logFileIndex.getCodePathsByCommits(commits, path.toStringAsMigrationFrontier())) {
            ((Set)entry.getValue()).stream().filter(arg_0 -> ((UniformPath)path).hasDescendant(arg_0)).forEach(arg_0 -> ((CounterSet)result).inc(arg_0));
        }
        return result.toMap();
    }

    private List<CommitDescriptor> filterCommits(List<CommitDescriptor> commits) throws StorageException {
        RepositoryLogIndex repositoryLogIndex = this.openProjectIndex(RepositoryLogIndex.class, null);
        List repositoryLogEntries = repositoryLogIndex.getEntries(commits);
        return CollectionUtils.filterAndMap((Collection)repositoryLogEntries, ChangeTreeMapService::isCodeOrArchitectureChange, CommitAssociatedObjectBase::getCommit);
    }

    private static boolean isCodeOrArchitectureChange(RepositoryLogEntryAggregate logEntry) {
        Set commitTypes = logEntry.getCommitTypes();
        return commitTypes != null && (commitTypes.contains(ECommitType.CODE_COMMIT) || commitTypes.contains(ECommitType.ARCHITECTURE_CHANGE));
    }

    private Map<UniformPath, Integer> getChangeCountForVirtualPath(UniformPath uniformPath, RepositoryLogFileIndex logFileIndex, List<CommitDescriptor> commits, HistoryAccessOption historyAccessOption) throws StorageException {
        VirtualCodePathUtils.IVirtualPathLookup pathInTreemapCalculator = VirtualCodePathUtils.getVirtualPathLookup((UniformPath)uniformPath, (ProjectStorageSystem)this.getProjectStorageSystem(), (HistoryAccessOption)historyAccessOption);
        CounterSet result = new CounterSet();
        for (RepositoryLogFileEntry entry : logFileIndex.getEntriesByCommits(commits)) {
            pathInTreemapCalculator.lookupVirtualPath(entry.getUniformPath()).ifPresent(arg_0 -> ((CounterSet)result).inc(arg_0));
        }
        return result.toMap();
    }
}

