/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.permissions;

import com.teamscale.core.permissions.PermissionIndex;
import com.teamscale.core.permissions.PermissionUtils;
import com.teamscale.core.permissions.RoleChange;
import com.teamscale.core.permissions.RolesWithAssignments;
import com.teamscale.core.permissions.roles.EBasicPermission;
import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.core.permissions.roles.EBasicRole;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.Set;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

@Path(value="api/roles/basic-role-assignments")
public class BasicRoleAssignmentsService
extends ApiBase {
    @GET
    @Path(value="{instance}")
    @RequiresNoPermission(description="Requires the basic permission to \"Assign Roles\"")
    @Operation(summary="Get basic roles assigned to an instance", description="Returns all basic roles with assignments.", tags={"Permission"})
    public RolesWithAssignments<EBasicRole> getBasicRoles(@Parameter(description="The instance's id") @PathParam(value="instance") String instanceId, @Parameter(description="Determines the basic permission scope for the instances. Represented by the enum values of EBasicPermissionScope.", required=true) @QueryParam(value="permission-scope") EBasicPermissionScope scope) throws StorageException {
        this.getPermissions().checkBasicPermission(scope, instanceId, EBasicPermission.EDIT_ROLES);
        return new RolesWithAssignments((Set)CollectionUtils.asHashSet((Object[])EBasicRole.values()), this.openGlobalIndex(PermissionIndex.class).getBasicRoles(scope, instanceId));
    }

    @POST
    @Path(value="{instance}")
    @RequiresNoPermission(description="Requires the basic permission to \"Assign Roles\"")
    @Operation(summary="Apply basic role change for instance", description="Applies the instance's role changes sent to the sever.", tags={"Permission"})
    public void postBasicRoleForInstance(@RequestBody(required=true) RoleChange roleChange, @Parameter(description="The instance's id") @PathParam(value="instance") String instanceId, @Parameter(description="Determines the basic permission scope for the instances. Represented by the enum values of EBasicPermissionScope.", required=true) @QueryParam(value="permission-scope") EBasicPermissionScope scope) throws StorageException {
        PermissionUtils.checkRoleChange((RoleChange)roleChange);
        this.getPermissions().createPermissionModifier().changeBasicRoleAssignments(scope, instanceId, roleChange);
    }

    @POST
    @RequiresGlobalPermission(value={EGlobalPermission.EDIT_GLOBAL_ROLES})
    @Operation(summary="Apply basic role change globally", description="Applies the role changes sent to the sever.", tags={"Permission"})
    public void postBasicRoleGlobally(@RequestBody(required=true) RoleChange roleChange, @Parameter(description="Determines the basic permission scope for the instances. Represented by the enum values of EBasicPermissionScope.", required=true) @QueryParam(value="permission-scope") EBasicPermissionScope scope) throws StorageException {
        PermissionUtils.checkRoleChange((RoleChange)roleChange);
        this.getPermissions().createPermissionModifier().changeBasicRoleAssignments(scope, roleChange);
    }
}

