/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.permissions;

import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.permissions.ESubjectType;
import com.teamscale.core.permissions.PermissionIndex;
import com.teamscale.core.permissions.PermissionUtils;
import com.teamscale.core.permissions.RoleChange;
import com.teamscale.core.permissions.ServicePermissions;
import com.teamscale.core.permissions.data.GlobalRolesWithAssignments;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.user.UserGroupIndex;
import com.teamscale.core.user.UserIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.enums.EnumUtils;

@Path(value="api/roles/global-role-assignments")
public class GlobalRoleAssignmentsService
extends ApiBase {
    @GET
    @Path(value="{subject}")
    @RequiresGlobalPermission(value={EGlobalPermission.EDIT_GLOBAL_ROLES})
    @Operation(summary="Get global roles with assignments", description="Returns global and globally assigned roles with possible roles to assign.", tags={"Permission"})
    public GlobalRolesWithAssignments getGlobalRolesWithAssignments(@Parameter(description="The id of the subject.") @PathParam(value="subject") String subjectId, @Parameter(description="The ESubjectType of the subject.") @QueryParam(value="subject-type") String type) throws StorageException, BadRequestException {
        ESubjectType subjectType = (ESubjectType)EnumUtils.valueOfIgnoreCase(ESubjectType.class, (String)type);
        PermissionIndex permissionIndex = this.openGlobalIndex(PermissionIndex.class);
        this.checkRequest(type, subjectType, subjectId);
        return new GlobalRolesWithAssignments(permissionIndex.getRoleSchema().getGlobalRoles(), permissionIndex.getGlobalRoles(subjectType, subjectId));
    }

    @POST
    @RequiresGlobalPermission(value={EGlobalPermission.EDIT_GLOBAL_ROLES})
    @Operation(summary="Apply role change for global role assignments", description="Updates the role assignments with the given changes.", tags={"Permission"})
    public void postGlobalRoleWithAssignments(@RequestBody(required=true) RoleChange roleChange) throws StorageException {
        PermissionUtils.checkRoleChange((RoleChange)roleChange);
        this.getPermissions().createPermissionModifier().changeGlobalRoleAssignments(roleChange);
    }

    private void checkRequest(String subjectTypeName, ESubjectType subjectType, String subjectId) throws StorageException {
        if (StringUtils.isEmpty((CharSequence)subjectId)) {
            throw new BadRequestException("Query target must be the user, group name or public project ID.");
        }
        if (subjectType == null) {
            throw new BadRequestException("Unknown subject type " + subjectTypeName + ". Must be one of " + Arrays.toString(ESubjectType.values()));
        }
        PermissionUtils.checkViewOrReadPermissionScopeForTargetSubject((ServicePermissions)this.getPermissions(), (ESubjectType)subjectType, (String)subjectId);
        PermissionUtils.validateSubjectTypeAndId((ESubjectType)subjectType, (String)subjectId, () -> this.openGlobalIndex(UserIndex.class), () -> this.openGlobalIndex(UserGroupIndex.class), () -> this.openGlobalIndex(ProjectIndex.class));
    }
}

