/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project;

import com.teamscale.core.analysis.configuration.index.AnalysisProfileIndex;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.log.AuditLogs;
import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.external.input.AnalysisProfileUpdater;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.logging.ICriticalEventLogger;
import com.teamscale.service.framework.versioning.PublicApi;
import com.teamscale.service.project.ProjectServiceUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/{project}/reanalysis")
public class ProjectReanalysisService
extends ApiBase {
    @Context
    private ICriticalEventLogger criticalEventLogger;

    @POST
    @RequiresProjectPermission(value={EProjectPermission.EDIT})
    @PublicApi(since=ETeamscaleVersion.VERSION_5_9_0)
    @Operation(summary="Trigger project reanalysis", description="Triggers reanalysis of the project specified in the path parameter.", tags={"Project"})
    public void triggerReanalysis(@PathParam(value="project") PublicProjectId projectId, @Parameter(description="Indicates whether to only update the findings schema without re-analysis.") @QueryParam(value="only-findings-schema-update") boolean onlyFindingsSchemaUpdate, @Parameter(description="The name of the analysis profile for which the schema should be updated.") @QueryParam(value="analysis-profile-name") String analysisProfileName, @Parameter(description="Whether the project should be validated when triggering the reanalysis") @QueryParam(value="validate-project") @DefaultValue(value="true") boolean validateProject) throws StorageException {
        if (onlyFindingsSchemaUpdate) {
            AnalysisProfileIndex analysisProfileIndex = this.openGlobalIndex(AnalysisProfileIndex.class);
            AnalysisProfileUpdater.updateFindingsSchema((IProjectId)projectId, (String)analysisProfileName, (AnalysisProfileIndex)analysisProfileIndex, (IndexLayer)this.getIndexLayer());
        } else {
            InternalProjectId internalProjectId = this.openGlobalIndex(ProjectIndex.class).resolveToInternalId((IProjectId)projectId);
            ProjectServiceUtils.triggerReanalysis(internalProjectId, this.serviceInfo, validateProject);
        }
        this.criticalEventLogger.logCriticalEventMessage((IProjectId)projectId, "Project reanalysis event");
        AuditLogs.reanalysisTriggered((String)projectId.projectId);
    }
}

