/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.repository;

import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.cache.Cache;
import com.teamscale.service.framework.cache.etag.AnalysisStateContributor;
import com.teamscale.service.framework.cache.etag.RequestContributor;
import com.teamscale.service.framework.versioning.PublicApi;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.Optional;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/{project}/default-branch")
public class ProjectDefaultBranchService
extends ApiBase {
    @GET
    @PublicApi(since=ETeamscaleVersion.VERSION_6_5_0)
    @Operation(summary="Get the first branch name to be displayed in the UI.", description="Get the first branch name to be displayed in the UI. This is either the preselected UI branch or the default branch.", tags={"Project"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Cache(maxAge=1, eTagContributors={AnalysisStateContributor.class, RequestContributor.class})
    public String getFirstUIBranchNameForProject(@PathParam(value="project") PublicProjectId projectId) throws StorageException {
        return this.openGlobalIndex(ProjectIndex.class).tryResolveProject((IProjectId)projectId).flatMap(projectInfo -> Optional.ofNullable(projectInfo.getPreselectedUIBranch())).orElse(this.getDefaultBranchName());
    }
}

