/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.search;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.teamscale.commons.lang.ToStringHelpers;
import com.teamscale.commons.links.TeamscaleCommitLinkProvider;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.metrics.schema.MetricSchemaRetrieverFactory;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.user.User;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import com.teamscale.index.resource.retrieval_strategy.MetricRetrievalStrategyFactory;
import com.teamscale.service.audit.AuditUtils;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.cache.Cache;
import com.teamscale.service.framework.cache.etag.AnalysisStateContributor;
import com.teamscale.service.framework.cache.etag.BaseUrlContributor;
import com.teamscale.service.framework.cache.etag.RequestContributor;
import com.teamscale.service.framework.util.CsvServiceUtils;
import com.teamscale.service.metrics.treemap.FilteredTreeMapWrapper;
import com.teamscale.service.metrics.treemap.TreemapQueryOptions;
import com.teamscale.service.metrics.treemap.builder.TreeMapBuilderException;
import com.teamscale.service.search.AdvancedCodeSearchTreeMapBuilder;
import com.teamscale.service.search.SearchServiceBase;
import com.teamscale.service.search.result.SearchHitLocation;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.resource.text.filter.base.Deletion;
import org.conqat.engine.resource.text.filter.util.StringOffsetTransformer;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.region.LineBasedRegion;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jspecify.annotations.Nullable;
import org.supercsv.io.CsvListWriter;

@Path(value="api/projects/{project}/audit/code-search")
@Cache(maxAge=1, eTagContributors={AnalysisStateContributor.class, RequestContributor.class, BaseUrlContributor.class})
public class AdvancedCodeSearchService
extends SearchServiceBase {
    @GET
    @Path(value="match-list-and-treemap")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="List the code search match results and returns a treemap.", description="Lists all code search matches result including path and line numbers for a given search term and a max result size. Additionally, return a treemap.", tags={"Audit"})
    public CodeSearchResultsWrapper getCodeSearchMatchResultAndTreemap(@Parameter(description="Uniform path to retrieve files for", required=true, allowEmptyValue=true) @QueryParam(value="uniform-path") UniformPath uniformPath, @Parameter(description="The project ID.") @PathParam(value="project") PublicProjectId projectId, @BeanParam TreemapQueryOptions treemapRequestOptions, @Parameter(required=true) @QueryParam(value="search-term") String searchTerm, @QueryParam(value="token-classes") Set<ETokenType.ETokenClass> tokenClasses, @QueryParam(value="is-color-gradation-active") boolean isColorGradationActive, @Parameter(description="Result list size limit (or 0 for no limit)") @QueryParam(value="preview-size") int previewSize, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit) throws StorageException, TreeMapBuilderException {
        List<CodeSearchMatchResult> matchListResult;
        if (previewSize < 0 || StringUtils.isEmpty((String)searchTerm)) {
            return new CodeSearchResultsWrapper(Collections.emptyList(), null);
        }
        if (tokenClasses.isEmpty()) {
            tokenClasses = EnumSet.allOf(ETokenType.ETokenClass.class);
        }
        if ((matchListResult = this.getMatchListResult(uniformPath, Pattern.compile(searchTerm), tokenClasses, Integer.MAX_VALUE, commit)).isEmpty()) {
            return new CodeSearchResultsWrapper(matchListResult, null);
        }
        FilteredTreeMapWrapper treemap = this.buildTreemapWithResults(commit, uniformPath, treemapRequestOptions, searchTerm, isColorGradationActive, matchListResult, projectId);
        int previewListSize = previewSize == 0 ? Integer.MAX_VALUE : previewSize;
        return new CodeSearchResultsWrapper(matchListResult.stream().limit(previewListSize).toList(), treemap);
    }

    private FilteredTreeMapWrapper buildTreemapWithResults(UnresolvedCommitDescriptor commit, UniformPath uniformPath, TreemapQueryOptions treemapRequestOptions, String searchTerm, boolean isColorGradationActive, List<CodeSearchMatchResult> matchListResult, PublicProjectId project) throws StorageException, TreeMapBuilderException {
        HistoryAccessOption historyAccessOption = this.determineHistoryOption(commit);
        IMetricRetrievalStrategy metricRetrievalStrategy = MetricRetrievalStrategyFactory.getStrategy((UniformPath.EType)uniformPath.getType(), (ProjectStorageSystem)this.getProjectStorageSystem(), (GlobalStorageSystem)this.getGlobalStorageSystem(), (User)this.getUser(), (MetricSchemaRetrieverFactory)new MetricSchemaRetrieverFactory((ProjectStorageSystem)this.getProjectStorageSystem()));
        this.setAreaAndColorIndex(treemapRequestOptions, uniformPath, project);
        treemapRequestOptions.adjustTreemapRequestOptions(metricRetrievalStrategy.getMetricDirectorySchema(), false);
        TokenElementIndex tokenIndex = this.openProjectIndex(TokenElementIndex.class, "content", historyAccessOption);
        AdvancedCodeSearchTreeMapBuilder codeSearchTreeMapBuilder = new AdvancedCodeSearchTreeMapBuilder(treemapRequestOptions.includePattern, treemapRequestOptions.excludePattern, metricRetrievalStrategy, historyAccessOption, treemapRequestOptions.areaMetricIndex, treemapRequestOptions.colorMetricIndex, treemapRequestOptions.colorMetricDefaultValue, treemapRequestOptions.baseColor, searchTerm, tokenIndex, isColorGradationActive, matchListResult);
        return codeSearchTreeMapBuilder.getWrapper(uniformPath);
    }

    @GET
    @Path(value="export")
    @Operation(summary="export code search result", description="Downloads code search matches result list as CSV", tags={"Audit"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public Response exportCodeMatchResult(@Parameter(description="Uniform path to retrieve files for", required=true, allowEmptyValue=true) @QueryParam(value="uniform-path") UniformPath uniformPath, @Parameter(required=true) @QueryParam(value="search-term") String searchTerm, @QueryParam(value="token-classes") Set<ETokenType.ETokenClass> tokenClasses, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit) throws StorageException {
        List<CodeSearchMatchResult> matchListResult = this.getMatchListResult(uniformPath, Pattern.compile(searchTerm), tokenClasses, Integer.MAX_VALUE, commit);
        TeamscaleCommitLinkProvider linkProvider = new TeamscaleCommitLinkProvider(this.serviceInfo.getRequestBaseUri().toString(), this.serviceInfo.getPrimaryPublicId(), null);
        return CsvServiceUtils.createCsvResponse((String)("match_result-" + FileSystemUtils.toValidFileName((String)searchTerm)), csvListWriter -> AdvancedCodeSearchService.createCsvContent(matchListResult, csvListWriter, linkProvider));
    }

    private static void createCsvContent(List<CodeSearchMatchResult> matchListResult, CsvListWriter writer, TeamscaleCommitLinkProvider linkProvider) throws IOException {
        writer.writeHeader(new String[]{"Match Region", "File Location", "Line Number", "Offset", "Link to Location"});
        for (CodeSearchMatchResult result : matchListResult) {
            String url = linkProvider.createLinkToFile(result.uniformPath, result.lineBasedRegion);
            writer.write(new Object[]{result.matchRegion, result.uniformPath, result.lineBasedRegion.getStart(), result.hitLocation.getOffset(), url});
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private List<CodeSearchMatchResult> getMatchListResult(UniformPath uniformPath, Pattern searchPattern, Set<ETokenType.ETokenClass> tokenClasses, int sizeLimitOrZero, UnresolvedCommitDescriptor commit) throws StorageException {
        HistoryAccessOption historyAccessOption = this.determineHistoryOption(commit);
        List uniformPaths = CollectionUtils.filter(AuditUtils.getSubUniformPaths((IStorageInfo)this.serviceInfo, historyAccessOption, uniformPath), path -> {
            String uniformPath1 = path.toString();
            return !UniformPathUtils.isArchitectureFile((String)uniformPath1);
        });
        int sizeLimit = sizeLimitOrZero == 0 ? Integer.MAX_VALUE : sizeLimitOrZero;
        List codePaths = CollectionUtils.map((Collection)uniformPaths, UniformPath::resolveToCodePath);
        TokenElementIndex tokenIndex = this.openProjectIndex(TokenElementIndex.class, "content", historyAccessOption);
        ArrayList<CodeSearchMatchResult> results = new ArrayList<CodeSearchMatchResult>();
        for (List pathsInBatch : Lists.partition((List)codePaths, (int)500)) {
            @Nullable List tokenElementsInBatch = tokenIndex.getTokenElementsForPaths(pathsInBatch);
            for (TokenElementInfo elementsInBatch : tokenElementsInBatch) {
                results.addAll(AdvancedCodeSearchService.getMatchesInPath(elementsInBatch, searchPattern, tokenClasses, sizeLimit));
                if (results.size() < sizeLimit) continue;
                return results.stream().limit(sizeLimit).toList();
            }
        }
        return results;
    }

    private static List<CodeSearchMatchResult> getMatchesInPath(@Nullable TokenElementInfo tokenElementInfo, Pattern searchPattern, Set<ETokenType.ETokenClass> tokenClasses, int limit) {
        if (tokenElementInfo == null) {
            return CollectionUtils.emptyList();
        }
        StringOffsetTransformer offsetTransformer = AdvancedCodeSearchService.determineFilteredTokens(tokenClasses, (List<IToken>)tokenElementInfo.getRawTokens());
        return AdvancedCodeSearchService.getMatchesInPath(tokenElementInfo.getText(), searchPattern, tokenElementInfo.getUniformPath(), offsetTransformer, limit);
    }

    private static List<CodeSearchMatchResult> getMatchesInPath(String rawText, Pattern pattern, String path, StringOffsetTransformer offsetTransformer, int limit) {
        String filteredText = offsetTransformer.filterString(rawText);
        List<Integer> lineOffsets = AdvancedCodeSearchService.getLineOffsets(rawText);
        return pattern.matcher(filteredText).results().limit(limit).map(hit -> AdvancedCodeSearchService.constructMatchResult(path, offsetTransformer, lineOffsets, hit)).toList();
    }

    private static CodeSearchMatchResult constructMatchResult(String path, StringOffsetTransformer offsetTransformer, List<Integer> lineOffsets, MatchResult hit) {
        int rawStartOffset = offsetTransformer.getUnfilteredOffset(hit.start());
        int rawEndOffset = offsetTransformer.getUnfilteredOffset(hit.end());
        int startLine = AdvancedCodeSearchService.getLineFromOffset(lineOffsets, rawStartOffset) + 1;
        int endLine = AdvancedCodeSearchService.getLineFromOffset(lineOffsets, rawEndOffset) + 1;
        SearchHitLocation hitLocation = new SearchHitLocation(rawStartOffset, hit.group().length());
        return new CodeSearchMatchResult(hit.group(), path, new LineBasedRegion(startLine, endLine), hitLocation);
    }

    private static StringOffsetTransformer determineFilteredTokens(Set<ETokenType.ETokenClass> tokenClasses, List<IToken> rawTokens) {
        List<Deletion> filterDeletions = rawTokens.stream().filter(token -> !tokenClasses.contains(token.getType().getTokenClass())).map(token -> new Deletion(token.getOffset(), token.getEndOffset() + 1, false)).toList();
        return new StringOffsetTransformer(filterDeletions);
    }

    private static List<Integer> getLineOffsets(String rawText) {
        return Pattern.compile("\n").matcher(StringUtils.normalizeLineSeparatorsPlatformIndependent((String)rawText)).results().map(MatchResult::start).toList();
    }

    private static int getLineFromOffset(List<Integer> lineOffsets, int offset) {
        int index = Collections.binarySearch(lineOffsets, offset);
        if (index < 0) {
            return -index - 1;
        }
        return index;
    }

    static class CodeSearchResultsWrapper {
        private static final String MATCH_LIST_RESULTS_PROPERTY = "matchListResults";
        private static final String MATCHES_TREEMAP_PROPERTY = "matchesTreemap";
        @JsonProperty(value="matchListResults")
        private final List<CodeSearchMatchResult> matchListResults;
        @JsonProperty(value="matchesTreemap")
        private final @Nullable FilteredTreeMapWrapper matchesTreemap;

        @JsonCreator
        public CodeSearchResultsWrapper(@JsonProperty(value="matchListResults") List<CodeSearchMatchResult> matchListResults, @JsonProperty(value="matchesTreemap") @Nullable FilteredTreeMapWrapper matchesTreemap) {
            this.matchListResults = matchListResults;
            this.matchesTreemap = matchesTreemap;
        }

        public List<CodeSearchMatchResult> getMatchListResults() {
            return this.matchListResults;
        }
    }

    static class CodeSearchMatchResult {
        private static final String MATCH_REGION_PROPERTY = "matchRegion";
        private static final String UNIFORM_PATH_PROPERTY = "uniformPath";
        private static final String LINE_BASED_REGION_PROPERTY = "lineBasedRegion";
        private static final String HIT_PROPERTY = "hit";
        @JsonProperty(value="matchRegion")
        private final String matchRegion;
        @JsonProperty(value="uniformPath")
        private final String uniformPath;
        @JsonProperty(value="lineBasedRegion")
        private final LineBasedRegion lineBasedRegion;
        @JsonProperty(value="hit")
        private final SearchHitLocation hitLocation;

        @JsonCreator
        CodeSearchMatchResult(@JsonProperty(value="matchRegion") String matchRegion, @JsonProperty(value="uniformPath") String uniformPath, @JsonProperty(value="lineBasedRegion") LineBasedRegion lineBasedRegion, @JsonProperty(value="hit") SearchHitLocation hitLocation) {
            this.matchRegion = matchRegion;
            this.uniformPath = uniformPath;
            this.lineBasedRegion = lineBasedRegion;
            this.hitLocation = hitLocation;
        }

        public String toString() {
            return ToStringHelpers.toReflectiveStringHelper((Object)this).toString();
        }

        public String getUniformPath() {
            return this.uniformPath;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CodeSearchMatchResult)) {
                return false;
            }
            CodeSearchMatchResult that = (CodeSearchMatchResult)o;
            return Objects.equals(this.lineBasedRegion, that.lineBasedRegion) && Objects.equals(this.matchRegion, that.matchRegion) && Objects.equals(this.getUniformPath(), that.getUniformPath()) && Objects.equals(this.hitLocation, that.hitLocation);
        }

        public int hashCode() {
            return Objects.hash(this.matchRegion, this.getUniformPath(), this.lineBasedRegion, this.hitLocation);
        }
    }
}

