/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.search;

import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import com.teamscale.index.testgap.treemap.TreeMapNode;
import com.teamscale.service.metrics.treemap.FilteredTreeMapWrapper;
import com.teamscale.service.metrics.treemap.builder.MetricTreemapBuilderBase;
import com.teamscale.service.metrics.treemap.builder.MetricTreemapBuilderParameters;
import com.teamscale.service.metrics.treemap.builder.TreeMapBuilderException;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class CodeSearchTreemapBuilderBase
extends MetricTreemapBuilderBase<TreeMapNode> {
    private final String searchQuery;
    private final boolean isColorGradationActive;
    private Map<String, Integer> matchCountByUniformPath;
    private double colorMetricMaxValue;
    protected TreeMapNode treemap;
    protected FilteredTreeMapWrapper treemapWrapper;

    protected CodeSearchTreemapBuilderBase(IMetricRetrievalStrategy metricRetrievalStrategy, HistoryAccessOption historyAccessOption, int areaMetricIndex, MetricTreemapBuilderParameters parameters, String searchQuery, boolean isColorGradationActive) {
        super(metricRetrievalStrategy, historyAccessOption, areaMetricIndex, parameters);
        this.searchQuery = searchQuery;
        this.isColorGradationActive = isColorGradationActive;
    }

    @Override
    protected TreeMapNode createNode(MetricDirectoryEntry entry) {
        double areaMetricValue = entry.getDoubleValue(this.areaMetricIndex);
        if (StringUtils.isEmpty((String)this.searchQuery)) {
            return new TreeMapNode(entry.getUniformPath(), areaMetricValue, "No search term.", Color.WHITE);
        }
        int matchCount = this.matchCountByUniformPath.getOrDefault(entry.getUniformPath(), 0);
        Object searchResult = "Not found";
        if (matchCount == 0) {
            return new TreeMapNode(entry.getUniformPath(), areaMetricValue, (String)searchResult, Color.WHITE);
        }
        searchResult = "Matches " + this.searchQuery + " " + matchCount + " times";
        if (this.isColorGradationActive) {
            return new TreeMapNode(entry.getUniformPath(), areaMetricValue, (String)searchResult, this.determineColorForNumber(matchCount));
        }
        return new TreeMapNode(entry.getUniformPath(), areaMetricValue, (String)searchResult, Color.BLUE);
    }

    @Override
    protected void afterEntryPreparation(List<MetricDirectoryEntry> entries) throws StorageException {
        this.colorMetricMaxValue = 0.0;
        this.matchCountByUniformPath = HashMap.newHashMap(entries.size());
        this.treemapWrapper = StringUtils.isEmpty((String)this.searchQuery) ? new FilteredTreeMapWrapper(new ArrayList<String>(), null, 1, 0, 0, 0) : this.computeSearchCountValues(entries);
    }

    protected FilteredTreeMapWrapper computeSearchCountValues(List<MetricDirectoryEntry> entries) throws StorageException {
        return null;
    }

    @Override
    protected Pair<Double, Double> determineValueRangeForColorMetric(List<MetricDirectoryEntry> entries) {
        return new Pair((Object)0.0, (Object)this.colorMetricMaxValue);
    }

    public FilteredTreeMapWrapper getWrapper(UniformPath uniformPath) throws StorageException, TreeMapBuilderException {
        this.treemap = this.buildTreeMap(uniformPath);
        this.treemapWrapper.setTreemap(this.treemap);
        return this.treemapWrapper;
    }

    protected class SearchHitData {
        protected int affectedLoc = 0;
        protected int affectedFiles = 0;
        protected int overallHits = 0;
        protected ArrayList<String> affectedPaths = new ArrayList();
        protected CounterSet<String> hitsByPath = new CounterSet();

        protected SearchHitData() {
        }

        protected void incrementHitsForPath(String pathName) {
            this.hitsByPath.inc((Object)pathName);
        }

        protected void updateDataForPath(int hitsForPath, MetricDirectoryEntry entry, int locIndex) {
            if (hitsForPath != 0) {
                ++this.affectedFiles;
                this.affectedPaths.add(entry.getUniformPath());
                this.affectedLoc += (int)entry.getDoubleValue(locIndex);
            }
            this.overallHits += hitsForPath;
            CodeSearchTreemapBuilderBase.this.matchCountByUniformPath.put(entry.getUniformPath(), hitsForPath);
            CodeSearchTreemapBuilderBase.this.colorMetricMaxValue = Math.max((double)hitsForPath, CodeSearchTreemapBuilderBase.this.colorMetricMaxValue);
        }
    }
}

