/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.system.performance.debug;

import com.teamscale.core.log.LogIndexBase;
import com.teamscale.core.log.worker.ProjectWorkerLogIndex;
import com.teamscale.core.log.worker.ShortWorkerLog;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.framework.logging.LogServiceUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.Collection;
import java.util.List;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.math.EAggregationStrategy;
import org.conqat.lib.commons.math.MathUtils;

@Path(value="api/system/performance/debug/job-performance.csv")
public class JobPerformanceStatisticsService
extends ApiBase {
    public static final String SEPARATION_PARAMETER = "separation";
    private static final String SEPARATOR = ";";
    private static final EAggregationStrategy[] AGGREGATION_STRATEGIES = new EAggregationStrategy[]{EAggregationStrategy.MIN, EAggregationStrategy.MAX, EAggregationStrategy.MEAN, EAggregationStrategy.MEDIAN};
    private final ListMap<String, Double> runningTimes = new ListMap();
    private final ListMap<String, Integer> inputDeltaSizes = new ListMap();

    @GET
    @Produces(value={"text/csv"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Operation(summary="Get job performance statictics", description="Returns statistics on job execution performance.", responses={@ApiResponse(responseCode="404", description="Could not find the relevant project logs.")}, tags={"Debugging"})
    public String getJobPerfomanceStatistics(@Parameter(description="List of separation criterion. For example, a value of PROJECT will cause statistics in different projects to be reported separately.") @QueryParam(value="separation") List<ESeparationCriterion> separationCriteria) throws StorageException {
        for (ProjectInfo project : this.getPermissions().getVisibleProjects(false, true)) {
            ProjectWorkerLogIndex logIndex = LogServiceUtils.getProjectWorkerLogIndex((ProjectStorageSystem)this.getProjectStorageSystem(project));
            for (LogIndexBase.EIndexLogLevel level : LogIndexBase.EIndexLogLevel.values()) {
                this.insertEntries(logIndex.getEntries(level, 0L, Long.MAX_VALUE), separationCriteria);
            }
        }
        return this.createResult();
    }

    private void insertEntries(List<ShortWorkerLog> entries, List<ESeparationCriterion> separationCriteria) {
        for (ShortWorkerLog entry : entries) {
            this.insertEntry(entry, separationCriteria);
        }
    }

    private void insertEntry(ShortWorkerLog entry, List<ESeparationCriterion> separationCriteria) {
        StringBuilder nameBuilder = new StringBuilder();
        for (ESeparationCriterion separationCriterion : separationCriteria) {
            if (nameBuilder.length() > 0) {
                nameBuilder.append(":");
            }
            nameBuilder.append(separationCriterion.extractValue(entry));
        }
        String name = nameBuilder.toString();
        this.runningTimes.add((Object)name, (Object)((double)(entry.getFinishTime() - entry.getStartTime()) / 1000.0));
        this.inputDeltaSizes.add((Object)name, (Object)entry.getInputDeltaSize());
    }

    private String createResult() {
        StringBuilder builder = new StringBuilder();
        builder.append("NAME");
        builder.append(SEPARATOR);
        builder.append("FREQUENCY");
        builder.append(SEPARATOR);
        builder.append("OVERALL_TIME");
        JobPerformanceStatisticsService.appendHeadings(builder, "TIME");
        JobPerformanceStatisticsService.appendHeadings(builder, "INPUT_SIZE");
        builder.append("\n");
        for (String key : CollectionUtils.sort((Collection)this.runningTimes.getKeys())) {
            builder.append(key);
            builder.append(SEPARATOR);
            List runningSizes = (List)this.runningTimes.getCollection((Object)key);
            builder.append(runningSizes.size());
            builder.append(SEPARATOR);
            builder.append(MathUtils.sum((Collection)runningSizes));
            JobPerformanceStatisticsService.appendStatistics(builder, runningSizes);
            JobPerformanceStatisticsService.appendStatistics(builder, (List)this.inputDeltaSizes.getCollection((Object)key));
            builder.append("\n");
        }
        return builder.toString();
    }

    private static void appendHeadings(StringBuilder builder, String attributeName) {
        for (EAggregationStrategy aggregationStrategy : AGGREGATION_STRATEGIES) {
            builder.append(SEPARATOR);
            builder.append(aggregationStrategy.name() + "_" + attributeName);
        }
    }

    private static void appendStatistics(StringBuilder builder, List<? extends Number> values) {
        for (EAggregationStrategy aggregationStrategy : AGGREGATION_STRATEGIES) {
            builder.append(SEPARATOR);
            builder.append(aggregationStrategy.getAggregator().aggregate(values));
        }
    }

    public static enum ESeparationCriterion {
        COMMIT{

            @Override
            public String extractValue(ShortWorkerLog entry) {
                CommitDescriptor commit = entry.getAnalyzedCommit();
                if (commit != null) {
                    return commit.toString();
                }
                return "";
            }
        }
        ,
        TRIGGER{

            @Override
            public String extractValue(ShortWorkerLog entry) {
                return entry.getTriggerName();
            }
        }
        ,
        PROJECT{

            @Override
            public String extractValue(ShortWorkerLog entry) {
                IProjectId project = entry.getProjectId();
                if (project != null) {
                    return project.toString();
                }
                return "";
            }
        }
        ,
        WORKER{

            @Override
            public String extractValue(ShortWorkerLog entry) {
                return entry.getWorkerId();
            }
        };


        public abstract String extractValue(ShortWorkerLog var1);
    }
}

