/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.matlab.mat.format;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import us.hebi.matlab.mat.format.BufferAllocator;
import us.hebi.matlab.mat.format.Charsets;
import us.hebi.matlab.mat.types.Sink;
import us.hebi.matlab.mat.types.Source;
import us.hebi.matlab.mat.util.Bytes;
import us.hebi.matlab.mat.util.Casts;
import us.hebi.matlab.mat.util.Preconditions;

public enum CharEncoding {
    UInt16(Charsets.US_ASCII, Charsets.US_ASCII),
    Utf8(Charsets.UTF_8, Charsets.UTF_8),
    Utf16(Charsets.UTF_16LE, Charsets.UTF_32BE),
    Utf32(Charsets.UTF_32LE, Charsets.UTF_32BE);

    private final Charset charsetLE;
    private final Charset charsetBE;
    private static final int TMP_BUFFER_SIZE = 8192;
    private static final ThreadLocal<ByteBuffer> buffer;
    private static final ThreadLocal<CharBuffer> charBuffer;

    private CharEncoding(Charset charsetLE, Charset charsetBE) {
        this.charsetLE = charsetLE;
        this.charsetBE = charsetBE;
    }

    static String parseAsciiString(byte[] buffer) {
        return CharEncoding.parseAsciiString(buffer, 0, buffer.length);
    }

    static String parseAsciiString(byte[] buffer, int offset, int maxLength) {
        int length;
        for (length = Bytes.findFirst(buffer, offset, maxLength, 0, maxLength); length > 0 && buffer[length - 1] == 32; --length) {
        }
        return length == 0 ? "" : new String(buffer, offset, length, Charsets.US_ASCII);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CloseableCharBuffer readCharBuffer(Source source, int numBytes, BufferAllocator bufferAllocator) throws IOException {
        if (this == UInt16) {
            int numChars = Casts.checkedDivide(numBytes, 2);
            CloseableCharBuffer buffer = CloseableCharBuffer.allocate(bufferAllocator, numChars);
            ByteBuffer bytes = buffer.bytes;
            bytes.order(source.order());
            source.readByteBuffer(bytes);
            Preconditions.checkState(!bytes.hasRemaining(), "read incorrect number of bytes");
            bytes.rewind();
            return buffer;
        }
        ByteBuffer tmp = numBytes > 8192 ? bufferAllocator.allocate(numBytes) : buffer.get();
        try {
            tmp.position(0);
            tmp.limit(numBytes);
            source.readByteBuffer(tmp);
            Preconditions.checkState(!tmp.hasRemaining(), "read incorrect number of bytes");
            tmp.rewind();
            CharBuffer tmpChars = charBuffer.get();
            CharsetDecoder decoder = this.newDecoder(source.order());
            int numChars = 0;
            do {
                tmpChars.clear();
                CoderResult status = decoder.decode(tmp, tmpChars, true);
                if (status.isError()) {
                    status.throwException();
                }
                numChars += tmpChars.position();
            } while (tmp.hasRemaining());
            CloseableCharBuffer buffer = CloseableCharBuffer.allocate(bufferAllocator, numChars);
            CharBuffer chars = buffer.chars;
            if (numChars == tmpChars.position()) {
                tmpChars.flip();
                chars.put(tmpChars);
            } else {
                tmp.rewind();
                decoder.reset();
                CoderResult status = decoder.decode(tmp, chars, true);
                if (status.isError()) {
                    status.throwException();
                }
            }
            Preconditions.checkState(!chars.hasRemaining(), "did not read expected number of characters");
            chars.flip();
            CloseableCharBuffer closeableCharBuffer = buffer;
            return closeableCharBuffer;
        }
        finally {
            if (numBytes > 8192) {
                bufferAllocator.release(tmp);
            }
        }
    }

    public int getEncodedLength(CharBuffer chars) {
        int position = chars.position();
        try {
            if (this == UInt16) {
                int n = chars.remaining() * 2;
                return n;
            }
            int n = this.writeEncodedUtf(chars, null);
            return n;
        }
        catch (IOException ioe) {
            throw new AssertionError((Object)ioe);
        }
        finally {
            chars.position(position);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeEncoded(CharBuffer chars, Sink sink) throws IOException {
        int position = chars.position();
        try {
            if (this == UInt16) {
                this.writeEncodedUInt16(chars, sink);
            } else {
                this.writeEncodedUtf(Preconditions.checkNotNull(chars), Preconditions.checkNotNull(sink));
            }
        }
        finally {
            chars.position(position);
        }
    }

    private void writeEncodedUInt16(CharBuffer chars, Sink sink) throws IOException {
        while (chars.hasRemaining()) {
            sink.writeShort((short)chars.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int writeEncodedUtf(CharBuffer chars, Sink sink) throws IOException {
        if (!chars.hasRemaining()) {
            return 0;
        }
        ByteOrder order = sink == null ? ByteOrder.nativeOrder() : sink.order();
        CharsetEncoder encoder = this.newEncoder(order);
        ByteBuffer tmp = buffer.get();
        try {
            CoderResult status;
            int length = 0;
            do {
                tmp.clear();
                status = encoder.encode(chars, tmp, true);
                if (status.isError()) {
                    status.throwException();
                }
                if (sink != null) {
                    tmp.flip();
                    sink.writeByteBuffer(tmp);
                }
                length += tmp.position();
            } while (status.isOverflow());
            tmp.clear();
            status = encoder.flush(tmp);
            if (status.isError() || status.isOverflow()) {
                status.throwException();
            }
            if (sink != null) {
                tmp.flip();
                sink.writeByteBuffer(tmp);
            }
            int n = length += tmp.position();
            return n;
        }
        finally {
            encoder.reset();
        }
    }

    private Charset getCharset(ByteOrder order) {
        Charset charset;
        Charset charset2 = charset = order == ByteOrder.BIG_ENDIAN ? this.charsetBE : this.charsetLE;
        if (charset == null) {
            throw new AssertionError((Object)("Charset '" + (Object)((Object)this) + "' is not supported on this platform"));
        }
        return charset;
    }

    private CharsetEncoder newEncoder(ByteOrder order) {
        return this.getCharset(order).newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    private CharsetDecoder newDecoder(ByteOrder order) {
        return this.getCharset(order).newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    static {
        buffer = new ThreadLocal<ByteBuffer>(){

            @Override
            protected ByteBuffer initialValue() {
                return ByteBuffer.allocate(8192);
            }
        };
        charBuffer = new ThreadLocal<CharBuffer>(){

            @Override
            protected CharBuffer initialValue() {
                return CharBuffer.allocate(4096);
            }
        };
    }

    static class CloseableCharBuffer
    implements Closeable {
        final CharBuffer chars;
        final ByteBuffer bytes;
        final BufferAllocator bufferAllocator;

        static CloseableCharBuffer wrap(String value) {
            return new CloseableCharBuffer(CharBuffer.wrap(value), null, null);
        }

        static CloseableCharBuffer allocate(BufferAllocator bufferAllocator, int numChars) {
            ByteBuffer bytes = bufferAllocator.allocate(numChars * 2);
            bytes.order(ByteOrder.nativeOrder());
            CharBuffer chars = bytes.asCharBuffer();
            Preconditions.checkState(chars.remaining() == numChars, "invalid buffer size");
            return new CloseableCharBuffer(chars, bytes, bufferAllocator);
        }

        static CloseableCharBuffer allocate(BufferAllocator bufferAllocator, int numChars, char fillChar) {
            return CloseableCharBuffer.allocate(bufferAllocator, numChars).fill(fillChar);
        }

        CloseableCharBuffer fill(char c) {
            for (int i = 0; i < this.chars.limit(); ++i) {
                this.chars.put(i, c);
            }
            return this;
        }

        private CloseableCharBuffer(CharBuffer chars, ByteBuffer bytes, BufferAllocator bufferAllocator) {
            this.chars = chars;
            this.bytes = bytes;
            this.bufferAllocator = bufferAllocator;
        }

        @Override
        public void close() {
            if (this.bytes != null && this.bufferAllocator != null) {
                this.bufferAllocator.release(this.bytes);
            }
        }
    }
}

