/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tasks;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.unboundidds.tasks.FailedDependencyAction;
import com.unboundid.ldap.sdk.unboundidds.tasks.Task;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskException;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskMessages;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskProperty;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class SearchTask
extends Task {
    @NotNull
    static final String SEARCH_TASK_CLASS = "com.unboundid.directory.server.tasks.SearchTask";
    @NotNull
    private static final String ATTR_BASE_DN = "ds-task-search-base-dn";
    @NotNull
    private static final String ATTR_SCOPE = "ds-task-search-scope";
    @NotNull
    private static final String ATTR_FILTER = "ds-task-search-filter";
    @NotNull
    private static final String ATTR_RETURN_ATTR = "ds-task-search-return-attribute";
    @NotNull
    private static final String ATTR_AUTHZ_DN = "ds-task-search-authz-dn";
    @NotNull
    private static final String ATTR_OUTPUT_FILE = "ds-task-search-output-file";
    @NotNull
    private static final String OC_SEARCH_TASK = "ds-task-search";
    @NotNull
    private static final TaskProperty PROPERTY_BASE_DN = new TaskProperty("ds-task-search-base-dn", TaskMessages.INFO_SEARCH_TASK_DISPLAY_NAME_BASE_DN.get(), TaskMessages.INFO_SEARCH_TASK_DESCRIPTION_BASE_DN.get(), String.class, true, false, false);
    @NotNull
    private static final Object[] ALLOWED_SCOPE_VALUES = new Object[]{"base", "baseobject", "0", "one", "onelevel", "singlelevel", "1", "sub", "subtree", "wholesubtree", "2", "subord", "subordinate", "subordinatesubtree", "3"};
    @NotNull
    private static final TaskProperty PROPERTY_SCOPE = new TaskProperty("ds-task-search-scope", TaskMessages.INFO_SEARCH_TASK_DISPLAY_NAME_SCOPE.get(), TaskMessages.INFO_SEARCH_TASK_DESCRIPTION_SCOPE.get(), String.class, true, false, false, ALLOWED_SCOPE_VALUES);
    @NotNull
    private static final TaskProperty PROPERTY_FILTER = new TaskProperty("ds-task-search-filter", TaskMessages.INFO_SEARCH_TASK_DISPLAY_NAME_FILTER.get(), TaskMessages.INFO_SEARCH_TASK_DESCRIPTION_FILTER.get(), String.class, true, false, false);
    @NotNull
    private static final TaskProperty PROPERTY_REQUESTED_ATTR = new TaskProperty("ds-task-search-return-attribute", TaskMessages.INFO_SEARCH_TASK_DISPLAY_NAME_RETURN_ATTR.get(), TaskMessages.INFO_SEARCH_TASK_DESCRIPTION_RETURN_ATTR.get(), String.class, false, true, false);
    @NotNull
    private static final TaskProperty PROPERTY_AUTHZ_DN = new TaskProperty("ds-task-search-authz-dn", TaskMessages.INFO_SEARCH_TASK_DISPLAY_NAME_AUTHZ_DN.get(), TaskMessages.INFO_SEARCH_TASK_DESCRIPTION_AUTHZ_DN.get(), String.class, false, false, true);
    @NotNull
    private static final TaskProperty PROPERTY_OUTPUT_FILE = new TaskProperty("ds-task-search-output-file", TaskMessages.INFO_SEARCH_TASK_DISPLAY_NAME_OUTPUT_FILE.get(), TaskMessages.INFO_SEARCH_TASK_DESCRIPTION_NAME_OUTPUT_FILE.get(), String.class, true, false, false);
    private static final long serialVersionUID = -1742374271508548328L;
    @NotNull
    private final Filter filter;
    @NotNull
    private final List<String> attributes;
    @NotNull
    private final SearchScope scope;
    @Nullable
    private final String authzDN;
    @NotNull
    private final String baseDN;
    @NotNull
    private final String outputFile;

    public SearchTask() {
        this.filter = null;
        this.attributes = null;
        this.scope = null;
        this.authzDN = null;
        this.baseDN = null;
        this.outputFile = null;
    }

    public SearchTask(@Nullable String taskID, @NotNull String baseDN, @NotNull SearchScope scope, @NotNull Filter filter, @Nullable List<String> attributes, @NotNull String outputFile) {
        this(taskID, baseDN, scope, filter, attributes, outputFile, null, null, null, null, null, null);
    }

    public SearchTask(@Nullable String taskID, @NotNull String baseDN, @NotNull SearchScope scope, @NotNull Filter filter, @Nullable List<String> attributes, @NotNull String outputFile, @Nullable String authzDN) {
        this(taskID, baseDN, scope, filter, attributes, outputFile, authzDN, null, null, null, null, null);
    }

    public SearchTask(@Nullable String taskID, @NotNull String baseDN, @NotNull SearchScope scope, @NotNull Filter filter, @Nullable List<String> attributes, @NotNull String outputFile, @Nullable String authzDN, @Nullable Date scheduledStartTime, @Nullable List<String> dependencyIDs, @Nullable FailedDependencyAction failedDependencyAction, @Nullable List<String> notifyOnCompletion, @Nullable List<String> notifyOnError) {
        this(taskID, baseDN, scope, filter, attributes, outputFile, authzDN, scheduledStartTime, dependencyIDs, failedDependencyAction, null, notifyOnCompletion, null, notifyOnError, null, null, null);
    }

    public SearchTask(@Nullable String taskID, @NotNull String baseDN, @NotNull SearchScope scope, @NotNull Filter filter, @Nullable List<String> attributes, @NotNull String outputFile, @Nullable String authzDN, @Nullable Date scheduledStartTime, @Nullable List<String> dependencyIDs, @Nullable FailedDependencyAction failedDependencyAction, @Nullable List<String> notifyOnStart, @Nullable List<String> notifyOnCompletion, @Nullable List<String> notifyOnSuccess, @Nullable List<String> notifyOnError, @Nullable Boolean alertOnStart, @Nullable Boolean alertOnSuccess, @Nullable Boolean alertOnError) {
        super(taskID, SEARCH_TASK_CLASS, scheduledStartTime, dependencyIDs, failedDependencyAction, notifyOnStart, notifyOnCompletion, notifyOnSuccess, notifyOnError, alertOnStart, alertOnSuccess, alertOnError);
        Validator.ensureNotNull(baseDN, scope, filter, outputFile);
        this.baseDN = baseDN;
        this.scope = scope;
        this.filter = filter;
        this.outputFile = outputFile;
        this.authzDN = authzDN;
        this.attributes = attributes == null ? Collections.emptyList() : Collections.unmodifiableList(attributes);
    }

    public SearchTask(@NotNull Entry entry) throws TaskException {
        super(entry);
        this.baseDN = entry.getAttributeValue(ATTR_BASE_DN);
        if (this.baseDN == null) {
            throw new TaskException(TaskMessages.ERR_SEARCH_TASK_ENTRY_NO_BASE_DN.get(entry.getDN()));
        }
        String scopeStr = StaticUtils.toLowerCase(entry.getAttributeValue(ATTR_SCOPE));
        if (scopeStr == null) {
            throw new TaskException(TaskMessages.ERR_SEARCH_TASK_ENTRY_NO_SCOPE.get(entry.getDN()));
        }
        if (scopeStr.equals("base") || scopeStr.equals("baseobject") || scopeStr.equals("0")) {
            this.scope = SearchScope.BASE;
        } else if (scopeStr.equals("one") || scopeStr.equals("onelevel") || scopeStr.equals("singlelevel") || scopeStr.equals("1")) {
            this.scope = SearchScope.ONE;
        } else if (scopeStr.equals("sub") || scopeStr.equals("subtree") || scopeStr.equals("wholesubtree") || scopeStr.equals("2")) {
            this.scope = SearchScope.SUB;
        } else if (scopeStr.equals("subord") || scopeStr.equals("subordinate") || scopeStr.equals("subordinatesubtree") || scopeStr.equals("3")) {
            this.scope = SearchScope.SUBORDINATE_SUBTREE;
        } else {
            throw new TaskException(TaskMessages.ERR_SEARCH_TASK_ENTRY_INVALID_SCOPE.get(entry.getDN(), scopeStr));
        }
        String filterStr = entry.getAttributeValue(ATTR_FILTER);
        if (filterStr == null) {
            throw new TaskException(TaskMessages.ERR_SEARCH_TASK_ENTRY_NO_FILTER.get(entry.getDN()));
        }
        try {
            this.filter = Filter.create(filterStr);
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw new TaskException(TaskMessages.ERR_SEARCH_TASK_ENTRY_INVALID_FILTER.get(entry.getDN(), filterStr), le);
        }
        String[] attrs = entry.getAttributeValues(ATTR_RETURN_ATTR);
        this.attributes = attrs == null ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList(attrs));
        this.authzDN = entry.getAttributeValue(ATTR_AUTHZ_DN);
        this.outputFile = entry.getAttributeValue(ATTR_OUTPUT_FILE);
        if (this.outputFile == null) {
            throw new TaskException(TaskMessages.ERR_SEARCH_TASK_ENTRY_NO_OUTPUT_FILE.get(entry.getDN()));
        }
    }

    public SearchTask(@NotNull Map<TaskProperty, List<Object>> properties) throws TaskException {
        super(SEARCH_TASK_CLASS, properties);
        Filter tmpFilter = null;
        SearchScope tmpScope = null;
        String tmpAuthzDN = null;
        String tmpBaseDN = null;
        String tmpFile = null;
        String[] tmpAttrs = null;
        for (Map.Entry<TaskProperty, List<Object>> entry : properties.entrySet()) {
            TaskProperty p = entry.getKey();
            String attrName = StaticUtils.toLowerCase(p.getAttributeName());
            List<Object> values = entry.getValue();
            if (attrName.equals(ATTR_BASE_DN)) {
                tmpBaseDN = SearchTask.parseString(p, values, null);
                continue;
            }
            if (attrName.equals(ATTR_SCOPE)) {
                String scopeStr = StaticUtils.toLowerCase(SearchTask.parseString(p, values, null));
                if (scopeStr == null) continue;
                if (scopeStr.equals("base") || scopeStr.equals("baseobject") || scopeStr.equals("0")) {
                    tmpScope = SearchScope.BASE;
                    continue;
                }
                if (scopeStr.equals("one") || scopeStr.equals("onelevel") || scopeStr.equals("singlelevel") || scopeStr.equals("1")) {
                    tmpScope = SearchScope.ONE;
                    continue;
                }
                if (scopeStr.equals("sub") || scopeStr.equals("subtree") || scopeStr.equals("wholesubtree") || scopeStr.equals("2")) {
                    tmpScope = SearchScope.SUB;
                    continue;
                }
                if (scopeStr.equals("subord") || scopeStr.equals("subordinate") || scopeStr.equals("subordinatesubtree") || scopeStr.equals("3")) {
                    tmpScope = SearchScope.SUBORDINATE_SUBTREE;
                    continue;
                }
                throw new TaskException(TaskMessages.ERR_SEARCH_TASK_INVALID_SCOPE_PROPERTY.get(scopeStr));
            }
            if (attrName.equals(ATTR_FILTER)) {
                String filterStr = SearchTask.parseString(p, values, null);
                if (filterStr == null) continue;
                try {
                    tmpFilter = Filter.create(filterStr);
                    continue;
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    throw new TaskException(TaskMessages.ERR_SEARCH_TASK_INVALID_FILTER_PROPERTY.get(filterStr), le);
                }
            }
            if (attrName.equals(ATTR_RETURN_ATTR)) {
                tmpAttrs = SearchTask.parseStrings(p, values, null);
                continue;
            }
            if (attrName.equals(ATTR_OUTPUT_FILE)) {
                tmpFile = SearchTask.parseString(p, values, null);
                continue;
            }
            if (!attrName.equals(ATTR_AUTHZ_DN)) continue;
            tmpAuthzDN = SearchTask.parseString(p, values, null);
        }
        this.baseDN = tmpBaseDN;
        if (this.baseDN == null) {
            throw new TaskException(TaskMessages.ERR_SEARCH_TASK_NO_BASE_PROPERTY.get());
        }
        this.scope = tmpScope;
        if (this.scope == null) {
            throw new TaskException(TaskMessages.ERR_SEARCH_TASK_NO_SCOPE_PROPERTY.get());
        }
        this.filter = tmpFilter;
        if (this.filter == null) {
            throw new TaskException(TaskMessages.ERR_SEARCH_TASK_NO_FILTER_PROPERTY.get());
        }
        this.outputFile = tmpFile;
        if (this.outputFile == null) {
            throw new TaskException(TaskMessages.ERR_SEARCH_TASK_NO_OUTPUT_FILE_PROPERTY.get());
        }
        this.attributes = tmpAttrs == null ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList(tmpAttrs));
        this.authzDN = tmpAuthzDN;
    }

    @Override
    @NotNull
    public String getTaskName() {
        return TaskMessages.INFO_TASK_NAME_SEARCH.get();
    }

    @Override
    @NotNull
    public String getTaskDescription() {
        return TaskMessages.INFO_TASK_DESCRIPTION_SEARCH.get();
    }

    @NotNull
    public String getBaseDN() {
        return this.baseDN;
    }

    @NotNull
    public SearchScope getScope() {
        return this.scope;
    }

    @NotNull
    public Filter getFilter() {
        return this.filter;
    }

    @NotNull
    public List<String> getAttributes() {
        return this.attributes;
    }

    @Nullable
    public String getAuthzDN() {
        return this.authzDN;
    }

    @NotNull
    public String getOutputFile() {
        return this.outputFile;
    }

    @Override
    @NotNull
    protected List<String> getAdditionalObjectClasses() {
        return Collections.singletonList(OC_SEARCH_TASK);
    }

    @Override
    @NotNull
    protected List<Attribute> getAdditionalAttributes() {
        LinkedList<Attribute> attrs = new LinkedList<Attribute>();
        attrs.add(new Attribute(ATTR_BASE_DN, this.baseDN));
        attrs.add(new Attribute(ATTR_SCOPE, String.valueOf(this.scope.intValue())));
        attrs.add(new Attribute(ATTR_FILTER, this.filter.toString()));
        attrs.add(new Attribute(ATTR_OUTPUT_FILE, this.outputFile));
        if (this.attributes != null && !this.attributes.isEmpty()) {
            attrs.add(new Attribute(ATTR_RETURN_ATTR, this.attributes));
        }
        if (this.authzDN != null) {
            attrs.add(new Attribute(ATTR_AUTHZ_DN, this.authzDN));
        }
        return Collections.unmodifiableList(attrs);
    }

    @Override
    @NotNull
    public List<TaskProperty> getTaskSpecificProperties() {
        LinkedList<TaskProperty> props = new LinkedList<TaskProperty>();
        props.add(PROPERTY_BASE_DN);
        props.add(PROPERTY_SCOPE);
        props.add(PROPERTY_FILTER);
        props.add(PROPERTY_REQUESTED_ATTR);
        props.add(PROPERTY_AUTHZ_DN);
        props.add(PROPERTY_OUTPUT_FILE);
        return Collections.unmodifiableList(props);
    }

    @Override
    @NotNull
    public Map<TaskProperty, List<Object>> getTaskPropertyValues() {
        LinkedHashMap props = new LinkedHashMap(StaticUtils.computeMapCapacity(6));
        props.put(PROPERTY_BASE_DN, Collections.singletonList(this.baseDN));
        props.put(PROPERTY_SCOPE, Collections.singletonList(String.valueOf(this.scope.intValue())));
        props.put(PROPERTY_FILTER, Collections.singletonList(this.filter.toString()));
        if (this.attributes != null && !this.attributes.isEmpty()) {
            LinkedList<String> attrObjects = new LinkedList<String>();
            attrObjects.addAll(this.attributes);
            props.put(PROPERTY_REQUESTED_ATTR, Collections.unmodifiableList(attrObjects));
        }
        if (this.authzDN != null) {
            props.put(PROPERTY_AUTHZ_DN, Collections.singletonList(this.authzDN));
        }
        props.put(PROPERTY_OUTPUT_FILE, Collections.singletonList(this.outputFile));
        props.putAll(super.getTaskPropertyValues());
        return Collections.unmodifiableMap(props);
    }
}

