/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.simulink.builder.file;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.builder.ModelBuildingParameters;
import org.conqat.lib.simulink.builder.SimulinkModelBuildingException;
import org.conqat.lib.simulink.builder.file.MdlFileContentProvider;
import org.conqat.lib.simulink.builder.file.OpcTextPackageFileContentProvider;
import org.conqat.lib.simulink.builder.file.SlxFileContentProvider;

public interface ISimulinkFileContentProvider {
    public static final String SLX_MODEL_FILE = "simulink/blockdiagram.xml";

    public boolean isMultiFileContainer();

    default public String getMainContent() throws IOException {
        return this.getNamedContent(SLX_MODEL_FILE).orElseThrow(() -> new IOException("No content of name simulink/blockdiagram.xml found in container file!"));
    }

    public List<String> listContainedFilenames();

    default public List<String> listContainedFilenames(Predicate<String> filter) {
        return CollectionUtils.filter(this.listContainedFilenames(), filter);
    }

    public Optional<String> getNamedContent(String var1);

    public Optional<byte[]> getNamedBinaryContent(String var1);

    public static ISimulinkFileContentProvider buildInstance(String filename, byte[] content, ModelBuildingParameters parameters) throws SimulinkModelBuildingException {
        if (filename.toLowerCase().endsWith(".slx")) {
            return new SlxFileContentProvider(content);
        }
        if (filename.toLowerCase().endsWith(".mdl")) {
            String utf8Content = StringUtils.bytesToString((byte[])content);
            if (utf8Content.contains("__MWOPC_PACKAGE_BEGIN__")) {
                return new OpcTextPackageFileContentProvider(utf8Content);
            }
            return new MdlFileContentProvider(content, utf8Content, parameters);
        }
        throw new SimulinkModelBuildingException("Unknown Simulink file extension found for " + filename);
    }
}

