/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@IndexValueClass(containedInBackup=true)
public class CounterSet<E>
implements Serializable,
Iterable<Pair<E, Integer>> {
    private static final long serialVersionUID = 1L;
    private static final CounterSet EMPTY = new CounterSet(Collections.emptyMap());
    public static final String MAP_PROPERTY = "map";
    public static final String TOTAL_PROPERTY = "total";
    @JsonProperty(value="map")
    protected final Map<E, Integer> map;
    @JsonProperty(value="total")
    protected int total = 0;

    public static <T> CounterSet<T> empty() {
        return EMPTY;
    }

    private CounterSet(Map<E, Integer> map) {
        this.map = map;
    }

    public CounterSet() {
        this(new LinkedHashMap());
    }

    public CounterSet(Collection<E> keys) {
        this();
        this.incAll(keys);
    }

    public CounterSet(E key, int value) {
        this();
        this.inc(key, value);
    }

    public static <E extends Enum<E>> CounterSet<E> forEnum(Class<E> enumClass) {
        return new CounterSet<E>(new EnumMap(enumClass));
    }

    public int inc(E key, int increment) {
        Integer value = this.map.get(key);
        int newValue = value == null ? increment : value + increment;
        this.map.put(key, newValue);
        this.total += increment;
        return this.getValue(key);
    }

    public int inc(E key) {
        return this.inc(key, 1);
    }

    public void incAll(Collection<E> keys, int increment) {
        for (E key : keys) {
            this.inc(key, increment);
        }
    }

    public void incAll(Collection<E> keys) {
        for (E key : keys) {
            this.inc(key);
        }
    }

    public int dec(E key) {
        return this.inc(key, -1);
    }

    public void decAll(Collection<E> keys) {
        for (E key : keys) {
            this.dec(key);
        }
    }

    public void add(CounterSet<E> other) {
        for (Object key : other.getKeys()) {
            this.inc(key, other.getValue(key));
        }
    }

    public static <E> CounterSet<E> removeSecondFromFirst(CounterSet<E> first, CounterSet<E> second) {
        CounterSet<E> merged = new CounterSet<E>();
        for (E key : CollectionUtils.unionSet(first.getKeys(), second.getKeys())) {
            merged.inc(key, first.getValue(key));
            merged.inc(key, -second.getValue(key));
            if (merged.getValue(key) != 0) continue;
            merged.remove(key);
        }
        return merged;
    }

    public void removeIf(BiFunction<E, Integer, Boolean> filter) {
        this.map.entrySet().removeIf((? super E next) -> (Boolean)filter.apply(next.getKey(), (Integer)next.getValue()));
    }

    public void remove(E key) {
        this.total -= this.getValue(key);
        this.map.remove(key);
    }

    public void removeAll(Collection<E> keys) {
        for (E key : keys) {
            this.remove(key);
        }
    }

    public void clear() {
        this.map.clear();
        this.total = 0;
    }

    public boolean contains(E key) {
        return this.map.containsKey(key);
    }

    public int getValue(E key) {
        Integer value = this.map.get(key);
        if (value == null) {
            return 0;
        }
        return value;
    }

    public UnmodifiableSet<E> getKeys() {
        return CollectionUtils.asUnmodifiable(this.map.keySet());
    }

    public List<E> getKeysByValueAscending() {
        return CollectionUtils.sort(this.getKeys(), Comparator.comparing(this.map::get));
    }

    public Set<E> getKeysWithCountAbove(int limit) {
        return this.getKeysByValueDescending().stream().takeWhile(key -> this.map.get(key) > limit).collect(Collectors.toSet());
    }

    public List<E> getKeysByValueDescending() {
        return CollectionUtils.reverse(this.getKeysByValueAscending());
    }

    public TreeMap<E, Integer> toSortedMap() {
        return new TreeMap<E, Integer>(this.toMap());
    }

    public int getTotal() {
        return this.total;
    }

    public boolean isEmpty() {
        return this.total == 0;
    }

    public Collection<Integer> values() {
        return this.map.values();
    }

    public String toString() {
        return this.map.toString();
    }

    int[] transformToList(E[] keySequence) {
        int[] result = new int[keySequence.length];
        for (int i = 0; i < keySequence.length; ++i) {
            E key = keySequence[i];
            result[i] = this.map.getOrDefault(key, 0);
        }
        return result;
    }

    public void printValueDistribution(PrintWriter writer, boolean ascending) {
        List<E> keys = ascending ? this.getKeysByValueAscending() : this.getKeysByValueDescending();
        for (E key : keys) {
            writer.print(key);
            writer.print(" : ");
            writer.print(this.getValue(key));
            writer.println();
        }
        writer.flush();
    }

    public void moveValues(E oldKey, E newKey) {
        this.inc(newKey, this.getValue(oldKey));
        this.remove(oldKey);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CounterSet)) {
            return false;
        }
        return this.map.equals(((CounterSet)obj).map);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public Map<E, Integer> toMap() {
        return new LinkedHashMap<E, Integer>(this.map);
    }

    public static <E> CounterSet<E> fromMap(Map<E, Integer> map) {
        return new CounterSet<E>(new LinkedHashMap<E, Integer>(map));
    }

    public Map<E, Integer> toMapWithoutZeroEntries() {
        Map map = this.toMap();
        map.keySet().removeIf((? super E key) -> (Integer)map.get(key) == 0);
        return map;
    }

    @Override
    public @NonNull Iterator<Pair<E, Integer>> iterator() {
        return new Iterator<Pair<E, Integer>>(){
            private final Iterator<Map.Entry<E, Integer>> delegate;
            {
                this.delegate = CounterSet.this.map.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.delegate.hasNext();
            }

            @Override
            public Pair<E, Integer> next() {
                Map.Entry next = this.delegate.next();
                if (next == null) {
                    return null;
                }
                return new Pair(next.getKey(), next.getValue());
            }
        };
    }

    public Stream<Pair<E, Integer>> stream() {
        return this.map.entrySet().stream().map(e -> new Pair(e.getKey(), (Integer)e.getValue()));
    }

    public static <T> Collector<T, ?, CounterSet<T>> toCounterSet() {
        return CounterSet.toCounterSet(Function.identity(), ignored -> 1);
    }

    public static <T, R> Collector<T, ?, CounterSet<R>> toCounterSet(Function<? super T, R> elementExtractor, ToIntFunction<? super T> counter) {
        return new CounterSetCollector<T, R>(elementExtractor, counter);
    }

    public CounterSet<E> getDeltaTo(@Nullable CounterSet<E> other) {
        if (other == null) {
            return new CounterSet<E>(this.toMap());
        }
        CounterSet deltaMap = new CounterSet();
        HashSet<E> allElements = new HashSet<E>(this.getKeys());
        allElements.addAll(other.getKeys());
        for (Object element : allElements) {
            int oldCount;
            int currentCount = this.getValue(element);
            int delta = currentCount - (oldCount = other.getValue(element));
            if (delta == 0) continue;
            deltaMap.inc(element, delta);
        }
        return deltaMap;
    }

    @SafeVarargs
    public final CounterSet<E> newJoinedWith(CounterSet<E> ... other) {
        CounterSet<E> result = new CounterSet<E>();
        result.add(this);
        for (CounterSet<E> otherCounterSet : other) {
            result.add(otherCounterSet);
        }
        return result;
    }

    private static class CounterSetCollector<T, R>
    implements Collector<T, CounterSet<R>, CounterSet<R>> {
        private final Function<? super T, R> elementExtractor;
        private final ToIntFunction<? super T> counter;

        public CounterSetCollector(Function<? super T, R> elementExtractor, ToIntFunction<? super T> counter) {
            CCSMAssert.isNotNull(elementExtractor, () -> String.format("Expected \"%s\" to be not null", "elementExtractor"));
            CCSMAssert.isNotNull(counter, () -> String.format("Expected \"%s\" to be not null", "counter"));
            this.elementExtractor = elementExtractor;
            this.counter = counter;
        }

        @Override
        public Supplier<CounterSet<R>> supplier() {
            return CounterSet::new;
        }

        @Override
        public BiConsumer<CounterSet<R>, T> accumulator() {
            return (set, element) -> set.inc(this.elementExtractor.apply(element), this.counter.applyAsInt(element));
        }

        @Override
        public BinaryOperator<CounterSet<R>> combiner() {
            return (c1, c2) -> {
                c1.add(c2);
                return c1;
            };
        }

        @Override
        public Function<CounterSet<R>, CounterSet<R>> finisher() {
            return Function.identity();
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return EnumSet.of(Collector.Characteristics.UNORDERED, Collector.Characteristics.IDENTITY_FINISH);
        }
    }
}

