/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.stream.Stream;
import org.conqat.lib.commons.collections.UnmodifiableIterator;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.collections.UnmodifiableListIterator;
import org.conqat.lib.commons.collections.UnmodifiableRandomAccessListImpl;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.NonNull;

@IndexValueClass(containedInBackup=true)
sealed class UnmodifiableListImpl<E>
implements UnmodifiableList<E>
permits UnmodifiableRandomAccessListImpl {
    private static final long serialVersionUID = 1L;
    private final List<E> list;

    public UnmodifiableListImpl(List<E> list) {
        this.list = Collections.unmodifiableList(list);
    }

    @Override
    public UnmodifiableList<E> reversed() {
        return UnmodifiableList.of(this.list.reversed());
    }

    @Override
    public @NonNull UnmodifiableListIterator<E> listIterator() {
        return UnmodifiableListIterator.of(this.list.listIterator());
    }

    @Override
    public @NonNull UnmodifiableListIterator<E> listIterator(int index) {
        return UnmodifiableListIterator.of(this.list.listIterator(index));
    }

    @Override
    public @NonNull UnmodifiableList<E> subList(int fromIndex, int toIndex) {
        return UnmodifiableList.of(this.list.subList(fromIndex, toIndex));
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public Object @NonNull [] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T @NonNull [] toArray(T @NonNull [] a) {
        return this.list.toArray(a);
    }

    @Override
    public boolean containsAll(@NonNull Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public E get(int index) {
        return this.list.get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public @NonNull UnmodifiableIterator<E> iterator() {
        return UnmodifiableIterator.of(this.list.iterator());
    }

    @Override
    public Spliterator<E> spliterator() {
        return this.list.spliterator();
    }

    @Override
    public E getFirst() {
        return this.list.getFirst();
    }

    @Override
    public E getLast() {
        return this.list.getLast();
    }

    @Override
    public <T> T[] toArray(IntFunction<T[]> generator) {
        return this.list.toArray(generator);
    }

    @Override
    public Stream<E> stream() {
        return this.list.stream();
    }

    @Override
    public Stream<E> parallelStream() {
        return this.list.parallelStream();
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        this.list.forEach(action);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof UnmodifiableListImpl) {
            UnmodifiableListImpl that = (UnmodifiableListImpl)o;
            return this.list.equals(that.list);
        }
        return this.list.equals(o);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    public String toString() {
        return this.list.toString();
    }
}

