/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.diff;

import java.util.ArrayList;
import java.util.List;
import org.conqat.lib.commons.diff.DifferBase;
import org.conqat.lib.commons.diff.TextChunk;
import org.conqat.lib.commons.string.StringUtils;

public class LineBasedDiffer
extends DifferBase<String> {
    private final boolean ignoreWhitespace;

    public LineBasedDiffer(boolean ignoreWhitespace) {
        this.ignoreWhitespace = ignoreWhitespace;
    }

    @Override
    protected String getElementText(String element) {
        return element;
    }

    @Override
    protected String getDiffName() {
        Object diffName = "line-based";
        if (this.ignoreWhitespace) {
            diffName = (String)diffName + " (ignore whitespace)";
        }
        return diffName;
    }

    @Override
    protected List<TextChunk> getChunks(String elementText, boolean isLeft) {
        List<String> lines = StringUtils.splitLinesAsList(elementText);
        ArrayList<TextChunk> result = new ArrayList<TextChunk>();
        int offset = 0;
        int lineNumber = 1;
        for (String line : lines) {
            result.add(this.createChunkForLine(offset, lineNumber, line));
            offset += line.length() + 1;
            ++lineNumber;
        }
        return result;
    }

    private TextChunk createChunkForLine(int offset, int lineNumber, String line) {
        int startOffset = offset;
        int endOffset = startOffset + line.length();
        String comparisonText = line;
        if (this.ignoreWhitespace) {
            comparisonText = line.replaceFirst("^\\s+", "");
            int removed = endOffset - startOffset - comparisonText.length();
            startOffset += removed;
            comparisonText = line.replaceFirst("\\s+$", "");
            removed = endOffset - startOffset - comparisonText.length();
            endOffset -= removed;
            comparisonText = comparisonText.replaceAll("\\s+", "");
        }
        return new TextChunk(startOffset, endOffset, lineNumber, lineNumber + 1, comparisonText);
    }
}

