/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;

@Check(id="cqse-no-complex-logic-in-macro", languages={ELanguage.ABAP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class NoComplexLogicInMacroCheck
extends CheckImplementationBase {
    @CheckOption(name="Maximum macro lines", description="Maximum length of a macro body in number of lines (approximates macro complexity; default: 25).")
    private int maxMacroLines = 25;

    public void execute() throws CheckException {
        List metaEntities = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.META);
        for (ShallowEntity metaEntity : metaEntities) {
            if (!"macro".equals(metaEntity.getSubtype())) continue;
            this.processEntity(metaEntity);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        int length = entity.getEndLine() - entity.getStartLine() - 1;
        if (length > this.maxMacroLines) {
            this.buildFinding("Macro is longer than " + this.maxMacroLines + " lines", this.buildLocation().forEntity(entity)).createAndStore();
        }
    }
}

