/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-no-non-class-based-exception-via-raise", languages={ELanguage.ABAP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class NoNonClassBasedExceptionViaRaiseCheck
extends CheckImplementationBase {
    private static final ETokenType[][] VALID_RAISE_PREFIXES = new ETokenType[][]{{ETokenType.RAISE, ETokenType.EXCEPTION}, {ETokenType.RAISE, ETokenType.RESUMABLE, ETokenType.EXCEPTION}, {ETokenType.RAISE, ETokenType.EVENT}, {ETokenType.RAISE, ETokenType.ENTITY, ETokenType.EVENT}};

    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            if (!"raise".equals(statement.getSubtype())) continue;
            this.processEntity(statement);
        }
    }

    private void processEntity(ShallowEntity entity) {
        UnmodifiableList tokens = entity.ownStartTokens();
        if (tokens.size() < 2) {
            return;
        }
        for (ETokenType[] validPrefix : VALID_RAISE_PREFIXES) {
            if (!TokenStreamUtils.startsWith((List)tokens, (ETokenType[])validPrefix)) continue;
            return;
        }
        this.buildFinding("A non-class-based exception should not be thrown using `RAISE`", this.buildLocation().forEntity(entity)).createAndStore();
    }
}

