/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-no-write-to-system-field", languages={ELanguage.ABAP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class NoWriteToSystemFieldCheck
extends CheckImplementationBase {
    private static final String FINDINGS_TEXT = "Write to system field `%s`";
    private static final Pattern PATTERN_SYSTEM_FIELD = Pattern.compile("!?(sy|syst)-.*", 2);
    @CheckOption(name="Allowed system fields", description="Comma-separated list of fields of the predefined structure sy to denote that write accesses to these fields are ignored by this check.")
    private Set<String> allowedSystemFields = CollectionUtils.asHashSet((Object[])new String[]{"lsind"});

    public void initialize() throws CheckException {
        HashSet<String> allowedFields = new HashSet<String>(this.allowedSystemFields);
        for (String field : allowedFields) {
            this.allowedSystemFields.remove(field);
            if (PATTERN_SYSTEM_FIELD.matcher(field).matches()) {
                this.allowedSystemFields.add(field.toLowerCase());
                continue;
            }
            this.allowedSystemFields.add("sy-" + field.toLowerCase());
            this.allowedSystemFields.add("syst-" + field.toLowerCase());
        }
    }

    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            this.processEntity(statement);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        UnmodifiableList tokens = entity.ownStartTokens();
        if (TokenStreamUtils.containsAny((List)tokens, (ETokenType[])new ETokenType[]{ETokenType.EQ})) {
            this.checkAssignmentStatement(entity);
        } else if (TokenStreamUtils.containsAny((List)tokens, (ETokenType[])new ETokenType[]{ETokenType.MOVE})) {
            this.checkMoveStatement(entity);
        } else if (TokenStreamUtils.containsAny((List)tokens, (ETokenType[])new ETokenType[]{ETokenType.CLEAR})) {
            this.checkClearStatement(entity);
        } else if (TokenStreamUtils.containsAny((List)tokens, (ETokenType[])new ETokenType[]{ETokenType.WRITE})) {
            this.checkWriteStatement(entity);
        } else if (TokenStreamUtils.containsAny((List)tokens, (ETokenType[])new ETokenType[]{ETokenType.INTO})) {
            this.checkStatementWithIntoToken(entity);
        }
    }

    private void checkMoveStatement(ShallowEntity entity) throws CheckException {
        UnmodifiableList tokens = entity.ownStartTokens();
        if (tokens.size() < 4) {
            return;
        }
        this.checkIdentifier((IToken)tokens.get(3));
    }

    private void checkIdentifier(IToken currentToken) throws CheckException {
        String identifierText = currentToken.getText();
        if (PATTERN_SYSTEM_FIELD.matcher(identifierText).matches() && !this.allowedSystemFields.contains(identifierText.toLowerCase())) {
            this.buildFinding(String.format(FINDINGS_TEXT, identifierText), this.buildLocation().forToken(currentToken)).createAndStore();
        }
    }

    private void checkAssignmentStatement(ShallowEntity entity) throws CheckException {
        UnmodifiableList tokens = entity.ownStartTokens();
        if (TokenStreamUtils.startsWith((List)tokens, (ETokenType[])new ETokenType[]{ETokenType.IF, ETokenType.ELSEIF, ETokenType.CHECK, ETokenType.WHILE, ETokenType.ASSERT})) {
            return;
        }
        if (tokens.size() < 1) {
            return;
        }
        this.checkIdentifier((IToken)tokens.get(0));
    }

    private void checkClearStatement(ShallowEntity entity) throws CheckException {
        UnmodifiableList tokens = entity.ownStartTokens();
        if (tokens.size() >= 2) {
            this.checkIdentifier((IToken)tokens.get(1));
        }
    }

    private void checkWriteStatement(ShallowEntity entity) throws CheckException {
        UnmodifiableList tokens = entity.ownStartTokens();
        int positionOfToToken = TokenStreamUtils.firstTokenMatching((List)tokens, (ITokenMatcher)ETokenType.TO);
        if (positionOfToToken == -1 || tokens.size() < positionOfToToken + 2) {
            return;
        }
        this.checkIdentifier((IToken)tokens.get(positionOfToToken + 1));
    }

    private void checkStatementWithIntoToken(ShallowEntity entity) throws CheckException {
        UnmodifiableList tokens = entity.ownStartTokens();
        int positionOfIntoToken = TokenStreamUtils.firstTokenMatching((List)tokens, (ITokenMatcher)ETokenType.INTO);
        if (positionOfIntoToken == -1 || tokens.size() < positionOfIntoToken + 2) {
            return;
        }
        this.checkIdentifier((IToken)tokens.get(positionOfIntoToken + 1));
    }
}

