/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.comment;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Check(id="cqse-invalid-character-in-comment", languages={ELanguage.JAVA, ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C, ELanguage.JAVASCRIPT, ELanguage.CS, ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP, ELanguage.PYTHON})
public class InvalidCharacterInCommentCheck
extends CheckImplementationBase {
    private static final Pattern INVALID_CHARACTER_PATTERN = Pattern.compile("[^\\t\\n\\r\\p{Print}]", 2);

    public void execute() throws CheckException {
        for (IToken token : this.context.getTokens(ECodeViewOption.FILTERED)) {
            if (token.getType().getTokenClass() != ETokenType.ETokenClass.COMMENT) continue;
            this.checkComment(token);
        }
    }

    private void checkComment(IToken token) {
        Matcher matcher = INVALID_CHARACTER_PATTERN.matcher(token.getText());
        TreeSet<String> invalidCharacters = new TreeSet<String>();
        while (matcher.find()) {
            invalidCharacters.add(matcher.group());
        }
        if (!invalidCharacters.isEmpty()) {
            String invalidCharsString = String.join((CharSequence)", ", invalidCharacters);
            String message = "Invalid character(s) in comment: " + invalidCharsString;
            this.buildFinding(message, this.buildLocation().forToken(token, ECodeViewOption.ETextViewOption.FILTERED_CONTENT)).createAndStore();
        }
    }
}

