/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp.clang;

import eu.cqse.check.cpp.clang.base.ClangCursorVisitorCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.util.clang.ClangUtils;
import eu.cqse.check.util.clang.visitors.FindingCollectingClangCursorVisitorBase;
import eu.cqse.clang.CXChildVisitResult;
import eu.cqse.clang.CXCursor;
import eu.cqse.clang.CXCursorKind;
import eu.cqse.clang.CXSourceLocation;
import eu.cqse.clang.CXString;
import eu.cqse.clang.CXToken;
import eu.cqse.clang.CXTypeKind;
import eu.cqse.clang.Clang;
import eu.cqse.clang.SWIGTYPE_p_CXTranslationUnitImpl;
import java.util.List;
import java.util.Optional;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.lib.commons.string.StringUtils;

@Check(id="cqse-bitwise-operator", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C}, parameters={ECheckParameter.CLANG})
public class BitwiseOperatorCheck
extends ClangCursorVisitorCheckBase {
    private static final String BITWISE_NOT_OPERATOR = "~";

    @Override
    protected FindingCollectingClangCursorVisitorBase createVisitor(SWIGTYPE_p_CXTranslationUnitImpl translationUnit, String uniformPath, String fileText) {
        return new BitwiseOperatorCheckVisitor(translationUnit, uniformPath, fileText);
    }

    private static class BitwiseOperatorCheckVisitor
    extends FindingCollectingClangCursorVisitorBase {
        private BitwiseOperatorCheckVisitor(SWIGTYPE_p_CXTranslationUnitImpl translationUnit, String uniformPath, String fileText) {
            super(translationUnit, uniformPath, fileText);
        }

        public CXChildVisitResult visit(CXCursor cursor, CXCursor parent) {
            if (Clang.clang_getCursorKind((CXCursor)cursor) != CXCursorKind.CXCursor_UnaryOperator) {
                return CXChildVisitResult.CXChildVisit_Recurse;
            }
            CXToken token = Clang.clang_getToken((SWIGTYPE_p_CXTranslationUnitImpl)this.translationUnit, (CXSourceLocation)Clang.clang_getCursorLocation((CXCursor)cursor));
            if (token == null) {
                return CXChildVisitResult.CXChildVisit_Recurse;
            }
            if (!BitwiseOperatorCheck.BITWISE_NOT_OPERATOR.equals(Clang.clang_getCString((CXString)Clang.clang_getTokenSpelling((SWIGTYPE_p_CXTranslationUnitImpl)this.translationUnit, (CXToken)token)))) {
                return CXChildVisitResult.CXChildVisit_Recurse;
            }
            List children = ClangUtils.getDirectChildren((CXCursor)cursor);
            if (children.isEmpty()) {
                return CXChildVisitResult.CXChildVisit_Recurse;
            }
            CXCursor child = (CXCursor)children.get(0);
            if (Clang.clang_getCursorKind((CXCursor)child) == CXCursorKind.CXCursor_FirstExpr && Clang.clang_getCursorType((CXCursor)child).getKind() == CXTypeKind.CXType_Int) {
                Optional cursorLocation = ClangUtils.createTextRegionLocation((CXCursor)cursor);
                if (!cursorLocation.isPresent()) {
                    return CXChildVisitResult.CXChildVisit_Continue;
                }
                ClangUtils.getCompleteNodeText((CXCursor)child, (String)this.fileText).ifPresent(nameOrExpression -> this.reportFinding((TextRegionLocation)cursorLocation.get(), "Finding: Must not use ~ on signed int " + StringUtils.truncateWithThreeDots((String)nameOrExpression, (int)8)));
                return CXChildVisitResult.CXChildVisit_Continue;
            }
            return CXChildVisitResult.CXChildVisit_Recurse;
        }
    }
}

