/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cs;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;

@Check(id="cqse-cs-avoid-partial-classes", languages={ELanguage.CS}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class CsAvoidPartialClassesCheck
extends CheckImplementationBase {
    private static final String WHITELISTED_SUFFIX = ".xaml.cs";

    public void execute() throws CheckException {
        List types = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.TYPE);
        for (ShallowEntity type : types) {
            if (!TokenStreamUtils.contains((List)type.ownStartTokens(), (ETokenType)ETokenType.PARTIAL)) continue;
            this.processEntity(type);
        }
    }

    private void processEntity(ShallowEntity entity) {
        if (!this.context.getUniformPath().toLowerCase().endsWith(WHITELISTED_SUFFIX)) {
            this.buildFinding("Partial classes should not be used", this.buildLocation().forEntity(entity)).createAndStore();
        }
    }
}

