/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="java:S1182", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class OverrideCloneCheck
extends CheckImplementationBase {
    private static final TokenPattern SUPER_CLONE_CALL_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.SUPER, ETokenType.DOT, ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{"clone"})}), ETokenType.LPAREN, ETokenType.RPAREN});
    private static final String FINDING_MESSAGE = "Use `super.clone()` to create and seed the cloned instance to be returned";

    public void execute() throws CheckException {
        List ast = this.context.getAbstractSyntaxTree(this.getCodeViewOption());
        List methods = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)ast, (EShallowEntityType)EShallowEntityType.METHOD);
        for (ShallowEntity method : methods) {
            this.processMethod(method);
        }
    }

    private void processMethod(ShallowEntity method) {
        if (OverrideCloneCheck.overridesClone(method) && !OverrideCloneCheck.callsSuperClone(method)) {
            this.buildFinding(FINDING_MESSAGE, this.buildLocation().forEntity(method)).createAndStore();
        }
    }

    private static boolean overridesClone(ShallowEntity method) {
        if (!"clone".equals(method.getName())) {
            return false;
        }
        if (OverrideCloneCheck.isAbstractMethod(method)) {
            return false;
        }
        List parameterTokens = LanguageFeatureParser.JAVA.getParameterTokens(method);
        return parameterTokens.isEmpty();
    }

    private static boolean isAbstractMethod(ShallowEntity method) {
        Pair modifiersAndReturnType = LanguageFeatureParser.JAVA.getModifiersAndReturnType(method);
        return modifiersAndReturnType != null && TokenStreamUtils.contains((List)((List)modifiersAndReturnType.getFirst()), (ETokenType)ETokenType.ABSTRACT);
    }

    private static boolean callsSuperClone(ShallowEntity method) {
        UnmodifiableList includedTokens = method.includedTokens();
        List shallowEntities = ShallowEntityTraversalUtils.listEntitiesOfTypes((Collection)method.getChildren(), Set.of(EShallowEntityType.METHOD, EShallowEntityType.TYPE));
        Set excludedTokens = shallowEntities.stream().flatMap(shallowEntity -> shallowEntity.includedTokens().stream()).collect(Collectors.toSet());
        List<IToken> tokensWithoutNested = includedTokens.stream().filter(token -> !excludedTokens.contains(token)).toList();
        return SUPER_CLONE_CALL_PATTERN.matchesAnywhere(tokensWithoutNested);
    }
}

