/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java.spring;

import java.util.regex.Pattern;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.string.StringUtils;
import org.springframework.expression.ParseException;
import org.springframework.expression.spel.standard.SpelExpressionParser;

class SpelExpressionCheckHelper {
    private static final String ERROR_MESSAGE_MISSING_BRACE = "Add missing '}' for this property placeholder or SpEL expression";
    private static final String ERROR_MESSAGE_MALFORMED_PLACEHOLDER = "Correct this malformed property placeholder";
    private static final String ERROR_MESSAGE_MALFORMED_SPEL = "Correct this malformed SpEL expression";
    private static final Pattern PROPERTY_PLACEHOLDER_PATTERN = Pattern.compile("[\\w/-]++(?:\\[\\d++])*+(?:\\.[\\w/-]++(?:\\[\\d++])*+)*+");
    private static final SpelExpressionParser SPEL_PARSER = new SpelExpressionParser();

    private SpelExpressionCheckHelper() {
    }

    public static void validate(String text) throws SyntaxError {
        int i = 0;
        while (i < text.length()) {
            i = switch (text.charAt(i)) {
                case '$' -> SpelExpressionCheckHelper.tryParse(text, i + 1, SpelExpressionCheckHelper::validatePropertyPlaceholder);
                case '#' -> SpelExpressionCheckHelper.tryParse(text, i + 1, SpelExpressionCheckHelper::validateSpelExpression);
                default -> i + 1;
            };
        }
    }

    private static int tryParse(String text, int startIndex, ExpressionValidator validator) throws SyntaxError {
        if (startIndex >= text.length() || text.charAt(startIndex) != '{') {
            return startIndex;
        }
        int closingBraceIndex = SpelExpressionCheckHelper.findClosingBrace(text, startIndex);
        validator.validate(text.substring(startIndex + 1, closingBraceIndex));
        return closingBraceIndex + 1;
    }

    private static int findClosingBrace(String text, int startIndex) throws SyntaxError {
        int nesting = 1;
        for (int i = startIndex + 1; i < text.length(); ++i) {
            char currentChar = text.charAt(i);
            if (currentChar == '{') {
                ++nesting;
                continue;
            }
            if (currentChar != '}' || --nesting != 0) continue;
            return i;
        }
        throw new SyntaxError(ERROR_MESSAGE_MISSING_BRACE);
    }

    private static void validatePropertyPlaceholder(String placeholder) throws SyntaxError {
        Pair pair = StringUtils.splitAtFirst((String)placeholder, (String)":");
        String propertyName = ((String)pair.getFirst()).strip();
        if (propertyName.startsWith("#{")) {
            SpelExpressionCheckHelper.tryParse(propertyName, 1, SpelExpressionCheckHelper::validateSpelExpression);
        } else if (!PROPERTY_PLACEHOLDER_PATTERN.matcher(propertyName).matches()) {
            throw new SyntaxError(ERROR_MESSAGE_MALFORMED_PLACEHOLDER);
        }
        if (!StringUtils.isEmpty((String)((String)pair.getSecond()))) {
            SpelExpressionCheckHelper.validatePropertyPlaceholderDefault((String)pair.getSecond());
        }
    }

    private static void validatePropertyPlaceholderDefault(String defaultValue) throws SyntaxError {
        ExpressionValidator validator;
        if ((defaultValue = defaultValue.strip()).startsWith("${")) {
            validator = SpelExpressionCheckHelper::validatePropertyPlaceholder;
        } else if (defaultValue.startsWith("#{")) {
            validator = SpelExpressionCheckHelper::validateSpelExpression;
        } else {
            return;
        }
        int endIndex = SpelExpressionCheckHelper.tryParse(defaultValue, 1, validator);
        if (endIndex != defaultValue.length()) {
            throw new SyntaxError(ERROR_MESSAGE_MALFORMED_PLACEHOLDER);
        }
    }

    private static void validateSpelExpression(String expression) throws SyntaxError {
        if (StringUtils.isEmpty((String)(expression = expression.strip()))) {
            throw new SyntaxError(ERROR_MESSAGE_MALFORMED_SPEL);
        }
        try {
            SPEL_PARSER.parseExpression(expression);
        }
        catch (IllegalStateException | ParseException e) {
            throw new SyntaxError(ERROR_MESSAGE_MALFORMED_SPEL);
        }
    }

    @FunctionalInterface
    private static interface ExpressionValidator {
        public void validate(String var1) throws SyntaxError;
    }

    static class SyntaxError
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public SyntaxError(String message) {
            super(message);
        }
    }
}

