/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java.tests;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.Collection;
import java.util.List;

@Check(id="java:S5967", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class JUnitCompatibleAnnotationsCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List ast = this.context.getAbstractSyntaxTree(this.getCodeViewOption());
        ShallowEntityTraversalUtils.listEntitiesOfType((Collection)ast, (EShallowEntityType)EShallowEntityType.METHOD).forEach(this::handleMethod);
    }

    private void handleMethod(ShallowEntity method) {
        long numberOfTestAnnotations = LanguageFeatureParser.JAVA.getAnnotations(method).stream().filter(annotation -> LanguageFeatureParser.JAVA.isTestAnnotation(annotation)).count();
        if (numberOfTestAnnotations > 1L) {
            this.buildFinding(JUnitCompatibleAnnotationsCheck.createMessage(method), this.buildLocation().forEntityFirstLine(method)).createAndStore();
        }
    }

    private static String createMessage(ShallowEntity method) {
        return "Remove one of the conflicting test annotations from `%s`".formatted(method.getName());
    }
}

