/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.matlab.EMatlabActionEntityType;
import eu.cqse.check.matlab.MatlabActionAstNode;
import eu.cqse.check.matlab.MatlabActionAstUtils;
import eu.cqse.check.matlab.MatlabActionParserException;
import eu.cqse.check.matlab.MatlabActionTypeResolver;
import eu.cqse.check.simulink.simulink.phases.SimulinkCheckFileReferencesResolver;
import eu.cqse.check.simulink.simulink.phases.SimulinkDataDictionaryLoadingPhase;
import eu.cqse.check.simulink.simulink.phases.SimulinkFileReferencesPhase;
import eu.cqse.check.simulink.simulink.phases.SimulinkModelBlockIdListingPhase;
import eu.cqse.check.util.simulink.StateflowCheckUtils;
import eu.cqse.check.util.simulink.StateflowTransitionParts;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.QualifiedNameLocation;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.simulink.builder.SimulinkDataDictionary;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkResolvedDataTypes;
import org.conqat.lib.simulink.model.stateflow.StateflowBlock;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.model.stateflow.StateflowTransition;
import org.conqat.lib.simulink.util.SimulinkUtils;
import org.conqat.lib.simulink.util.StateflowUtils;

@Check(id="cqse.hism.himl_0011", languages={ELanguage.SIMULINK}, phases={SimulinkDataDictionaryLoadingPhase.class, SimulinkFileReferencesPhase.class, SimulinkModelBlockIdListingPhase.class})
public class SimulinkDataTypeAndSizeOfConditionExpressionsCheck
extends CheckImplementationBase {
    private static final String FINDING_MESSAGE = "Condition %s is not a logical expression";
    private static final String FINDING_MESSAGE_WITH_LINE = "Condition %s in line %d is not a logical expression";
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Change the current condition use a logical scalar or a boolean operation");
    private static final Logger LOGGER = LogManager.getLogger();

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        SimulinkResolvedDataTypes resolvedTypes = this.context.getSimulinkContext().getSimulinkOutputDataTypesForModelFile().orElse(null);
        if (model == null || resolvedTypes == null) {
            return;
        }
        List<SimulinkDataDictionary> dataDictionaries = new SimulinkCheckFileReferencesResolver(this.context).getSimulinkDataDictionariesForModel(model, this.context.accessPhaseResult(SimulinkDataDictionaryLoadingPhase.class));
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false)) {
            if (!(block instanceof StateflowBlock)) continue;
            StateflowBlock stateflowBlock = (StateflowBlock)block;
            this.checkMatlabFunctionsAndStates(stateflowBlock, resolvedTypes, dataDictionaries);
            StateflowChart chart = stateflowBlock.getChart();
            if (chart == null || StateflowUtils.hasActionLanguageC((StateflowChart)chart)) continue;
            for (StateflowTransition transition : StateflowUtils.getAllTransitions((StateflowChart)chart, (boolean)false)) {
                this.checkTransition(transition, resolvedTypes, dataDictionaries);
            }
        }
    }

    private void checkTransition(StateflowTransition transition, SimulinkResolvedDataTypes resolvedDataTypes, List<SimulinkDataDictionary> dataDictionaries) {
        StateflowTransitionParts transitionParts = StateflowCheckUtils.splitTransitionLabel((StateflowTransition)transition);
        if (transitionParts.condition.isEmpty()) {
            return;
        }
        QualifiedNameLocation location = this.buildLocation().forStateflowTransition(transition);
        try {
            MatlabActionTypeResolver typeResolver = MatlabActionTypeResolver.from((List)transitionParts.condition, (StateflowTransition)transition, (SimulinkResolvedDataTypes)resolvedDataTypes, dataDictionaries);
            if (typeResolver.getRootNode() == MatlabActionTypeResolver.EMPTY_ROOT_NODE) {
                return;
            }
            if (typeResolver.getRootNode().getType() == EMatlabActionEntityType.STATEMENT_LIST) {
                typeResolver = SimulinkDataTypeAndSizeOfConditionExpressionsCheck.removeEmptyStatements(typeResolver, transition, resolvedDataTypes);
            }
            if (EMatlabActionEntityType.STATEMENT != typeResolver.getRootNode().getType() || !SimulinkDataTypeAndSizeOfConditionExpressionsCheck.isLogicalScalar(typeResolver.getRootNode(), typeResolver)) {
                this.createFinding(transitionParts.condition, location);
            }
        }
        catch (MatlabActionParserException e) {
            LOGGER.debug("Could not parse code in " + location.getQualifiedName(), (Throwable)e);
        }
    }

    private static MatlabActionTypeResolver removeEmptyStatements(MatlabActionTypeResolver typeResolver, StateflowTransition transition, SimulinkResolvedDataTypes resolvedDataTypes) throws MatlabActionParserException {
        List<MatlabActionAstNode> childrenWithoutEmptyStatements = typeResolver.getRootNode().getChildren().stream().filter(node -> node.getType() != EMatlabActionEntityType.EMPTY_STATEMENT).toList();
        if (childrenWithoutEmptyStatements.size() == 1 && childrenWithoutEmptyStatements.get(0).getType() == EMatlabActionEntityType.STATEMENT) {
            return MatlabActionTypeResolver.from((List)childrenWithoutEmptyStatements.get(0).getTokens(), (StateflowTransition)transition, (SimulinkResolvedDataTypes)resolvedDataTypes, Collections.emptyList());
        }
        return typeResolver;
    }

    private void checkMatlabFunctionsAndStates(StateflowBlock block, SimulinkResolvedDataTypes resolvedDataTypes, List<SimulinkDataDictionary> dataDictionaries) {
        for (StateflowState state : StateflowUtils.listStatesDepthFirst((StateflowChart)block.getChart(), (boolean)true)) {
            if (!state.isMatlabFunction()) continue;
            QualifiedNameLocation location = StateflowUtils.isMatlabFunctionBlock((SimulinkBlock)block) ? this.buildLocation().forSimulinkBlock((SimulinkBlock)block) : this.buildLocation().forStateflowNode((StateflowNodeBase)state);
            for (MatlabActionAstNode nonScalarCondition : this.checkMatlabFunctionsAndStates(state, resolvedDataTypes, dataDictionaries)) {
                this.createFinding(nonScalarCondition.getTokens(), location, MatlabActionAstUtils.getLineNumberForAstNode((MatlabActionAstNode)nonScalarCondition));
            }
        }
    }

    private List<MatlabActionAstNode> checkMatlabFunctionsAndStates(StateflowState state, SimulinkResolvedDataTypes resolvedDataTypes, List<SimulinkDataDictionary> dataDictionaries) {
        ArrayList<MatlabActionAstNode> nonScalarConditions = new ArrayList<MatlabActionAstNode>();
        try {
            for (MatlabActionTypeResolver typeResolver : MatlabActionTypeResolver.fromMatlabFunctionNode((StateflowState)state, (SimulinkResolvedDataTypes)resolvedDataTypes, dataDictionaries)) {
                nonScalarConditions.addAll(SimulinkDataTypeAndSizeOfConditionExpressionsCheck.checkSimulinkFunction(typeResolver));
            }
        }
        catch (MatlabActionParserException e) {
            LOGGER.debug("Could not parse code in " + this.buildLocation().forStateflowNode((StateflowNodeBase)state).getQualifiedName(), (Throwable)e);
        }
        return nonScalarConditions;
    }

    private static List<MatlabActionAstNode> checkSimulinkFunction(MatlabActionTypeResolver typeResolver) {
        ArrayList<MatlabActionAstNode> nonScalarConditions = new ArrayList<MatlabActionAstNode>();
        for (MatlabActionAstNode node : MatlabActionAstUtils.listNodesOfEntityTypeRecursively((MatlabActionAstNode)typeResolver.getRootNode(), (EMatlabActionEntityType[])new EMatlabActionEntityType[]{EMatlabActionEntityType.IF, EMatlabActionEntityType.ELSEIF, EMatlabActionEntityType.WHILE})) {
            if (SimulinkDataTypeAndSizeOfConditionExpressionsCheck.isLogicalScalar(node, typeResolver)) continue;
            MatlabActionAstNode condition = (MatlabActionAstNode)node.getChildren().get(0);
            nonScalarConditions.add(condition);
        }
        return nonScalarConditions;
    }

    private void createFinding(List<IToken> condition, QualifiedNameLocation location) {
        this.createFinding(condition, location, null);
    }

    private void createFinding(List<IToken> condition, QualifiedNameLocation location, Integer lineNumber) {
        String conditionString = condition.stream().map(IToken::getText).collect(Collectors.joining());
        String message = lineNumber == null ? String.format(FINDING_MESSAGE, MarkupUtils.formatAsSourceCode((String)conditionString)) : String.format(FINDING_MESSAGE_WITH_LINE, MarkupUtils.formatAsSourceCode((String)conditionString), lineNumber);
        this.context.buildFinding(message, (ElementLocation)location).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
    }

    private static boolean isLogicalScalar(MatlabActionAstNode node, MatlabActionTypeResolver typeResolver) {
        MatlabActionAstNode child = (MatlabActionAstNode)node.getChildren().get(0);
        String type = typeResolver.inferDataTypeOf(child);
        return type.equals("boolean") || type.equals("Unknown");
    }
}

