/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import java.util.Set;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.util.SimulinkUtils;

public abstract class SimulinkNumberPerLevelCheckBase
extends CheckImplementationBase {
    private static final String FINDING_MESSAGE = "%s has too many %s on one level (%d)";
    private static final String RECOMMENDED_ACTION_MESSAGE = "Refactor the model such that %s only contains %d %s";

    protected abstract String getCountObjectName();

    protected abstract int getObjectsPerLevelThreshold();

    protected abstract int getRootLevelThreshold();

    protected abstract int determineNumberOfObjects(SimulinkBlock var1);

    public void execute() throws CheckException {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        this.checkRoot(model);
        this.checkSubsystems(model);
    }

    private void checkRoot(SimulinkModel model) {
        int numberOfBlocks = this.determineNumberOfObjects((SimulinkBlock)model);
        if (numberOfBlocks > this.getRootLevelThreshold()) {
            String findingMessage = this.getFormattedFindingMessage(numberOfBlocks, "The model's root");
            FindingPropertyList findingProperties = FindingPropertyList.singleton((String)"Recommended Action", (String)this.getFormattedRecommendedActionMessage("the model's root", this.getRootLevelThreshold()));
            this.buildFinding(findingMessage, (ElementLocation)this.buildLocation().forSimulinkBlock((SimulinkBlock)model)).addFindingProperties(findingProperties).createAndStore();
        }
    }

    private void checkSubsystems(SimulinkModel model) {
        for (SimulinkBlock subsystemToCheck : SimulinkUtils.listBlocksOfTypesDepthFirst((SimulinkBlock)model, Set.of("SubSystem"), (boolean)false, (boolean)false)) {
            int numberOfBlocks = this.determineNumberOfObjects(subsystemToCheck);
            if (numberOfBlocks <= this.getObjectsPerLevelThreshold()) continue;
            String formattedBlockName = MarkupUtils.formatAsSourceCode((String)subsystemToCheck.getName());
            String findingMessage = this.getFormattedFindingMessage(numberOfBlocks, formattedBlockName);
            FindingPropertyList findingProperties = FindingPropertyList.singleton((String)"Recommended Action", (String)this.getFormattedRecommendedActionMessage(formattedBlockName, this.getObjectsPerLevelThreshold()));
            this.buildFinding(findingMessage, (ElementLocation)this.buildLocation().forSimulinkBlock(subsystemToCheck)).addFindingProperties(findingProperties).createAndStore();
        }
    }

    private String getFormattedFindingMessage(int numberOfBlocks, String blockName) {
        return String.format(FINDING_MESSAGE, blockName, this.getCountObjectName(), numberOfBlocks);
    }

    private String getFormattedRecommendedActionMessage(String blockName, int maxNumberAllowedObjects) {
        return String.format(RECOMMENDED_ACTION_MESSAGE, blockName, maxNumberAllowedObjects, this.getCountObjectName());
    }
}

