/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.core;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.ECheckTarget;
import eu.cqse.check.framework.core.EFindingEnablement;
import eu.cqse.check.framework.core.option.ICheckOption;
import eu.cqse.check.framework.core.phase.IGlobalExtractionPhase;
import eu.cqse.check.framework.core.registry.Guideline;
import eu.cqse.check.framework.core.registry.GuidelineMapping;
import eu.cqse.check.framework.core.ruleset.RulesetInfo;
import eu.cqse.check.framework.core.util.CheckUtils;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SequencedMap;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionMap;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.collections.UnmodifiableSequencedMap;

public class CheckInfo {
    private final Class<?> checkClass;
    private final String id;
    private final String readableName;
    private final String description;
    private final String groupName;
    private final String categoryName;
    private final EFindingEnablement defaultEnablement;
    private final Set<ELanguage> languages;
    private final Set<ECheckParameter> parameters;
    private final SequencedMap<String, ICheckOption<?>> options = new LinkedHashMap();
    private final Set<Class<? extends IGlobalExtractionPhase<?, ?>>> phases;
    private final Map<ELanguage, SetMap<String, String>> guidelineMappingByLanguage;
    private final Set<ECheckTarget> target;

    public CheckInfo(Class<?> checkClass, String id, String readableName, String description, String groupName, String categoryName, EFindingEnablement defaultEnablement, ELanguage[] languages, ECheckParameter[] parameters, ECheckTarget[] target, Class<? extends IGlobalExtractionPhase<?, ?>>[] phases, SequencedMap<String, ICheckOption<?>> options) {
        CCSMAssert.isNotNull(checkClass);
        CCSMAssert.isNotNull((Object)id);
        CCSMAssert.isNotNull((Object)readableName);
        CCSMAssert.isNotNull((Object)description);
        CCSMAssert.isNotNull((Object)groupName);
        CCSMAssert.isNotNull((Object)categoryName);
        CCSMAssert.isNotNull((Object)((Object)defaultEnablement));
        CCSMAssert.isNotNull((Object)languages);
        CCSMAssert.isNotNull(phases);
        CCSMAssert.isNotNull((Object)parameters);
        CCSMAssert.isNotNull(options);
        CCSMAssert.isNotNull((Object)target);
        this.checkClass = checkClass;
        this.id = id;
        this.readableName = readableName;
        this.description = description;
        this.groupName = groupName;
        this.categoryName = categoryName;
        this.defaultEnablement = defaultEnablement;
        this.languages = CollectionUtils.asHashSet((Object[])languages);
        this.phases = CollectionUtils.asHashSet((Object[])phases);
        this.parameters = EnumSet.noneOf(ECheckParameter.class);
        this.parameters.addAll(Arrays.asList(parameters));
        this.options.putAll(options);
        this.target = Arrays.stream(target).collect(Collectors.toSet());
        this.guidelineMappingByLanguage = CheckInfo.getGuidelineMappings(id);
    }

    public CheckImplementationBase instantiateCheckImplementation() throws CheckException {
        return CheckImplementationBase.createInstance(this.checkClass);
    }

    public String getId() {
        return this.id;
    }

    public String getReadableName() {
        return this.readableName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public EFindingEnablement getDefaultEnablement() {
        return this.defaultEnablement;
    }

    public Set<ELanguage> getSupportedLanguages() {
        return this.languages;
    }

    public Set<Class<? extends IGlobalExtractionPhase<?, ?>>> getRequiredPhases() {
        return this.phases;
    }

    public Set<ECheckParameter> getParameters() {
        return this.parameters;
    }

    public UnmodifiableSequencedMap<String, ICheckOption<?>> getOptions() {
        return CollectionUtils.asUnmodifiable(this.options);
    }

    public String getIdentifier() {
        return CheckUtils.buildIdentifier(this.categoryName, this.groupName, this.id);
    }

    public String getSimpleClassName() {
        return this.checkClass.getSimpleName();
    }

    public String getCheckClassName() {
        return this.checkClass.getName();
    }

    public Set<ECheckTarget> getTargets() {
        return this.target;
    }

    private static Map<ELanguage, SetMap<String, String>> getGuidelineMappings(String id) {
        HashMap<ELanguage, SetMap<String, String>> guidelineMappings = new HashMap<ELanguage, SetMap<String, String>>();
        CheckInfo.addGuidelineMappingsFromTSV(id, guidelineMappings);
        return guidelineMappings;
    }

    private static void addGuidelineMappingsFromTSV(String id, Map<ELanguage, SetMap<String, String>> guidelineMappings) {
        ListMap<String, RulesetInfo> rulesByCheckId = GuidelineMapping.getInstance().getRulesByCheckId();
        for (Guideline guideline : GuidelineMapping.getInstance().getGuidelines()) {
            SetMap rulesByGuideline = new SetMap();
            List rulesForThisCheckAsString = ((List)rulesByCheckId.getCollectionOrEmpty((Object)id)).stream().filter(r -> r.rulesetName.equals(guideline.readableName())).map(RulesetInfo::getFullDescription).collect(Collectors.toList());
            rulesByGuideline.addAll((Object)guideline.readableName(), rulesForThisCheckAsString);
            for (ELanguage language : guideline.supportedLanguages()) {
                if (guidelineMappings.containsKey(language)) {
                    SetMap<String, String> existingEntries = guidelineMappings.get(language);
                    existingEntries.addAll((CollectionMap)rulesByGuideline);
                    continue;
                }
                guidelineMappings.put(language, (SetMap<String, String>)new SetMap(new SetMap[]{rulesByGuideline}));
            }
        }
    }

    public SetMap<String, String> getGuidelineMappingForLanguage(ELanguage language) {
        return this.guidelineMappingByLanguage.getOrDefault(language, (SetMap<String, String>)new SetMap());
    }
}

