/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.core;

import com.google.common.base.Preconditions;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.List;
import java.util.Optional;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.QualifiedNameLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.resource.text.filter.util.StringOffsetTransformer;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.LineOffsetConverter;
import org.conqat.lib.simulink.builder.ISimulinkDataDictionaryEntry;
import org.conqat.lib.simulink.model.SimulinkAnnotation;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkLine;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowTransition;
import org.conqat.lib.simulink.ui.SimulinkLineUIData;
import org.conqat.lib.simulink.util.SimulinkUtils;

public class LocationBuilderBase {
    protected StringOffsetTransformer offsetTransformer;
    protected LineOffsetConverter unfilteredLineOffsetConverter;
    protected LineOffsetConverter filteredLineOffsetConverter;
    protected String uniformPath;
    protected final ELanguage language;

    public LocationBuilderBase(String uniformPath, StringOffsetTransformer offsetTransformer, LineOffsetConverter unfilteredLineOffsetConverter, LineOffsetConverter filteredLineOffsetConverter, ELanguage language) {
        if (language != ELanguage.SIMULINK) {
            CCSMAssert.isNotNull((Object)uniformPath);
            CCSMAssert.isNotNull((Object)offsetTransformer);
            CCSMAssert.isNotNull((Object)unfilteredLineOffsetConverter);
            CCSMAssert.isNotNull((Object)filteredLineOffsetConverter);
        }
        this.uniformPath = uniformPath;
        this.offsetTransformer = offsetTransformer;
        this.unfilteredLineOffsetConverter = unfilteredLineOffsetConverter;
        this.filteredLineOffsetConverter = filteredLineOffsetConverter;
        this.language = language;
    }

    public ElementLocation forElement() {
        return new ElementLocation(this.uniformPath);
    }

    public QualifiedNameLocation forSimulinkBlock(SimulinkBlock block) {
        Preconditions.checkState((this.language == ELanguage.SIMULINK ? 1 : 0) != 0, (Object)"Cannot create simulink-location since the current element is no Simulink model.");
        return new QualifiedNameLocation(block.buildQualifiedName(), this.uniformPath);
    }

    public QualifiedNameLocation forSimulinkLine(SimulinkLine line) {
        Preconditions.checkState((this.language == ELanguage.SIMULINK ? 1 : 0) != 0, (Object)"Cannot create simulink-location since the current element is no Simulink model.");
        return new QualifiedNameLocation(SimulinkLineUIData.obtainArtificialId((SimulinkLine)line), this.uniformPath);
    }

    public QualifiedNameLocation forSimulinkAnnotation(SimulinkAnnotation annotation) {
        Preconditions.checkState((this.language == ELanguage.SIMULINK ? 1 : 0) != 0, (Object)"Cannot create simulink-location since the current element is no Simulink model.");
        return new QualifiedNameLocation(annotation.buildQualifiedName(), this.uniformPath);
    }

    public QualifiedNameLocation forStateflowTransition(StateflowTransition transition) {
        Preconditions.checkState((this.language == ELanguage.SIMULINK ? 1 : 0) != 0, (Object)"Cannot create simulink-location since the current element is no Simulink model.");
        String qualifiedName = transition.buildQualifiedName();
        return new QualifiedNameLocation(qualifiedName, this.uniformPath);
    }

    public QualifiedNameLocation forStateflowNode(StateflowNodeBase node) {
        Preconditions.checkState((this.language == ELanguage.SIMULINK ? 1 : 0) != 0, (Object)"Cannot create simulink-location since the current element is no Simulink model.");
        String qualifiedName = node.buildQualifiedName();
        return new QualifiedNameLocation(qualifiedName, this.uniformPath);
    }

    public QualifiedNameLocation forSimulinkDataDictionaryEntry(ISimulinkDataDictionaryEntry entry) {
        Preconditions.checkState((this.language == ELanguage.SIMULINK && SimulinkUtils.isSimulinkDataDictionary((String)this.uniformPath) ? 1 : 0) != 0, (Object)"Cannot create simulink-location since the current element is no Simulink data dictionary.");
        return new QualifiedNameLocation(entry.getName(), this.uniformPath);
    }

    public Optional<TextRegionLocation> betweenLines(int startLine, int endLine, ECodeViewOption.ETextViewOption view) {
        if (view == ECodeViewOption.ETextViewOption.UNFILTERED_CONTENT) {
            int unfilteredStartOffset = this.unfilteredLineOffsetConverter.getOffset(startLine);
            int unfilteredEndOffset = this.unfilteredLineOffsetConverter.getOffset(endLine + 1) - 1;
            if (this.offsetTransformer.isFilteredOffset(unfilteredStartOffset) && this.offsetTransformer.isFilteredOffset(unfilteredEndOffset)) {
                return Optional.empty();
            }
            return Optional.of(this.createTextRegionLocationForUnfilteredOffsets(unfilteredStartOffset, unfilteredEndOffset));
        }
        int startOffset = this.filteredLineOffsetConverter.getOffset(startLine);
        int endOffset = this.filteredLineOffsetConverter.getOffset(endLine + 1) - 1;
        return Optional.of(this.createTextRegionLocationForFilteredOffsets(startOffset, endOffset));
    }

    private TextRegionLocation createTextRegionLocationForFilteredOffsets(int startOffset, int endOffset) {
        int unfilteredStartOffset = this.offsetTransformer.getUnfilteredOffset(startOffset);
        int unfilteredEndOffset = this.offsetTransformer.getUnfilteredOffset(endOffset);
        return this.createTextRegionLocationForUnfilteredOffsets(unfilteredStartOffset, unfilteredEndOffset);
    }

    private TextRegionLocation createTextRegionLocationForUnfilteredOffsets(int unfilteredStartOffset, int unfilteredEndOffset) {
        int unfilteredStartLine = this.unfilteredLineOffsetConverter.getLine(unfilteredStartOffset);
        int unfilteredEndLine = this.unfilteredLineOffsetConverter.getLine(unfilteredEndOffset);
        return new TextRegionLocation(this.uniformPath, unfilteredStartOffset, unfilteredEndOffset, unfilteredStartLine, unfilteredEndLine);
    }

    public Optional<TextRegionLocation> betweenOffsets(int startOffset, int endOffset, ECodeViewOption.ETextViewOption view) {
        if (view == ECodeViewOption.ETextViewOption.UNFILTERED_CONTENT) {
            if (this.offsetTransformer.isFilteredOffset(startOffset) && this.offsetTransformer.isFilteredOffset(endOffset)) {
                return Optional.empty();
            }
            int unfilteredStartLine = this.unfilteredLineOffsetConverter.getLine(startOffset);
            int unfilteredEndLine = this.unfilteredLineOffsetConverter.getLine(endOffset);
            return Optional.of(new TextRegionLocation(this.uniformPath, startOffset, endOffset, unfilteredStartLine, unfilteredEndLine));
        }
        int unfilteredStartOffset = this.offsetTransformer.getUnfilteredOffset(startOffset);
        int unfilteredEndOffset = this.offsetTransformer.getUnfilteredOffset(endOffset);
        int unfilteredStartLine = this.unfilteredLineOffsetConverter.getLine(unfilteredStartOffset);
        int unfilteredEndLine = this.unfilteredLineOffsetConverter.getLine(unfilteredEndOffset);
        return Optional.of(new TextRegionLocation(this.uniformPath, unfilteredStartOffset, unfilteredEndOffset, unfilteredStartLine, unfilteredEndLine));
    }

    public Optional<TextRegionLocation> betweenTokens(IToken startToken, IToken endToken, ECodeViewOption.ETextViewOption view) {
        return this.betweenOffsets(startToken.getOffset(), endToken.getEndOffset(), view);
    }

    public Optional<TextRegionLocation> forTokens(List<IToken> tokens, ECodeViewOption.ETextViewOption view) {
        return this.betweenOffsets(tokens.get(0).getOffset(), ((IToken)CollectionUtils.getLast(tokens)).getEndOffset(), view);
    }

    public Optional<TextRegionLocation> forEntity(ShallowEntity entity, ECodeViewOption.ETextViewOption view) {
        return this.betweenOffsets(entity.getStartOffset(), entity.getEndOffset(), view);
    }

    public Optional<TextRegionLocation> forLine(int line, ECodeViewOption.ETextViewOption view) {
        return this.betweenLines(line, line, view);
    }

    public Optional<TextRegionLocation> forToken(IToken token, ECodeViewOption.ETextViewOption view) {
        return this.betweenTokens(token, token, view);
    }

    public Optional<TextRegionLocation> forEntityFirstLine(ShallowEntity entity, ECodeViewOption.ETextViewOption view) {
        return this.forLine(entity.getStartLine(), view);
    }
}

