/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.languages.powershell;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ParserState;
import eu.cqse.check.framework.shallowparser.framework.RecognizerBase;
import eu.cqse.check.framework.shallowparser.languages.powershell.EPowershellParserState;
import java.util.List;

public class PowershellSubExpressionRecognizer
extends RecognizerBase<EPowershellParserState> {
    private static final ITokenMatcher SUB_EXPRESSION_STARTER = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IF, ETokenType.WHILE, ETokenType.DO, ETokenType.FOR, ETokenType.FOREACH, ETokenType.SWITCH, ETokenType.LBRACE});
    private static final ITokenMatcher SUB_EXPRESSIONS_START_FOLLOWED_BY_PARENTHESES = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IF, ETokenType.WHILE, ETokenType.DO, ETokenType.FOR, ETokenType.FOREACH});

    @Override
    protected int matchesLocally(ParserState<EPowershellParserState> parserState, List<IToken> tokens, int startOffset) {
        IToken currentToken = tokens.get(startOffset);
        if (!SUB_EXPRESSION_STARTER.matches(currentToken)) {
            return -1;
        }
        if (startOffset - 1 >= 0 && tokens.get(startOffset - 1).getType() == ETokenType.DOT) {
            return -1;
        }
        if (startOffset + 1 >= tokens.size()) {
            return -1;
        }
        IToken nextToken = tokens.get(startOffset + 1);
        if (SUB_EXPRESSIONS_START_FOLLOWED_BY_PARENTHESES.matches(currentToken) && !ETokenType.LPAREN.matches(nextToken)) {
            return -1;
        }
        if (ETokenType.SWITCH.matches(currentToken) && ETokenType.RBRACK.matches(nextToken)) {
            return -1;
        }
        return parserState.parse(EPowershellParserState.IN_EXPRESSION, tokens, startOffset);
    }
}

