/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.conqat.lib.commons.string.StringUtils;

public class JavaStringValueResolver {
    private static final int NAME_GROUP_INDEX = 0;
    private static final int STRING_LITERAL_GROUP_INDEX = 1;
    private static final TokenPattern FINAL_STRING_PATTERN = TokenPattern.of().sequence(ETokenType.FINAL).skipTo(ETokenType.IDENTIFIER.and(new ITokenMatcher[]{ITokenMatcher.hasText((String[])new String[]{"String"})})).sequence(ETokenType.IDENTIFIER).group(0).sequence(ETokenType.EQ).skipUntil(ETokenType.SEMICOLON).group(1);
    private final Map<String, String> stringToValueMap = new HashMap<String, String>();

    public JavaStringValueResolver(ShallowEntity entity) {
        this.fillMapping(entity);
    }

    private void fillMapping(ShallowEntity entity) {
        List attributes = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)entity.getChildren(), (EShallowEntityType)EShallowEntityType.ATTRIBUTE);
        for (ShallowEntity attribute : attributes) {
            TokenPatternMatch match = FINAL_STRING_PATTERN.findFirstMatch((List<IToken>)attribute.ownStartTokens());
            if (match == null) continue;
            String simpleName = match.groupTexts(0).getFirst();
            List<IToken> valueTokens = match.groupTokens(1);
            Optional<String> value = this.resolveStringExpression(valueTokens);
            value.ifPresent(s -> this.stringToValueMap.put(simpleName, (String)s));
        }
    }

    public Optional<String> resolveStringExpression(List<IToken> stringExpression) {
        List<List<IToken>> leafs = TokenStreamUtils.split(stringExpression, ETokenType.PLUS);
        if (leafs.size() == 1) {
            return this.resolveStringExpressionLeaf(leafs.getFirst());
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (List<IToken> leaf : leafs) {
            Optional<String> string = this.resolveStringExpressionLeaf(leaf);
            if (string.isEmpty()) {
                return Optional.empty();
            }
            stringBuilder.append(string.get());
        }
        return Optional.of(stringBuilder.toString());
    }

    private Optional<String> resolveStringExpressionLeaf(List<IToken> stringExpression) {
        if (stringExpression.size() == 1) {
            return this.resolveShortStringExpressionLeaf(stringExpression.getFirst());
        }
        return Optional.empty();
    }

    private Optional<String> resolveShortStringExpressionLeaf(IToken token) {
        String stringValue;
        if (token.getType() == ETokenType.STRING_LITERAL) {
            return Optional.of(StringUtils.removeDoubleQuotes((String)token.getText()));
        }
        if (token.getType() == ETokenType.IDENTIFIER && (stringValue = this.stringToValueMap.get(token.getText())) != null) {
            return Optional.of(stringValue);
        }
        return Optional.empty();
    }
}

