/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util.javascript;

import com.google.common.collect.Iterables;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.javascript.JavascriptDependencyUtils;
import java.util.ArrayList;
import java.util.List;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class CommonJSDependencyUtils {
    public static final String REQUIRE = "require";
    public static final String EXPORTS = "exports";

    public static List<String> extractExportedTypeNames(List<ShallowEntity> entities, String uniformPath) {
        ArrayList<String> exportedDeclarations = new ArrayList<String>();
        String typePrefix = JavascriptDependencyUtils.convertUniformPathToTypeFormat(uniformPath);
        for (ShallowEntity entity : entities) {
            CommonJSDependencyUtils.extractExportedTypeNames(entity).forEach(type -> exportedDeclarations.add(JavascriptDependencyUtils.joinTypeSuffix(typePrefix, type)));
        }
        return exportedDeclarations;
    }

    private static List<String> extractExportedTypeNames(ShallowEntity shallowEntity) {
        ArrayList<String> exportedTypes = new ArrayList<String>();
        if (!CommonJSDependencyUtils.isExportStatement(shallowEntity)) {
            return exportedTypes;
        }
        if (shallowEntity.getChildren().size() != 1) {
            return exportedTypes;
        }
        if (CommonJSDependencyUtils.isSingleValueExport(shallowEntity)) {
            ShallowEntity assignedEntity = (ShallowEntity)shallowEntity.getChildren().get(0);
            CommonJSDependencyUtils.addToExportedTypesFromAssignedEntity(exportedTypes, assignedEntity);
        } else {
            exportedTypes.add(shallowEntity.getName());
        }
        return exportedTypes;
    }

    private static void addToExportedTypesFromAssignedEntity(List<String> exportedTypes, ShallowEntity assignedEntity) {
        if (assignedEntity.getSubtype().equals("anonymous block")) {
            CommonJSDependencyUtils.addToExportedTypesFromObjectLiteral(exportedTypes, assignedEntity);
        }
    }

    private static void addToExportedTypesFromObjectLiteral(List<String> exportedTypes, ShallowEntity objectLiteral) {
        UnmodifiableList exportTokens = objectLiteral.includedTokens();
        if (exportTokens.size() == 2) {
            return;
        }
        List<List<IToken>> separatedTokens = TokenStreamUtils.splitWithNesting(exportTokens.subList(1, exportTokens.size() - 1), ETokenType.COLON, ETokenType.LBRACE, ETokenType.RBRACE);
        CCSMAssert.isNotEmpty(separatedTokens, (String)"Expecting object literal to contain attribute mapping");
        separatedTokens.subList(0, separatedTokens.size() - 1).forEach(attributeKeyTerminatedStream -> exportedTypes.add(((IToken)Iterables.getLast((Iterable)attributeKeyTerminatedStream)).getText()));
    }

    private static boolean isSingleValueExport(ShallowEntity exportStatement) {
        UnmodifiableList exportStatementTokens = exportStatement.includedTokens();
        ETokenType[] nodeExportsSequence = new ETokenType[]{ETokenType.MODULE, ETokenType.DOT, ETokenType.IDENTIFIER, ETokenType.EQ};
        return TokenStreamUtils.startsWith((List<IToken>)exportStatementTokens, nodeExportsSequence) && CommonJSDependencyUtils.isExportsToken((IToken)exportStatementTokens.get(2));
    }

    private static boolean isExportsToken(IToken token) {
        return token.getType() == ETokenType.IDENTIFIER && EXPORTS.equals(token.getText());
    }

    private static boolean isExportStatement(ShallowEntity entity) {
        return entity.getSubtype().equals("commonjs exports") || entity.getSubtype().equals("nodejs module.exports");
    }

    private CommonJSDependencyUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

