/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util.javascript;

import java.util.regex.Pattern;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class JavascriptDependencyUtils {
    public static final String FILE_DEPENDENCY_PREFIX = "file:";
    private static final Pattern JS_FILE_EXTENSIONS_REGEX = Pattern.compile("(\\.tsx$|(\\.d)?\\.ts$|\\.js$)");
    private static final Pattern SLASH_REGEX = Pattern.compile("/");

    public static String convertUniformPathToTypeFormat(String uniformPath) {
        String pathWithoutExtension = JS_FILE_EXTENSIONS_REGEX.matcher(uniformPath).replaceAll("");
        return JavascriptDependencyUtils.normalizeSlashes(pathWithoutExtension);
    }

    public static String createFileType(String fileName) {
        return FILE_DEPENDENCY_PREFIX.concat(fileName.toLowerCase());
    }

    public static String normalizeSlashes(String path) {
        return SLASH_REGEX.matcher(path).replaceAll(".");
    }

    public static String joinTypeSuffix(String typePrefix, String typeSuffix) {
        return String.join((CharSequence)".", typePrefix, typeSuffix);
    }

    private JavascriptDependencyUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

