/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.matlab;

import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.matlab.EMatlabActionEntityType;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class MatlabActionAstNode {
    private EMatlabActionEntityType type;
    private final List<IToken> tokens;
    private final List<MatlabActionAstNode> children;

    protected MatlabActionAstNode(EMatlabActionEntityType type) {
        this(type, new ArrayList<IToken>(), new ArrayList<MatlabActionAstNode>());
    }

    protected MatlabActionAstNode(EMatlabActionEntityType type, List<IToken> tokens) {
        this(type, tokens, new ArrayList<MatlabActionAstNode>());
    }

    protected MatlabActionAstNode(EMatlabActionEntityType type, List<IToken> tokens, List<MatlabActionAstNode> children) {
        this.type = type;
        this.tokens = tokens;
        this.children = children;
    }

    public String toString() {
        Object representation = this.type.getReadableName();
        if (this.tokens.size() == 1 || this.type == EMatlabActionEntityType.FUNCTION) {
            representation = (String)representation + "[" + this.tokens.get(0).getText() + "]";
        }
        if (this.type == EMatlabActionEntityType.VARIABLE_WITH_TYPE) {
            representation = (String)representation + "[" + this.tokens.get(0).getText() + ", " + this.tokens.get(1).getText() + "]";
        }
        if (this.children.size() == 1) {
            representation = (String)representation + " > " + this.children.get(0).toString();
        } else if (this.children.size() > 1) {
            representation = (String)representation + " > (" + this.children.stream().map(MatlabActionAstNode::toString).collect(Collectors.joining(", ")) + ")";
        }
        return representation;
    }

    protected void addChild(MatlabActionAstNode child) {
        this.children.add(child);
        this.tokens.addAll(child.getTokens());
    }

    public void addChildren(List<MatlabActionAstNode> children) {
        for (MatlabActionAstNode child : children) {
            this.addChild(child);
        }
    }

    protected void addContentsOf(MatlabActionAstNode otherNode) {
        this.tokens.addAll(otherNode.getTokens());
        this.children.addAll(otherNode.getChildren());
    }

    public void addToken(IToken token) {
        this.tokens.add(token);
    }

    public void addTokens(List<IToken> tokens) {
        this.tokens.addAll(tokens);
    }

    public List<IToken> getTokens() {
        return this.tokens;
    }

    public EMatlabActionEntityType getType() {
        return this.type;
    }

    public List<MatlabActionAstNode> getChildren() {
        return this.children;
    }

    public void setType(EMatlabActionEntityType type) {
        this.type = type;
    }
}

