/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.matlab;

import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.matlab.EMatlabActionEntityType;
import eu.cqse.check.matlab.MatlabActionAstNode;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class MatlabActionAstUtils {
    public static List<MatlabActionAstNode> listComparisonNodes(MatlabActionAstNode rootNode) {
        LinkedList<MatlabActionAstNode> comparisonNodes = new LinkedList<MatlabActionAstNode>();
        MatlabActionAstUtils.listComparisonNodesRecursively(rootNode, comparisonNodes);
        return comparisonNodes;
    }

    private static void listComparisonNodesRecursively(MatlabActionAstNode node, List<MatlabActionAstNode> comparisonNodes) {
        if (EMatlabActionEntityType.COMPARISON == node.getType()) {
            comparisonNodes.add(node);
        }
        node.getChildren().forEach(child -> MatlabActionAstUtils.listComparisonNodesRecursively(child, comparisonNodes));
    }

    public static List<MatlabActionAstNode> listNodesOfEntityTypeRecursively(MatlabActionAstNode rootNode, EMatlabActionEntityType ... searchEntityType) {
        ArrayList<MatlabActionAstNode> nodesOfEntityType = new ArrayList<MatlabActionAstNode>();
        ArrayDeque<MatlabActionAstNode> stack = new ArrayDeque<MatlabActionAstNode>(Collections.singleton(rootNode));
        while (!stack.isEmpty()) {
            MatlabActionAstNode current = (MatlabActionAstNode)stack.pop();
            if (Arrays.asList(searchEntityType).contains((Object)current.getType())) {
                nodesOfEntityType.add(current);
            }
            stack.addAll(current.getChildren());
        }
        return nodesOfEntityType;
    }

    public static List<IToken> extractBinaryOperatorTokens(MatlabActionAstNode binaryOperatorNode) {
        CCSMAssert.isTrue((binaryOperatorNode.getChildren().size() == 2 ? 1 : 0) != 0, (String)"Must be used with binary operators only (2 children).");
        List<IToken> allTokens = binaryOperatorNode.getTokens();
        List<IToken> leftChild = binaryOperatorNode.getChildren().get(0).getTokens();
        List<IToken> rightChild = binaryOperatorNode.getChildren().get(1).getTokens();
        int leftChildEnd = leftChild.size();
        int rightChildBegin = allTokens.size() - rightChild.size();
        return allTokens.subList(leftChildEnd, rightChildBegin);
    }

    public static int getLineNumberForAstNode(MatlabActionAstNode node) {
        return node.getTokens().get(0).getLineNumber() + 1;
    }

    private MatlabActionAstUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

