/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.util.clang;

import com.google.common.base.Preconditions;
import eu.cqse.check.util.clang.ClangUtils;
import eu.cqse.check.util.clang.misra.EEssentialType;
import eu.cqse.clang.CXCursor;
import eu.cqse.clang.CXString;
import eu.cqse.clang.Clang;
import eu.cqse.clang.SWIGTYPE_p_CXTranslationUnitImpl;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.assertion.CCSMAssert;

public class BinaryOperatorExpression {
    private static final Logger LOGGER = LogManager.getLogger();
    public final CXCursor binaryExpressionCursor;
    public final EEssentialType leftHandOperandEssentialType;
    public final EEssentialType rightHandOperandEssentialType;
    public final String operator;

    private BinaryOperatorExpression(CXCursor binaryExpressionCursor, EEssentialType leftHandOperandEssentialType, EEssentialType rightHandOperandEssentialType, String operator) {
        this.binaryExpressionCursor = binaryExpressionCursor;
        this.leftHandOperandEssentialType = leftHandOperandEssentialType;
        this.rightHandOperandEssentialType = rightHandOperandEssentialType;
        this.operator = operator;
    }

    public static Optional<BinaryOperatorExpression> createFromCursor(CXCursor cursor, String fileText, SWIGTYPE_p_CXTranslationUnitImpl translationUnit) {
        CCSMAssert.isTrue((boolean)ClangUtils.isBinaryOperatorOrCompoundAssignment(cursor), (String)("Cursor must be of kind CXCursor_BinaryOperator or CXCursor_CompoundAssignOperator to use this method. It was " + Clang.clang_getCursorKind((CXCursor)cursor).toString() + " instead."));
        List<CXCursor> operands = ClangUtils.getDirectChildren(cursor);
        Preconditions.checkState((operands.size() == 2 ? 1 : 0) != 0, (Object)"Expected exactly two operands for binary operator.");
        Optional<String> completeNodeText = ClangUtils.getCompleteNodeText(cursor, fileText);
        if (!completeNodeText.isPresent()) {
            return Optional.empty();
        }
        Optional<String> operator = ClangUtils.getOperatorText(cursor, fileText);
        if (!operator.isPresent()) {
            return Optional.empty();
        }
        CXCursor leftHandSideOperandCursor = operands.get(0);
        CXCursor rightHandSideOperandCursor = operands.get(1);
        Optional<EEssentialType> leftHandOperandEssentialType = EEssentialType.getEssentialTypeOfCursor(leftHandSideOperandCursor);
        Optional<EEssentialType> rightHandOperandEssentialType = EEssentialType.getEssentialTypeOfCursor(rightHandSideOperandCursor);
        if (!leftHandOperandEssentialType.isPresent() || !rightHandOperandEssentialType.isPresent()) {
            String fileName = Clang.clang_getCString((CXString)Clang.clang_getTranslationUnitSpelling((SWIGTYPE_p_CXTranslationUnitImpl)translationUnit));
            LOGGER.warn("Unable to determine essential type for operands in binary operator: " + String.valueOf(completeNodeText) + ", leftHandOperandEssentialType=" + String.valueOf(leftHandOperandEssentialType) + ", rightHandOperandEssentialType=" + String.valueOf(rightHandOperandEssentialType) + ", fileName: " + fileName);
            return Optional.empty();
        }
        return Optional.of(new BinaryOperatorExpression(cursor, leftHandOperandEssentialType.get(), rightHandOperandEssentialType.get(), operator.get()));
    }
}

