/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.typedarrays;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.RandomAccess;
import org.mozilla.javascript.AbstractEcmaObjectOperations;
import org.mozilla.javascript.ArrayLikeAbstractOperations;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Constructable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ExternalArrayData;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.LambdaConstructor;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeArrayIterator;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SymbolKey;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;
import org.mozilla.javascript.typedarrays.NativeArrayBuffer;
import org.mozilla.javascript.typedarrays.NativeArrayBufferView;
import org.mozilla.javascript.typedarrays.NativeTypedArrayIterator;

public abstract class NativeTypedArrayView<T>
extends NativeArrayBufferView
implements List<T>,
RandomAccess,
ExternalArrayData {
    private static final long serialVersionUID = -4963053773152251274L;
    protected final int length;

    protected NativeTypedArrayView() {
        this.length = 0;
    }

    protected NativeTypedArrayView(NativeArrayBuffer ab, int off, int len, int byteLen) {
        super(ab, off, byteLen);
        this.length = len;
    }

    @Override
    public Object get(int index, Scriptable start) {
        return this.js_get(index);
    }

    @Override
    public Object get(String name, Scriptable start) {
        int ix;
        Optional<Double> num = ScriptRuntime.canonicalNumericIndexString(name);
        if (num.isPresent() && (ix = NativeTypedArrayView.toIndex(num.get())) >= 0) {
            return this.js_get(ix);
        }
        return super.get(name, start);
    }

    @Override
    public boolean has(int index, Scriptable start) {
        return !this.checkIndex(index);
    }

    @Override
    public boolean has(String name, Scriptable start) {
        int ix;
        Optional<Double> num = ScriptRuntime.canonicalNumericIndexString(name);
        if (num.isPresent() && (ix = NativeTypedArrayView.toIndex(num.get())) >= 0) {
            return !this.checkIndex(ix);
        }
        return super.has(name, start);
    }

    @Override
    public void put(int index, Scriptable start, Object val) {
        this.js_set(index, val);
    }

    @Override
    public void put(String name, Scriptable start, Object val) {
        Optional<Double> num = ScriptRuntime.canonicalNumericIndexString(name);
        if (num.isPresent()) {
            int ix = NativeTypedArrayView.toIndex(num.get());
            if (ix >= 0) {
                this.js_set(ix, val);
            }
        } else {
            super.put(name, start, val);
        }
    }

    @Override
    public void delete(int index) {
    }

    @Override
    public void delete(String name) {
        Optional<Double> num = ScriptRuntime.canonicalNumericIndexString(name);
        if (!num.isPresent()) {
            super.delete(name);
        }
    }

    @Override
    public Object[] getIds() {
        Object[] ret = new Object[this.length];
        for (int i = 0; i < this.length; ++i) {
            ret[i] = i;
        }
        return ret;
    }

    private static int toIndex(double num) {
        int ix = (int)num;
        if ((double)ix == num && ix >= 0) {
            return ix;
        }
        return -1;
    }

    static void init(Context cx, Scriptable scope, LambdaConstructor constructor, RealThis realThis) {
        constructor.definePrototypeProperty(cx, "buffer", thisObj -> NativeTypedArrayView.js_buffer(thisObj, realThis), 3);
        constructor.definePrototypeProperty(cx, "byteLength", thisObj -> NativeTypedArrayView.js_byteLength(thisObj, realThis), 3);
        constructor.definePrototypeProperty(cx, "byteOffset", thisObj -> NativeTypedArrayView.js_byteOffset(thisObj, realThis), 3);
        constructor.definePrototypeProperty(cx, "length", thisObj -> NativeTypedArrayView.js_length(thisObj, realThis), 3);
        constructor.definePrototypeMethod(scope, "at", 1, (lcx, lscope, thisObj, args) -> NativeTypedArrayView.js_at(lcx, lscope, thisObj, args, realThis), 2, 3);
        constructor.definePrototypeMethod(scope, "copyWithin", 1, (lcx, lscope, thisObj, args) -> NativeTypedArrayView.js_copyWithin(lcx, lscope, thisObj, args, realThis), 2, 3);
        constructor.definePrototypeMethod(scope, "entries", 0, (lcx, lscope, thisObj, args) -> {
            NativeTypedArrayView<?> self = realThis.realThis(thisObj);
            return new NativeArrayIterator(lscope, self, NativeArrayIterator.ARRAY_ITERATOR_TYPE.ENTRIES);
        }, 2, 3);
        constructor.definePrototypeMethod(scope, "every", 1, (lcx, lscope, thisObj, args) -> {
            NativeTypedArrayView<?> self = realThis.realThis(thisObj);
            return ArrayLikeAbstractOperations.iterativeMethod(lcx, ArrayLikeAbstractOperations.IterativeOperation.EVERY, lscope, self, args);
        }, 2, 3);
        constructor.definePrototypeMethod(scope, "fill", 1, (lcx, lscope, thisObj, args) -> NativeTypedArrayView.js_fill(lcx, lscope, thisObj, args, realThis), 2, 3);
        constructor.definePrototypeMethod(scope, "filter", 1, (lcx, lscope, thisObj, args) -> {
            NativeTypedArrayView<?> self = realThis.realThis(thisObj);
            Object array = ArrayLikeAbstractOperations.iterativeMethod(lcx, ArrayLikeAbstractOperations.IterativeOperation.FILTER, lscope, self, args);
            return self.typedArraySpeciesCreate(lcx, lscope, new Object[]{array}, "filter");
        }, 2, 3);
        constructor.definePrototypeMethod(scope, "find", 1, (lcx, lscope, thisObj, args) -> {
            NativeTypedArrayView<?> self = realThis.realThis(thisObj);
            return ArrayLikeAbstractOperations.iterativeMethod(lcx, ArrayLikeAbstractOperations.IterativeOperation.FIND, lscope, self, args);
        }, 2, 3);
        constructor.definePrototypeMethod(scope, "findIndex", 1, (lcx, lscope, thisObj, args) -> {
            NativeTypedArrayView<?> self = realThis.realThis(thisObj);
            return ArrayLikeAbstractOperations.iterativeMethod(lcx, ArrayLikeAbstractOperations.IterativeOperation.FIND_INDEX, lscope, self, args);
        }, 2, 3);
        constructor.definePrototypeMethod(scope, "findLast", 1, (lcx, lscope, thisObj, args) -> {
            NativeTypedArrayView<?> self = realThis.realThis(thisObj);
            return ArrayLikeAbstractOperations.iterativeMethod(lcx, ArrayLikeAbstractOperations.IterativeOperation.FIND_LAST, lscope, self, args);
        }, 2, 3);
        constructor.definePrototypeMethod(scope, "findLastIndex", 1, (lcx, lscope, thisObj, args) -> {
            NativeTypedArrayView<?> self = realThis.realThis(thisObj);
            return ArrayLikeAbstractOperations.iterativeMethod(lcx, ArrayLikeAbstractOperations.IterativeOperation.FIND_LAST_INDEX, lscope, self, args);
        }, 2, 3);
        constructor.definePrototypeMethod(scope, "forEach", 1, (lcx, lscope, thisObj, args) -> {
            NativeTypedArrayView<?> self = realThis.realThis(thisObj);
            return ArrayLikeAbstractOperations.iterativeMethod(lcx, ArrayLikeAbstractOperations.IterativeOperation.FOR_EACH, lscope, self, args);
        }, 2, 3);
        constructor.definePrototypeMethod(scope, "includes", 1, (lcx, lscope, thisObj, args) -> NativeTypedArrayView.js_includes(lcx, lscope, thisObj, args, realThis), 2, 3);
        constructor.definePrototypeMethod(scope, "indexOf", 1, (lcx, lscope, thisObj, args) -> NativeTypedArrayView.js_indexOf(lcx, lscope, thisObj, args, realThis), 2, 3);
        constructor.definePrototypeMethod(scope, "join", 1, (lcx, lscope, thisObj, args) -> NativeTypedArrayView.js_join(lcx, lscope, thisObj, args, realThis), 2, 3);
        constructor.definePrototypeMethod(scope, "keys", 0, (lcx, lscope, thisObj, args) -> {
            NativeTypedArrayView<?> self = realThis.realThis(thisObj);
            return new NativeArrayIterator(lscope, self, NativeArrayIterator.ARRAY_ITERATOR_TYPE.KEYS);
        }, 2, 3);
        constructor.definePrototypeMethod(scope, "lastIndexOf", 1, (lcx, lscope, thisObj, args) -> NativeTypedArrayView.js_lastIndexOf(lcx, lscope, thisObj, args, realThis), 2, 3);
        constructor.definePrototypeMethod(scope, "map", 1, (lcx, lscope, thisObj, args) -> {
            NativeTypedArrayView<?> self = realThis.realThis(thisObj);
            Object array = ArrayLikeAbstractOperations.iterativeMethod(lcx, ArrayLikeAbstractOperations.IterativeOperation.MAP, lscope, thisObj, args);
            return self.typedArraySpeciesCreate(lcx, lscope, new Object[]{array}, "map");
        }, 2, 3);
        constructor.definePrototypeMethod(scope, "reduce", 1, (lcx, lscope, thisObj, args) -> {
            NativeTypedArrayView<?> self = realThis.realThis(thisObj);
            return ArrayLikeAbstractOperations.reduceMethod(lcx, ArrayLikeAbstractOperations.ReduceOperation.REDUCE, lscope, self, args);
        }, 2, 3);
        constructor.definePrototypeMethod(scope, "reduceRight", 1, (lcx, lscope, thisObj, args) -> {
            NativeTypedArrayView<?> self = realThis.realThis(thisObj);
            return ArrayLikeAbstractOperations.reduceMethod(lcx, ArrayLikeAbstractOperations.ReduceOperation.REDUCE_RIGHT, lscope, self, args);
        }, 2, 3);
        constructor.definePrototypeMethod(scope, "reverse", 0, (lcx, lscope, thisObj, args) -> NativeTypedArrayView.js_reverse(lcx, lscope, thisObj, args, realThis), 2, 3);
        constructor.definePrototypeMethod(scope, "set", 0, (lcx, lscope, thisObj, args) -> NativeTypedArrayView.js_set(lcx, lscope, thisObj, args, realThis), 2, 3);
        constructor.definePrototypeMethod(scope, "slice", 2, (lcx, lscope, thisObj, args) -> NativeTypedArrayView.js_slice(lcx, lscope, thisObj, args, realThis), 2, 3);
        constructor.definePrototypeMethod(scope, "some", 1, (lcx, lscope, thisObj, args) -> {
            NativeTypedArrayView<?> self = realThis.realThis(thisObj);
            return ArrayLikeAbstractOperations.iterativeMethod(lcx, ArrayLikeAbstractOperations.IterativeOperation.SOME, lscope, self, args);
        }, 2, 3);
        constructor.definePrototypeMethod(scope, "sort", 1, (lcx, lscope, thisObj, args) -> NativeTypedArrayView.js_sort(lcx, lscope, thisObj, args, realThis), 2, 3);
        constructor.definePrototypeMethod(scope, "subarray", 2, (lcx, lscope, thisObj, args) -> NativeTypedArrayView.js_subarray(lcx, lscope, thisObj, args, realThis), 2, 3);
        constructor.definePrototypeMethod(scope, "toLocaleString", 0, (lcx, lscope, thisObj, args) -> NativeTypedArrayView.js_toString(lcx, lscope, thisObj, args, realThis, true), 2, 3);
        constructor.definePrototypeMethod(scope, "toReversed", 0, (lcx, lscope, thisObj, args) -> NativeTypedArrayView.js_toReversed(lcx, lscope, thisObj, args, realThis), 2, 3);
        constructor.definePrototypeMethod(scope, "toSorted", 1, (lcx, lscope, thisObj, args) -> NativeTypedArrayView.js_toSorted(lcx, lscope, thisObj, args, realThis), 2, 3);
        constructor.definePrototypeMethod(scope, "toString", 0, (lcx, lscope, thisObj, args) -> NativeTypedArrayView.js_toString(lcx, lscope, thisObj, args, realThis, false), 2, 3);
        constructor.definePrototypeMethod(scope, "values", 0, (lcx, lscope, thisObj, args) -> {
            NativeTypedArrayView<?> self = realThis.realThis(thisObj);
            return new NativeArrayIterator(lscope, self, NativeArrayIterator.ARRAY_ITERATOR_TYPE.VALUES);
        }, 2, 3);
        constructor.definePrototypeMethod(scope, "with", 2, (lcx, lscope, thisObj, args) -> NativeTypedArrayView.js_with(lcx, lscope, thisObj, args, realThis), 2, 3);
        constructor.definePrototypeMethod(scope, SymbolKey.ITERATOR, 0, (lcx, lscope, thisObj, args) -> {
            NativeTypedArrayView<?> self = realThis.realThis(thisObj);
            return new NativeArrayIterator(lscope, self, NativeArrayIterator.ARRAY_ITERATOR_TYPE.VALUES);
        }, 2, 3);
    }

    protected boolean checkIndex(int index) {
        return index < 0 || index >= this.length;
    }

    public abstract int getBytesPerElement();

    protected abstract Object js_get(int var1);

    protected abstract Object js_set(int var1, Object var2);

    private static NativeArrayBuffer makeArrayBuffer(Context cx, Scriptable scope, int length, int bytesPerElement) {
        return (NativeArrayBuffer)cx.newObject(scope, "ArrayBuffer", new Object[]{(double)length * (double)bytesPerElement});
    }

    protected static NativeTypedArrayView<?> js_constructor(Context cx, Scriptable scope, Object[] args, TypedArrayConstructable constructable, int bytesPerElement) {
        if (!NativeTypedArrayView.isArg(args, 0)) {
            return constructable.construct(new NativeArrayBuffer(), 0, 0);
        }
        Object arg0 = args[0];
        if (arg0 == null) {
            return constructable.construct(new NativeArrayBuffer(), 0, 0);
        }
        if (arg0 instanceof Number || arg0 instanceof String) {
            int length = ScriptRuntime.toInt32(arg0);
            NativeArrayBuffer buffer = NativeTypedArrayView.makeArrayBuffer(cx, scope, length, bytesPerElement);
            return constructable.construct(buffer, 0, length);
        }
        if (arg0 instanceof NativeTypedArrayView) {
            NativeTypedArrayView src = (NativeTypedArrayView)arg0;
            NativeArrayBuffer na = NativeTypedArrayView.makeArrayBuffer(cx, scope, src.length, bytesPerElement);
            NativeTypedArrayView<?> v = constructable.construct(na, 0, src.length);
            for (int i = 0; i < src.length; ++i) {
                v.js_set(i, src.js_get(i));
            }
            return v;
        }
        if (arg0 instanceof NativeArrayBuffer) {
            NativeArrayBuffer na = (NativeArrayBuffer)arg0;
            int byteOff = NativeTypedArrayView.isArg(args, 1) ? ScriptRuntime.toInt32(args[1]) : 0;
            int byteLen = NativeTypedArrayView.isArg(args, 2) ? ScriptRuntime.toInt32(args[2]) * bytesPerElement : na.getLength() - byteOff;
            if (byteOff < 0 || byteOff > na.getLength()) {
                String msg = ScriptRuntime.getMessageById("msg.typed.array.bad.offset", byteOff);
                throw ScriptRuntime.rangeError(msg);
            }
            if (byteLen < 0 || byteOff + byteLen > na.getLength()) {
                String msg = ScriptRuntime.getMessageById("msg.typed.array.bad.length", byteLen);
                throw ScriptRuntime.rangeError(msg);
            }
            if (byteOff % bytesPerElement != 0) {
                String msg = ScriptRuntime.getMessageById("msg.typed.array.bad.offset.byte.size", byteOff, bytesPerElement);
                throw ScriptRuntime.rangeError(msg);
            }
            if (byteLen % bytesPerElement != 0) {
                String msg = ScriptRuntime.getMessageById("msg.typed.array.bad.buffer.length.byte.size", byteLen, bytesPerElement);
                throw ScriptRuntime.rangeError(msg);
            }
            return constructable.construct(na, byteOff, byteLen / bytesPerElement);
        }
        if (arg0 instanceof NativeArray) {
            NativeArray array = (NativeArray)arg0;
            NativeArrayBuffer na = NativeTypedArrayView.makeArrayBuffer(cx, scope, array.size(), bytesPerElement);
            NativeTypedArrayView<?> v = constructable.construct(na, 0, array.size());
            for (int i = 0; i < array.size(); ++i) {
                Object value = array.get(i, (Scriptable)array);
                if (value == Scriptable.NOT_FOUND || value == Undefined.instance) {
                    v.js_set(i, ScriptRuntime.NaNobj);
                    continue;
                }
                if (value instanceof Wrapper) {
                    v.js_set(i, ((Wrapper)value).unwrap());
                    continue;
                }
                v.js_set(i, value);
            }
            return v;
        }
        if (ScriptRuntime.isArrayObject(arg0)) {
            Object[] arrayElements = ScriptRuntime.getArrayElements((Scriptable)arg0);
            NativeArrayBuffer na = NativeTypedArrayView.makeArrayBuffer(cx, scope, arrayElements.length, bytesPerElement);
            NativeTypedArrayView<?> v = constructable.construct(na, 0, arrayElements.length);
            for (int i = 0; i < arrayElements.length; ++i) {
                v.js_set(i, arrayElements[i]);
            }
            return v;
        }
        throw ScriptRuntime.constructError("Error", "invalid argument");
    }

    private void setRange(NativeTypedArrayView<?> v, int off) {
        if (off < 0 || off > this.length) {
            String msg = ScriptRuntime.getMessageById("msg.typed.array.bad.offset", off);
            throw ScriptRuntime.rangeError(msg);
        }
        if (v.length > this.length - off) {
            String msg = ScriptRuntime.getMessageById("msg.typed.array.bad.source.array", new Object[0]);
            throw ScriptRuntime.rangeError(msg);
        }
        if (v.arrayBuffer == this.arrayBuffer) {
            int i;
            Object[] tmp = new Object[v.length];
            for (i = 0; i < v.length; ++i) {
                tmp[i] = v.js_get(i);
            }
            for (i = 0; i < v.length; ++i) {
                this.js_set(i + off, tmp[i]);
            }
        } else {
            for (int i = 0; i < v.length; ++i) {
                this.js_set(i + off, v.js_get(i));
            }
        }
    }

    private void setRange(NativeArray a, int off) {
        if (off < 0 || off > this.length) {
            String msg = ScriptRuntime.getMessageById("msg.typed.array.bad.offset", off);
            throw ScriptRuntime.rangeError(msg);
        }
        if (off + a.size() > this.length) {
            String msg = ScriptRuntime.getMessageById("msg.typed.array.bad.source.array", new Object[0]);
            throw ScriptRuntime.rangeError(msg);
        }
        int pos = off;
        for (Object val : a) {
            this.js_set(pos, val);
            ++pos;
        }
    }

    private static Object js_buffer(Scriptable thisObj, RealThis realThis) {
        return realThis.realThis((Scriptable)thisObj).arrayBuffer;
    }

    private static Object js_byteLength(Scriptable thisObj, RealThis realThis) {
        NativeTypedArrayView<?> o = realThis.realThis(thisObj);
        return o.byteLength;
    }

    private static Object js_byteOffset(Scriptable thisObj, RealThis realThis) {
        NativeTypedArrayView<?> o = realThis.realThis(thisObj);
        return o.offset;
    }

    private static Object js_length(Scriptable thisObj, RealThis realThis) {
        NativeTypedArrayView<?> o = realThis.realThis(thisObj);
        return o.length;
    }

    private static String js_toString(Context cx, Scriptable scope, Scriptable thisObj, Object[] args, RealThis realThis, boolean useLocale) {
        NativeTypedArrayView<?> self = realThis.realThis(thisObj);
        StringBuilder builder = new StringBuilder();
        if (self.length > 0) {
            Object elem = self.getElemForToString(cx, scope, 0, useLocale);
            builder.append(ScriptRuntime.toString(elem));
        }
        for (int i = 1; i < self.length; ++i) {
            builder.append(',');
            Object elem = self.getElemForToString(cx, scope, i, useLocale);
            builder.append(ScriptRuntime.toString(elem));
        }
        return builder.toString();
    }

    private Object getElemForToString(Context cx, Scriptable scope, int index, boolean useLocale) {
        Object elem = this.js_get(index);
        if (useLocale) {
            Callable fun = ScriptRuntime.getPropFunctionAndThis(elem, "toLocaleString", cx, scope);
            Scriptable funThis = ScriptRuntime.lastStoredScriptable(cx);
            return fun.call(cx, scope, funThis, ScriptRuntime.emptyArgs);
        }
        return elem;
    }

    private static Boolean js_includes(Context cx, Scriptable scope, Scriptable thisObj, Object[] args, RealThis realThis) {
        long start;
        Object compareTo;
        NativeTypedArrayView<?> self = realThis.realThis(thisObj);
        Object object = compareTo = args.length > 0 ? args[0] : Undefined.instance;
        if (self.length == 0) {
            return Boolean.FALSE;
        }
        if (args.length < 2) {
            start = 0L;
        } else {
            start = (long)ScriptRuntime.toInteger(args[1]);
            if (start < 0L && (start += (long)self.length) < 0L) {
                start = 0L;
            }
            if (start > (long)(self.length - 1)) {
                return Boolean.FALSE;
            }
        }
        for (int i = (int)start; i < self.length; ++i) {
            Object val = self.js_get(i);
            if (!ScriptRuntime.sameZero(val, compareTo)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private static Object js_indexOf(Context cx, Scriptable scope, Scriptable thisObj, Object[] args, RealThis realThis) {
        long start;
        Object compareTo;
        NativeTypedArrayView<?> self = realThis.realThis(thisObj);
        Object object = compareTo = args.length > 0 ? args[0] : Undefined.instance;
        if (self.length == 0) {
            return -1;
        }
        if (args.length < 2) {
            start = 0L;
        } else {
            start = (long)ScriptRuntime.toInteger(args[1]);
            if (start < 0L && (start += (long)self.length) < 0L) {
                start = 0L;
            }
            if (start > (long)(self.length - 1)) {
                return -1;
            }
        }
        for (int i = (int)start; i < self.length; ++i) {
            Object val = self.js_get(i);
            if (val == NOT_FOUND || !ScriptRuntime.shallowEq(val, compareTo)) continue;
            return (long)i;
        }
        return -1;
    }

    private static Object js_lastIndexOf(Context cx, Scriptable scope, Scriptable thisObj, Object[] args, RealThis realThis) {
        long start;
        Object compareTo;
        NativeTypedArrayView<?> self = realThis.realThis(thisObj);
        Object object = compareTo = args.length > 0 ? args[0] : Undefined.instance;
        if (self.length == 0) {
            return -1;
        }
        if (args.length < 2) {
            start = (long)self.length - 1L;
        } else {
            start = (long)ScriptRuntime.toInteger(args[1]);
            if (start >= (long)self.length) {
                start = (long)self.length - 1L;
            } else if (start < 0L) {
                start += (long)self.length;
            }
            if (start < 0L) {
                return -1;
            }
        }
        for (int i = (int)start; i >= 0; --i) {
            Object val = self.js_get(i);
            if (val == NOT_FOUND || !ScriptRuntime.shallowEq(val, compareTo)) continue;
            return (long)i;
        }
        return -1;
    }

    private static Scriptable js_slice(Context cx, Scriptable scope, Scriptable thisObj, Object[] args, RealThis realThis) {
        long end;
        long begin;
        NativeTypedArrayView<?> self = realThis.realThis(thisObj);
        if (args.length == 0) {
            begin = 0L;
            end = self.length;
        } else {
            begin = ArrayLikeAbstractOperations.toSliceIndex(ScriptRuntime.toInteger(args[0]), self.length);
            end = args.length == 1 || args[1] == Undefined.instance ? (long)self.length : ArrayLikeAbstractOperations.toSliceIndex(ScriptRuntime.toInteger(args[1]), self.length);
        }
        if (end - begin > Integer.MAX_VALUE) {
            String msg = ScriptRuntime.getMessageById("msg.arraylength.bad", new Object[0]);
            throw ScriptRuntime.rangeError(msg);
        }
        long count = Math.max(end - begin, 0L);
        return self.typedArraySpeciesCreate(cx, scope, new Object[]{self.arrayBuffer, begin * (long)self.getBytesPerElement(), Math.max(0L, end - begin)}, "slice");
    }

    private static String js_join(Context cx, Scriptable scope, Scriptable thisObj, Object[] args, RealThis realThis) {
        String str;
        String separator;
        NativeTypedArrayView<?> self = realThis.realThis(thisObj);
        String string = separator = args.length < 1 || args[0] == Undefined.instance ? "," : ScriptRuntime.toString(args[0]);
        if (self.length == 0) {
            return "";
        }
        String[] buf = new String[self.length];
        int total_size = 0;
        for (int i = 0; i != self.length; ++i) {
            Object temp = self.js_get(i);
            if (temp == null || temp == Undefined.instance) continue;
            str = ScriptRuntime.toString(temp);
            total_size += str.length();
            buf[i] = str;
        }
        StringBuilder sb = new StringBuilder(total_size += (self.length - 1) * separator.length());
        for (int i = 0; i != self.length; ++i) {
            if (i != 0) {
                sb.append(separator);
            }
            if ((str = buf[i]) == null) continue;
            sb.append(str);
        }
        return sb.toString();
    }

    private static NativeTypedArrayView<?> js_reverse(Context cx, Scriptable scope, Scriptable thisObj, Object[] args, RealThis realThis) {
        NativeTypedArrayView<?> self = realThis.realThis(thisObj);
        int i = 0;
        for (int j = self.length - 1; i < j; ++i, --j) {
            Object temp = self.js_get(i);
            self.js_set(i, self.js_get(j));
            self.js_set(j, temp);
        }
        return self;
    }

    private static NativeTypedArrayView<?> js_fill(Context cx, Scriptable scope, Scriptable thisObj, Object[] args, RealThis realThis) {
        NativeTypedArrayView<?> self = realThis.realThis(thisObj);
        long relativeStart = 0L;
        if (args.length >= 2) {
            relativeStart = (long)ScriptRuntime.toInteger(args[1]);
        }
        long k = relativeStart < 0L ? Math.max((long)self.length + relativeStart, 0L) : Math.min(relativeStart, (long)self.length);
        long relativeEnd = self.length;
        if (args.length >= 3 && !Undefined.isUndefined(args[2])) {
            relativeEnd = (long)ScriptRuntime.toInteger(args[2]);
        }
        long fin = relativeEnd < 0L ? Math.max((long)self.length + relativeEnd, 0L) : Math.min(relativeEnd, (long)self.length);
        Object value = args.length > 0 ? args[0] : Undefined.instance;
        int i = (int)k;
        while ((long)i < fin) {
            self.js_set(i, value);
            ++i;
        }
        return self;
    }

    private static Scriptable js_sort(Context cx, Scriptable scope, Scriptable thisObj, Object[] args, RealThis realThis) {
        if (NativeTypedArrayView.isArg(args, 0) && !(args[0] instanceof Callable)) {
            throw ScriptRuntime.typeErrorById("msg.function.expected", new Object[0]);
        }
        NativeTypedArrayView<?> self = realThis.realThis(thisObj);
        Object[] working = self.sortTemporaryArray(cx, scope, args);
        for (int i = 0; i < self.length; ++i) {
            self.js_set(i, working[i]);
        }
        return self;
    }

    private Object[] sortTemporaryArray(Context cx, Scriptable scope, Object[] args) {
        Comparator<Object> comparator = args.length > 0 && Undefined.instance != args[0] ? ArrayLikeAbstractOperations.getSortComparator(cx, scope, args) : Comparator.comparingDouble(e -> ((Number)e).doubleValue());
        Object[] working = this.toArray();
        Arrays.sort(working, comparator);
        return working;
    }

    private static Object js_copyWithin(Context cx, Scriptable scope, Scriptable thisObj, Object[] args, RealThis realThis) {
        NativeTypedArrayView<?> self = realThis.realThis(thisObj);
        Object targetArg = args.length >= 1 ? args[0] : Undefined.instance;
        long relativeTarget = (long)ScriptRuntime.toInteger(targetArg);
        long to = relativeTarget < 0L ? Math.max((long)self.length + relativeTarget, 0L) : Math.min(relativeTarget, (long)self.length);
        Object startArg = args.length >= 2 ? args[1] : Undefined.instance;
        long relativeStart = (long)ScriptRuntime.toInteger(startArg);
        long from = relativeStart < 0L ? Math.max((long)self.length + relativeStart, 0L) : Math.min(relativeStart, (long)self.length);
        long relativeEnd = self.length;
        if (args.length >= 3 && !Undefined.isUndefined(args[2])) {
            relativeEnd = (long)ScriptRuntime.toInteger(args[2]);
        }
        long fin = relativeEnd < 0L ? Math.max((long)self.length + relativeEnd, 0L) : Math.min(relativeEnd, (long)self.length);
        long count = Math.min(fin - from, (long)self.length - to);
        int direction = 1;
        if (from < to && to < from + count) {
            direction = -1;
            from = from + count - 1L;
            to = to + count - 1L;
        }
        while (count > 0L) {
            Object temp = self.js_get((int)from);
            self.js_set((int)to, temp);
            from += (long)direction;
            to += (long)direction;
            --count;
        }
        return self;
    }

    private static Object js_set(Context cx, Scriptable scope, Scriptable thisObj, Object[] args, RealThis realThis) {
        NativeTypedArrayView<?> self = realThis.realThis(thisObj);
        if (args.length > 0) {
            if (args[0] instanceof NativeTypedArrayView) {
                int offset = NativeTypedArrayView.isArg(args, 1) ? ScriptRuntime.toInt32(args[1]) : 0;
                NativeTypedArrayView nativeView = (NativeTypedArrayView)args[0];
                self.setRange(nativeView, offset);
                return Undefined.instance;
            }
            if (args[0] instanceof NativeArray) {
                int offset = NativeTypedArrayView.isArg(args, 1) ? ScriptRuntime.toInt32(args[1]) : 0;
                self.setRange((NativeArray)args[0], offset);
                return Undefined.instance;
            }
            if (args[0] instanceof Scriptable) {
                return Undefined.instance;
            }
            if (NativeTypedArrayView.isArg(args, 2)) {
                return self.js_set(ScriptRuntime.toInt32(args[0]), args[1]);
            }
        }
        throw ScriptRuntime.constructError("Error", "invalid arguments");
    }

    private static Object js_subarray(Context cx, Scriptable scope, Scriptable thisObj, Object[] args, RealThis realThis) {
        int end;
        NativeTypedArrayView<?> self = realThis.realThis(thisObj);
        int start = NativeTypedArrayView.isArg(args, 0) ? ScriptRuntime.toInt32(args[0]) : 0;
        int n = end = NativeTypedArrayView.isArg(args, 1) ? ScriptRuntime.toInt32(args[1]) : self.length;
        if (cx.getLanguageVersion() >= 200 || args.length > 0) {
            start = start < 0 ? self.length + start : start;
            end = end < 0 ? self.length + end : end;
            start = Math.max(0, start);
            end = Math.min(self.length, end);
            int len = Math.max(0, end - start);
            int byteOff = Math.min(self.getByteOffset() + start * self.getBytesPerElement(), self.arrayBuffer.getLength());
            return cx.newObject(scope, self.getClassName(), new Object[]{self.arrayBuffer, byteOff, len});
        }
        throw ScriptRuntime.constructError("Error", "invalid arguments");
    }

    private static Object js_at(Context cx, Scriptable scope, Scriptable thisObj, Object[] args, RealThis realThis) {
        long k;
        NativeTypedArrayView<?> self = realThis.realThis(thisObj);
        long relativeIndex = 0L;
        if (args.length >= 1) {
            relativeIndex = (long)ScriptRuntime.toInteger(args[0]);
        }
        long l = k = relativeIndex >= 0L ? relativeIndex : (long)self.length + relativeIndex;
        if (k < 0L || k >= (long)self.length) {
            return Undefined.instance;
        }
        return NativeTypedArrayView.getProperty(thisObj, (int)k);
    }

    private Scriptable typedArraySpeciesCreate(Context cx, Scriptable scope, Object[] args, String methodName) {
        Scriptable topLevelScope = ScriptableObject.getTopLevelScope(scope);
        Function defaultConstructor = ScriptRuntime.getExistingCtor(cx, topLevelScope, this.getClassName());
        Constructable constructable = AbstractEcmaObjectOperations.speciesConstructor(cx, this, defaultConstructor);
        Scriptable newArray = constructable.construct(cx, scope, args);
        if (!(newArray instanceof NativeTypedArrayView)) {
            throw ScriptRuntime.typeErrorById("msg.typed.array.ctor.incompatible", methodName);
        }
        return newArray;
    }

    private static Object js_toReversed(Context cx, Scriptable scope, Scriptable thisObj, Object[] args, RealThis realThis) {
        NativeTypedArrayView<?> self = realThis.realThis(thisObj);
        NativeArrayBuffer newBuffer = new NativeArrayBuffer(self.length * self.getBytesPerElement());
        Scriptable result = cx.newObject(scope, self.getClassName(), new Object[]{newBuffer, 0, self.length, self.getBytesPerElement()});
        for (int k = 0; k < self.length; ++k) {
            int from = self.length - k - 1;
            Object fromValue = self.js_get(from);
            result.put(k, result, fromValue);
        }
        return result;
    }

    private static Object js_toSorted(Context cx, Scriptable scope, Scriptable thisObj, Object[] args, RealThis realThis) {
        NativeTypedArrayView<?> self = realThis.realThis(thisObj);
        Object[] working = self.sortTemporaryArray(cx, scope, args);
        NativeArrayBuffer newBuffer = new NativeArrayBuffer(self.length * self.getBytesPerElement());
        Scriptable result = cx.newObject(scope, self.getClassName(), new Object[]{newBuffer, 0, self.length, self.getBytesPerElement()});
        for (int k = 0; k < self.length; ++k) {
            result.put(k, result, working[k]);
        }
        return result;
    }

    private static Object js_with(Context cx, Scriptable scope, Scriptable thisObj, Object[] args, RealThis realThis) {
        NativeTypedArrayView<?> self = realThis.realThis(thisObj);
        long relativeIndex = args.length > 0 ? (long)((int)ScriptRuntime.toInteger(args[0])) : 0L;
        long actualIndex = relativeIndex >= 0L ? relativeIndex : (long)self.length + relativeIndex;
        Double argsValue = args.length > 1 ? ScriptRuntime.toNumber(args[1]) : 0.0;
        if (actualIndex < 0L || actualIndex >= (long)self.length) {
            String msg = ScriptRuntime.getMessageById("msg.typed.array.index.out.of.bounds", relativeIndex, self.length * -1, self.length - 1);
            throw ScriptRuntime.rangeError(msg);
        }
        NativeArrayBuffer newBuffer = new NativeArrayBuffer(self.length * self.getBytesPerElement());
        Scriptable result = cx.newObject(scope, self.getClassName(), new Object[]{newBuffer, 0, self.length, self.getBytesPerElement()});
        for (int k = 0; k < self.length; ++k) {
            Double fromValue = (long)k == actualIndex ? argsValue : self.js_get(k);
            result.put(k, result, (Object)fromValue);
        }
        return result;
    }

    @Override
    public Object getArrayElement(int index) {
        return this.js_get(index);
    }

    @Override
    public void setArrayElement(int index, Object value) {
        this.js_set(index, value);
    }

    @Override
    public int getArrayLength() {
        return this.length;
    }

    @Override
    public boolean containsAll(Collection<?> objects) {
        for (Object o : objects) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int indexOf(Object o) {
        for (int i = 0; i < this.length; ++i) {
            if (!o.equals(this.js_get(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        for (int i = this.length - 1; i >= 0; --i) {
            if (!o.equals(this.js_get(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Object[] toArray() {
        Object[] a = new Object[this.length];
        for (int i = 0; i < this.length; ++i) {
            a[i] = this.js_get(i);
        }
        return a;
    }

    @Override
    public <U> U[] toArray(U[] ts) {
        Object[] a = ts.length >= this.length ? ts : (Object[])Array.newInstance(ts.getClass().getComponentType(), this.length);
        for (int i = 0; i < this.length; ++i) {
            try {
                a[i] = this.js_get(i);
                continue;
            }
            catch (ClassCastException cce) {
                throw new ArrayStoreException();
            }
        }
        return a;
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof NativeTypedArrayView)) {
            return false;
        }
        NativeTypedArrayView v = (NativeTypedArrayView)o;
        if (this.length != v.length) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            if (this.js_get(i).equals(v.js_get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hc = 0;
        for (int i = 0; i < this.length; ++i) {
            hc += this.js_get(i).hashCode();
        }
        return hc;
    }

    @Override
    public Iterator<T> iterator() {
        return new NativeTypedArrayIterator(this, 0);
    }

    @Override
    public ListIterator<T> listIterator() {
        return new NativeTypedArrayIterator(this, 0);
    }

    @Override
    public ListIterator<T> listIterator(int start) {
        if (this.checkIndex(start)) {
            throw new IndexOutOfBoundsException();
        }
        return new NativeTypedArrayIterator(this, start);
    }

    @Override
    public List<T> subList(int i, int i2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(T aByte) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int i, T aByte) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> bytes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int i, Collection<? extends T> bytes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> objects) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> objects) {
        throw new UnsupportedOperationException();
    }

    protected static interface RealThis {
        public NativeTypedArrayView<?> realThis(Scriptable var1);
    }

    protected static interface TypedArrayConstructable {
        public NativeTypedArrayView<?> construct(NativeArrayBuffer var1, int var2, int var3);
    }
}

