/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.reportparser.parser.ctc;

import com.teamscale.reportparser.parser.ctc.InvalidCtcCoverageFileException;
import com.teamscale.reportparser.parser.ctc.ProbeInfo;
import org.conqat.engine.sourcecode.coverage.ELineCoverage;
import org.conqat.lib.commons.string.StringUtils;
import org.xml.sax.Attributes;

public class CtcReportHelper {
    public static int getExecutionCounter1(Attributes attributes) {
        return CtcReportHelper.getExecutionCounter(attributes, "count1", 0);
    }

    public static int getExecutionCounter2(Attributes attributes) {
        return CtcReportHelper.getExecutionCounter(attributes, "count2", 0);
    }

    public static ProbeInfo.EExecutionInfo getExecutionInfoFromAttribute(Attributes attributes, String attributeName) {
        return ProbeInfo.EExecutionInfo.fromInt(CtcReportHelper.getExecutionCounter(attributes, attributeName, -1));
    }

    private static int getExecutionCounter(Attributes attributes, String attributeName, int defaultValue) {
        return CtcReportHelper.toInt(attributes.getValue(attributeName), defaultValue);
    }

    public static boolean isExpr(String probeType) {
        return probeType.startsWith("expr_");
    }

    public static boolean isNoEndBlockConstruct(ProbeInfo currentProbeInfo) {
        String probeType = currentProbeInfo.getType();
        return CtcReportHelper.isReturnOrBreak(probeType) || CtcReportHelper.isTernary(probeType) || CtcReportHelper.isThrow(probeType) || CtcReportHelper.isExpr(probeType) || CtcReportHelper.isContinue(probeType) || CtcReportHelper.isGoto(probeType) || CtcReportHelper.isLabel(probeType);
    }

    public static boolean isReturnOrBreak(String probeType) {
        return "return".equalsIgnoreCase(probeType) || "break".equalsIgnoreCase(probeType);
    }

    public static boolean isTernary(String probeType) {
        return "ternary".equalsIgnoreCase(probeType);
    }

    public static boolean isElse(String probeType) {
        return "else".equalsIgnoreCase(probeType);
    }

    public static boolean isContinue(String probeType) {
        return "continue".equalsIgnoreCase(probeType);
    }

    public static boolean isGoto(String probeType) {
        return "goto".equalsIgnoreCase(probeType);
    }

    public static boolean isLabel(String probeType) {
        return "label".equalsIgnoreCase(probeType);
    }

    public static boolean isThrow(String probeType) {
        return "throw".equalsIgnoreCase(probeType);
    }

    public static boolean isForLoop(String probeType) {
        return "for".equalsIgnoreCase(probeType);
    }

    public static boolean isWhileLoop(String probeType) {
        return probeType.contains("while");
    }

    public static boolean isIfOrElseIf(String probeType) {
        return probeType.contains("if");
    }

    public static boolean isDoWhile(String probeType) {
        return "do".equalsIgnoreCase(probeType);
    }

    public static boolean isCaseOrCaseDefault(String probeType) {
        return "case".equalsIgnoreCase(probeType) || "default".equalsIgnoreCase(probeType);
    }

    public static void validateIntegerAttribute(String errorMessage, int intAttribute) throws InvalidCtcCoverageFileException {
        if (intAttribute == -1) {
            throw new InvalidCtcCoverageFileException(errorMessage);
        }
    }

    public static int toInt(String value, int defaultValue) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static boolean isLoop(String probeType) {
        return CtcReportHelper.isForLoop(probeType) || CtcReportHelper.isWhileLoop(probeType);
    }

    public static boolean isBranch(String probeType) {
        return CtcReportHelper.isIfOrElseIf(probeType) || CtcReportHelper.isTernary(probeType);
    }

    public static boolean isIgnoredProbeType(String probeType) {
        return probeType.startsWith("multi_cond_") || CtcReportHelper.isDoWhile(probeType) || CtcReportHelper.isLineDirective(probeType);
    }

    public static boolean isLineDirective(String probeType) {
        return probeType.equals("line_directive");
    }

    public static ELineCoverage determineLineCoverageForLoopAndBranchConstruct(ProbeInfo.EExecutionInfo executedWithTrueValue, ProbeInfo.EExecutionInfo executedWithFalseValue, String probeType) {
        if (executedWithTrueValue == ProbeInfo.EExecutionInfo.NOT_EXECUTED && executedWithFalseValue == ProbeInfo.EExecutionInfo.NOT_EXECUTED) {
            return ELineCoverage.NOT_COVERED;
        }
        if (executedWithTrueValue == ProbeInfo.EExecutionInfo.NOT_EXECUTED && executedWithFalseValue == ProbeInfo.EExecutionInfo.EXECUTED) {
            if (CtcReportHelper.isLoop(probeType)) {
                return ELineCoverage.NOT_COVERED;
            }
            return ELineCoverage.PARTIALLY_COVERED;
        }
        if (executedWithTrueValue == ProbeInfo.EExecutionInfo.EXECUTED && executedWithFalseValue == ProbeInfo.EExecutionInfo.NOT_EXECUTED) {
            if (CtcReportHelper.isLoop(probeType)) {
                return ELineCoverage.FULLY_COVERED;
            }
            return ELineCoverage.PARTIALLY_COVERED;
        }
        return ELineCoverage.FULLY_COVERED;
    }

    public static String removeConstPrefix(String probeType) {
        return StringUtils.stripPrefix((String)probeType, (String)"const_");
    }
}

