/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiBreakStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiConditionalLoopStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaToken;
import org.jetbrains.kotlin.com.intellij.psi.PsiPatternVariable;
import org.jetbrains.kotlin.com.intellij.psi.PsiStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhileStatement;
import org.jetbrains.kotlin.com.intellij.psi.ResolveState;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.Constants;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ChildRole;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java.PsiLoopStatementImpl;
import org.jetbrains.kotlin.com.intellij.psi.scope.ElementClassHint;
import org.jetbrains.kotlin.com.intellij.psi.scope.NameHint;
import org.jetbrains.kotlin.com.intellij.psi.scope.PatternResolveState;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;

public class PsiWhileStatementImpl
extends PsiLoopStatementImpl
implements PsiWhileStatement,
Constants {
    private static final Logger LOG = Logger.getInstance(PsiWhileStatementImpl.class);

    public PsiWhileStatementImpl() {
        super(WHILE_STATEMENT);
    }

    @Override
    public PsiExpression getCondition() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(32);
    }

    @Override
    public PsiStatement getBody() {
        return (PsiStatement)this.findChildByRoleAsPsiElement(38);
    }

    @Override
    public PsiJavaToken getLParenth() {
        return (PsiJavaToken)this.findChildByRoleAsPsiElement(24);
    }

    @Override
    public PsiJavaToken getRParenth() {
        return (PsiJavaToken)this.findChildByRoleAsPsiElement(25);
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 35: {
                return this.findChildByType(WHILE_KEYWORD);
            }
            case 24: {
                return this.findChildByType(LPARENTH);
            }
            case 32: {
                return this.findChildByType(EXPRESSION_BIT_SET);
            }
            case 25: {
                return this.findChildByType(RPARENTH);
            }
            case 38: 
        }
        return PsiImplUtil.findStatementChild(this);
    }

    @Override
    public int getChildRole(@NotNull ASTNode child) {
        if (child == null) {
            PsiWhileStatementImpl.$$$reportNull$$$0(0);
        }
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == WHILE_KEYWORD) {
            return 35;
        }
        if (i == LPARENTH) {
            return 24;
        }
        if (i == RPARENTH) {
            return 25;
        }
        if (EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 32;
        }
        if (child.getPsi() instanceof PsiStatement) {
            return 38;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiWhileStatementImpl.$$$reportNull$$$0(1);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitWhileStatement(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        ElementClassHint elementClassHint;
        if (processor2 == null) {
            PsiWhileStatementImpl.$$$reportNull$$$0(2);
        }
        if (state == null) {
            PsiWhileStatementImpl.$$$reportNull$$$0(3);
        }
        if (place == null) {
            PsiWhileStatementImpl.$$$reportNull$$$0(4);
        }
        if ((elementClassHint = processor2.getHint(ElementClassHint.KEY)) != null && !elementClassHint.shouldProcess(ElementClassHint.DeclarationKind.VARIABLE)) {
            return true;
        }
        if (lastParent == null) {
            return PsiWhileStatementImpl.processDeclarationsInLoopCondition(processor2, state, place, this);
        }
        PsiExpression condition = this.getCondition();
        if (condition != null && lastParent == this.getBody()) {
            return condition.processDeclarations(processor2, PatternResolveState.WHEN_TRUE.putInto(state), null, place);
        }
        return true;
    }

    static boolean processDeclarationsInLoopCondition(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, @NotNull PsiElement place, @NotNull PsiConditionalLoopStatement loop) {
        if (processor2 == null) {
            PsiWhileStatementImpl.$$$reportNull$$$0(5);
        }
        if (state == null) {
            PsiWhileStatementImpl.$$$reportNull$$$0(6);
        }
        if (place == null) {
            PsiWhileStatementImpl.$$$reportNull$$$0(7);
        }
        if (loop == null) {
            PsiWhileStatementImpl.$$$reportNull$$$0(8);
        }
        if (state.get(PatternResolveState.KEY) == PatternResolveState.WHEN_NONE) {
            return true;
        }
        PsiExpression condition = loop.getCondition();
        if (condition == null) {
            return true;
        }
        PsiScopeProcessor conditionProcessor = (element, s) -> {
            assert (element instanceof PsiPatternVariable);
            NameHint hint = processor2.getHint(NameHint.KEY);
            if (hint != null && !((PsiPatternVariable)element).getName().equals(hint.getName(s))) {
                return true;
            }
            PatternResolveState resolveState = PatternResolveState.stateAtParent((PsiPatternVariable)element, condition);
            if (resolveState == PatternResolveState.WHEN_TRUE || !PsiTreeUtil.processElements(loop, e -> !(e instanceof PsiBreakStatement) || ((PsiBreakStatement)e).findExitedStatement() != loop)) {
                return true;
            }
            return processor2.execute(element, s);
        };
        return condition.processDeclarations(conditionProcessor, PatternResolveState.WHEN_BOTH.putInto(state), null, place);
    }

    @Override
    public String toString() {
        return "PsiWhileStatement";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loop";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiWhileStatementImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getChildRole";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processDeclarations";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "processDeclarationsInLoopCondition";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

