/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.api.checks;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.sonarsource.kotlin.api.checks.ArgumentMatcher;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u00a7\u0001\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u0014\b\u0002\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u000b\u0012\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u000f\u0012\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u000f\u0012\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u000f\u0012\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u000f\u0012\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010#\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010'\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010(\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010)\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010*\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020%H\u0002J\u0010\u0010,\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010-\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020%H\u0002J\u0010\u0010.\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020%H\u0002J\u0010\u0010/\u001a\u00020\u00042\u0006\u0010+\u001a\u00020%H\u0002J\u0010\u00100\u001a\u00020\u000f2\b\u0010+\u001a\u0004\u0018\u00010%J\u0016\u00100\u001a\u00020\u000f2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u000204J\u0016\u00100\u001a\u00020\u000f2\u0006\u00105\u001a\u0002062\u0006\u00103\u001a\u000204J\u0016\u00100\u001a\u00020\u000f2\u0006\u00105\u001a\u0002072\u0006\u00103\u001a\u000204J\u0014\u00100\u001a\u00020\u000f2\f\u00108\u001a\b\u0012\u0002\b\u0003\u0018\u000109J\u0012\u0010:\u001a\u00020\u000f2\b\u00101\u001a\u0004\u0018\u000102H\u0002R\u001d\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0015\u0010\u0010\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\n\n\u0002\u0010\u001b\u001a\u0004\b\u0010\u0010\u001aR\u0015\u0010\u0011\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\n\n\u0002\u0010\u001b\u001a\u0004\b\u0011\u0010\u001aR\u0015\u0010\u0013\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\n\n\u0002\u0010\u001b\u001a\u0004\b\u0013\u0010\u001aR\u0015\u0010\u0012\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\n\n\u0002\u0010\u001b\u001a\u0004\b\u0012\u0010\u001aR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0019R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0019R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006;"}, d2={"Lorg/sonarsource/kotlin/api/checks/FunMatcherImpl;", "", "qualifiers", "", "", "names", "nameRegex", "Lkotlin/text/Regex;", "maxArgumentCount", "", "arguments", "", "Lorg/sonarsource/kotlin/api/checks/ArgumentMatcher;", "definingSupertypes", "matchConstructor", "", "isDynamic", "isExtensionFunction", "isSuspending", "isOperator", "returnType", "(Ljava/util/Set;Ljava/util/Set;Lkotlin/text/Regex;ILjava/util/List;Ljava/util/Set;ZLjava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/String;)V", "getArguments", "()Ljava/util/List;", "getDefiningSupertypes", "()Ljava/util/Set;", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "getNameRegex", "()Lkotlin/text/Regex;", "getNames", "getQualifiers", "qualifiersOrDefiningSupertypes", "getReturnType", "()Ljava/lang/String;", "checkCallParameters", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "checkIsDynamic", "checkIsExtensionFunction", "checkIsOperator", "checkIsSuspending", "checkName", "functionDescriptor", "checkReturnType", "checkSubType", "checkTypeOrSupertype", "getActualQualifier", "matches", "call", "Lorg/jetbrains/kotlin/psi/Call;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "node", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "preCheckArgumentCount", "sonar-kotlin-api"})
@SourceDebugExtension(value={"SMAP\nFunMatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FunMatcher.kt\norg/sonarsource/kotlin/api/checks/FunMatcherImpl\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,269:1\n1247#2,2:270\n1747#3,2:272\n1839#3,9:274\n1749#3:283\n1#4:284\n*S KotlinDebug\n*F\n+ 1 FunMatcher.kt\norg/sonarsource/kotlin/api/checks/FunMatcherImpl\n*L\n116#1:270,2\n134#1:272,2\n136#1:274,9\n134#1:283\n*E\n"})
public final class FunMatcherImpl {
    @NotNull
    private final Set<String> qualifiers;
    @NotNull
    private final Set<String> names;
    @Nullable
    private final Regex nameRegex;
    private final int maxArgumentCount;
    @NotNull
    private final List<List<ArgumentMatcher>> arguments;
    @NotNull
    private final Set<String> definingSupertypes;
    private final boolean matchConstructor;
    @Nullable
    private final Boolean isDynamic;
    @Nullable
    private final Boolean isExtensionFunction;
    @Nullable
    private final Boolean isSuspending;
    @Nullable
    private final Boolean isOperator;
    @Nullable
    private final String returnType;
    @NotNull
    private final Set<String> qualifiersOrDefiningSupertypes;

    public FunMatcherImpl(@NotNull Set<String> qualifiers, @NotNull Set<String> names2, @Nullable Regex nameRegex, int maxArgumentCount, @NotNull List<? extends List<ArgumentMatcher>> arguments2, @NotNull Set<String> definingSupertypes, boolean matchConstructor, @Nullable Boolean isDynamic, @Nullable Boolean isExtensionFunction, @Nullable Boolean isSuspending, @Nullable Boolean isOperator, @Nullable String returnType2) {
        Intrinsics.checkNotNullParameter(qualifiers, "qualifiers");
        Intrinsics.checkNotNullParameter(names2, "names");
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        Intrinsics.checkNotNullParameter(definingSupertypes, "definingSupertypes");
        this.qualifiers = qualifiers;
        this.names = names2;
        this.nameRegex = nameRegex;
        this.maxArgumentCount = maxArgumentCount;
        this.arguments = arguments2;
        this.definingSupertypes = definingSupertypes;
        this.matchConstructor = matchConstructor;
        this.isDynamic = isDynamic;
        this.isExtensionFunction = isExtensionFunction;
        this.isSuspending = isSuspending;
        this.isOperator = isOperator;
        this.returnType = returnType2;
        this.qualifiersOrDefiningSupertypes = this.definingSupertypes.isEmpty() ? this.qualifiers : (this.qualifiers.isEmpty() ? this.definingSupertypes : SetsKt.plus(this.qualifiers, (Iterable)this.definingSupertypes));
    }

    public /* synthetic */ FunMatcherImpl(Set set, Set set2, Regex regex, int n, List list2, Set set3, boolean bl, Boolean bl2, Boolean bl3, Boolean bl4, Boolean bl5, String string2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            set = SetsKt.emptySet();
        }
        if ((n2 & 2) != 0) {
            set2 = SetsKt.emptySet();
        }
        if ((n2 & 4) != 0) {
            regex = null;
        }
        if ((n2 & 8) != 0) {
            n = Integer.MAX_VALUE;
        }
        if ((n2 & 0x10) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n2 & 0x20) != 0) {
            set3 = SetsKt.emptySet();
        }
        if ((n2 & 0x40) != 0) {
            bl = false;
        }
        if ((n2 & 0x80) != 0) {
            bl2 = null;
        }
        if ((n2 & 0x100) != 0) {
            bl3 = null;
        }
        if ((n2 & 0x200) != 0) {
            bl4 = null;
        }
        if ((n2 & 0x400) != 0) {
            bl5 = null;
        }
        if ((n2 & 0x800) != 0) {
            string2 = null;
        }
        this(set, set2, regex, n, list2, set3, bl, bl2, bl3, bl4, bl5, string2);
    }

    @NotNull
    public final Set<String> getQualifiers() {
        return this.qualifiers;
    }

    @NotNull
    public final Set<String> getNames() {
        return this.names;
    }

    @Nullable
    public final Regex getNameRegex() {
        return this.nameRegex;
    }

    @NotNull
    public final List<List<ArgumentMatcher>> getArguments() {
        return this.arguments;
    }

    @NotNull
    public final Set<String> getDefiningSupertypes() {
        return this.definingSupertypes;
    }

    @Nullable
    public final Boolean isDynamic() {
        return this.isDynamic;
    }

    @Nullable
    public final Boolean isExtensionFunction() {
        return this.isExtensionFunction;
    }

    @Nullable
    public final Boolean isSuspending() {
        return this.isSuspending;
    }

    @Nullable
    public final Boolean isOperator() {
        return this.isOperator;
    }

    @Nullable
    public final String getReturnType() {
        return this.returnType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean matches(@NotNull KtCallExpression node, @NotNull BindingContext bindingContext2) {
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(bindingContext2, "bindingContext");
        Call call2 = CallUtilKt.getCall(node, bindingContext2);
        if (!this.preCheckArgumentCount(call2)) return false;
        ResolvedCall resolvedCall2 = (ResolvedCall)bindingContext2.get(BindingContext.RESOLVED_CALL, call2);
        if (!this.matches((CallableDescriptor)(resolvedCall2 != null ? resolvedCall2.getResultingDescriptor() : null))) return false;
        return true;
    }

    public final boolean matches(@NotNull KtNamedFunction node, @NotNull BindingContext bindingContext2) {
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(bindingContext2, "bindingContext");
        SimpleFunctionDescriptor functionDescriptor = (SimpleFunctionDescriptor)bindingContext2.get(BindingContext.FUNCTION, node);
        return this.matches(functionDescriptor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean matches(@NotNull Call call2, @NotNull BindingContext bindingContext2) {
        Intrinsics.checkNotNullParameter(call2, "call");
        Intrinsics.checkNotNullParameter(bindingContext2, "bindingContext");
        if (!this.preCheckArgumentCount(call2)) return false;
        ResolvedCall resolvedCall2 = (ResolvedCall)bindingContext2.get(BindingContext.RESOLVED_CALL, call2);
        if (!this.matches((CallableDescriptor)(resolvedCall2 != null ? resolvedCall2.getResultingDescriptor() : null))) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean matches(@Nullable ResolvedCall<?> resolvedCall2) {
        ResolvedCall<?> resolvedCall3 = resolvedCall2;
        if (!this.preCheckArgumentCount(resolvedCall3 != null ? resolvedCall3.getCall() : null)) return false;
        ResolvedCall<?> resolvedCall4 = resolvedCall2;
        if (!this.matches((CallableDescriptor)(resolvedCall4 != null ? resolvedCall4.getResultingDescriptor() : null))) return false;
        return true;
    }

    private final boolean preCheckArgumentCount(Call call2) {
        return call2 == null || call2.getValueArguments().size() <= this.maxArgumentCount;
    }

    public final boolean matches(@Nullable CallableDescriptor functionDescriptor) {
        return functionDescriptor != null && this.checkIsDynamic(functionDescriptor) && this.checkIsExtensionFunction(functionDescriptor) && this.checkIsSuspending(functionDescriptor) && this.checkIsOperator(functionDescriptor) && this.checkName(functionDescriptor) && this.checkTypeOrSupertype(functionDescriptor) && this.checkReturnType(functionDescriptor) && this.checkCallParameters(functionDescriptor);
    }

    private final boolean checkTypeOrSupertype(CallableDescriptor functionDescriptor) {
        Collection collection;
        return this.qualifiersOrDefiningSupertypes.isEmpty() || this.qualifiersOrDefiningSupertypes.contains(this.getActualQualifier(functionDescriptor)) || !((collection = (Collection)this.definingSupertypes) == null || collection.isEmpty()) && this.checkSubType(functionDescriptor);
    }

    private final String getActualQualifier(CallableDescriptor functionDescriptor) {
        String string2;
        if (functionDescriptor instanceof ConstructorDescriptor) {
            ClassDescriptor classDescriptor2 = ((ConstructorDescriptor)functionDescriptor).getConstructedClass();
            Intrinsics.checkNotNullExpressionValue(classDescriptor2, "getConstructedClass(...)");
            string2 = DescriptorUtilsKt.getFqNameSafe(classDescriptor2).asString();
        } else {
            String string3 = DescriptorUtilsKt.getFqNameSafe(functionDescriptor).asString();
            Intrinsics.checkNotNullExpressionValue(string3, "asString(...)");
            string2 = StringsKt.substringBeforeLast$default(string3, ".", null, 2, null);
        }
        String string4 = string2;
        Intrinsics.checkNotNull(string4);
        return string4;
    }

    private final boolean checkSubType(CallableDescriptor functionDescriptor) {
        boolean bl;
        block3: {
            if (functionDescriptor instanceof ConstructorDescriptor) {
                bl = false;
            } else {
                Sequence<CallableDescriptor> $this$any$iv = DescriptorUtilsKt.overriddenTreeUniqueAsSequence(functionDescriptor, true);
                boolean $i$f$any = false;
                Iterator<CallableDescriptor> iterator2 = $this$any$iv.iterator();
                while (iterator2.hasNext()) {
                    CallableDescriptor element$iv;
                    CallableDescriptor it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    String string2 = DescriptorUtilsKt.getFqNameSafe(it).asString();
                    Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
                    if (!this.definingSupertypes.contains(StringsKt.substringBeforeLast$default(string2, ".", null, 2, null))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean checkName(CallableDescriptor functionDescriptor) {
        boolean bl;
        if (functionDescriptor instanceof ConstructorDescriptor) {
            bl = this.matchConstructor;
        } else if (!this.matchConstructor) {
            String string2 = functionDescriptor.getName().asString();
            Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
            String name = string2;
            bl = this.nameRegex == null && this.names.isEmpty() || this.names.contains(name) || this.nameRegex != null && this.nameRegex.matches(name);
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkCallParameters(CallableDescriptor descriptor2) {
        boolean bl;
        List<ValueParameterDescriptor> list2 = descriptor2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "getValueParameters(...)");
        List<ValueParameterDescriptor> valueParameters2 = list2;
        if (this.arguments.isEmpty()) return true;
        Iterable $this$any$iv = this.arguments;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            List it = (List)element$iv;
            boolean bl2 = false;
            if (valueParameters2.size() == it.size()) {
                void $this$foldRightIndexed$iv;
                List list3 = it;
                boolean initial$iv = true;
                boolean $i$f$foldRightIndexed = false;
                boolean accumulator$iv = initial$iv;
                if (!$this$foldRightIndexed$iv.isEmpty()) {
                    ListIterator iterator$iv = $this$foldRightIndexed$iv.listIterator($this$foldRightIndexed$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        void argType;
                        void acc;
                        int index$iv = iterator$iv.previousIndex();
                        boolean bl3 = accumulator$iv;
                        ArgumentMatcher argumentMatcher = (ArgumentMatcher)iterator$iv.previous();
                        int i = index$iv;
                        boolean bl4 = false;
                        accumulator$iv = acc != false && argType.matches(valueParameters2.get(i));
                    }
                }
                if (accumulator$iv) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private final boolean checkIsDynamic(CallableDescriptor descriptor2) {
        boolean bl;
        Boolean bl2 = this.isDynamic;
        if (bl2 != null) {
            boolean it = bl2;
            boolean bl3 = false;
            bl = it == DynamicCallsKt.isDynamic(descriptor2);
        } else {
            bl = true;
        }
        return bl;
    }

    private final boolean checkIsExtensionFunction(CallableDescriptor descriptor2) {
        boolean bl;
        Boolean bl2 = this.isExtensionFunction;
        if (bl2 != null) {
            boolean it = bl2;
            boolean bl3 = false;
            bl = it == DescriptorUtilsKt.isExtension(descriptor2);
        } else {
            bl = true;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkReturnType(CallableDescriptor descriptor2) {
        KotlinType kotlinType;
        String string2 = this.returnType;
        String string3 = string2;
        if (string2 == null) return true;
        String it = string3;
        boolean bl = false;
        KotlinType kotlinType2 = kotlinType = descriptor2.getReturnType();
        Object object = kotlinType2;
        if (kotlinType2 == null) return true;
        TypeConstructor typeConstructor2 = ((KotlinType)object).getConstructor();
        object = typeConstructor2;
        if (typeConstructor2 == null) return true;
        ClassifierDescriptor classifierDescriptor = object.getDeclarationDescriptor();
        if (classifierDescriptor == null) return true;
        Boolean bl2 = Intrinsics.areEqual(it, org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt.getKotlinTypeFqName(kotlinType, false));
        string3 = bl2;
        if (bl2 == null) return true;
        boolean bl3 = (Boolean)((Object)string3);
        return bl3;
    }

    private final boolean checkIsSuspending(CallableDescriptor descriptor2) {
        boolean bl;
        Boolean bl2 = this.isSuspending;
        if (bl2 != null) {
            boolean it = bl2;
            boolean bl3 = false;
            bl = it == org.jetbrains.kotlin.backend.common.descriptors.DescriptorUtilsKt.isSuspend(descriptor2);
        } else {
            bl = true;
        }
        return bl;
    }

    private final boolean checkIsOperator(CallableDescriptor descriptor2) {
        boolean bl;
        Boolean bl2 = this.isOperator;
        if (bl2 != null) {
            boolean it = bl2;
            boolean bl3 = false;
            FunctionDescriptor functionDescriptor = descriptor2 instanceof FunctionDescriptor ? (FunctionDescriptor)descriptor2 : null;
            bl = it == (functionDescriptor != null ? functionDescriptor.isOperator() : false);
        } else {
            bl = true;
        }
        return bl;
    }

    public FunMatcherImpl() {
        this(null, null, null, 0, null, null, false, null, null, null, null, null, 4095, null);
    }
}

