/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.gradle.checks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.calls.util.PsiUtilsKt;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.reporting.KotlinTextRanges;
import org.sonarsource.kotlin.api.reporting.SecondaryLocation;
import org.sonarsource.kotlin.gradle.checks.DependencyChecksKt;

@Rule(key="S6629")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/sonarsource/kotlin/gradle/checks/DependencyGroupedCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "()V", "checkDependencyHandlerScopeLambda", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "kotlinFileContext", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "visitCallExpression", "DependencyHandlerScopeLambdaCheck", "sonar-kotlin-gradle"})
public final class DependencyGroupedCheck
extends AbstractCheck {
    @Override
    public void visitCallExpression(@NotNull KtCallExpression expression2, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        if (!Intrinsics.areEqual(DependencyChecksKt.getFunctionName(expression2), "dependencies")) {
            return;
        }
        this.checkDependencyHandlerScopeLambda(expression2, kotlinFileContext);
    }

    private final void checkDependencyHandlerScopeLambda(KtCallExpression expression2, KotlinFileContext kotlinFileContext) {
        DependencyHandlerScopeLambdaCheck visitor2 = new DependencyHandlerScopeLambdaCheck(kotlinFileContext);
        KtBlockExpression ktBlockExpression = DependencyChecksKt.getLambdaBlock(expression2);
        if (ktBlockExpression != null) {
            ktBlockExpression.acceptChildren(visitor2);
        }
        if (!((Collection)visitor2.getSecondaryLocations()).isEmpty()) {
            AbstractCheck abstractCheck = this;
            KtExpression ktExpression = PsiUtilsKt.getCalleeExpressionIfAny(expression2);
            Intrinsics.checkNotNull(ktExpression);
            AbstractCheck.reportIssue$default(abstractCheck, kotlinFileContext, (PsiElement)ktExpression, "Group dependencies by their destination.", visitor2.getSecondaryLocations(), null, 8, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/sonarsource/kotlin/gradle/checks/DependencyGroupedCheck$DependencyHandlerScopeLambdaCheck;", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "kotlinFileContext", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "(Lorg/sonarsource/kotlin/gradle/checks/DependencyGroupedCheck;Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;)V", "lastNameInOrder", "", "secondaryLocations", "", "Lorg/sonarsource/kotlin/api/reporting/SecondaryLocation;", "getSecondaryLocations", "()Ljava/util/List;", "visitedNames", "", "checkFunctionReferenceOrder", "", "functionReference", "Lorg/jetbrains/kotlin/psi/KtNameReferenceExpression;", "visitCallExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "sonar-kotlin-gradle"})
    private final class DependencyHandlerScopeLambdaCheck
    extends KtVisitorVoid {
        @NotNull
        private final KotlinFileContext kotlinFileContext;
        @Nullable
        private String lastNameInOrder;
        @NotNull
        private final Set<String> visitedNames;
        @NotNull
        private final List<SecondaryLocation> secondaryLocations;

        public DependencyHandlerScopeLambdaCheck(KotlinFileContext kotlinFileContext) {
            Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
            this.kotlinFileContext = kotlinFileContext;
            this.visitedNames = new LinkedHashSet();
            this.secondaryLocations = new ArrayList();
        }

        @NotNull
        public final List<SecondaryLocation> getSecondaryLocations() {
            return this.secondaryLocations;
        }

        @Override
        public void visitCallExpression(@NotNull KtCallExpression expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            KtExpression ktExpression = PsiUtilsKt.getCalleeExpressionIfAny(expression2);
            KtNameReferenceExpression ktNameReferenceExpression = ktExpression instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)ktExpression : null;
            if (ktNameReferenceExpression == null) {
                return;
            }
            KtNameReferenceExpression functionReference = ktNameReferenceExpression;
            String functionName = functionReference.getReferencedName();
            if (Intrinsics.areEqual(functionName, "constraints")) {
                DependencyGroupedCheck.this.checkDependencyHandlerScopeLambda(expression2, this.kotlinFileContext);
            } else if (DependencyChecksKt.getREF_NAME_DEPENDENCY_HANDLER_SCOPE_EXTENSIONS().contains(functionName)) {
                this.checkFunctionReferenceOrder(functionReference);
            }
        }

        public final void checkFunctionReferenceOrder(@NotNull KtNameReferenceExpression functionReference) {
            Intrinsics.checkNotNullParameter(functionReference, "functionReference");
            String functionName = functionReference.getReferencedName();
            if (this.lastNameInOrder != null && !Intrinsics.areEqual(functionName, this.lastNameInOrder) && this.visitedNames.contains(functionName)) {
                this.secondaryLocations.add(new SecondaryLocation(KotlinTextRanges.INSTANCE.textRange(this.kotlinFileContext, functionReference), null, 2, null));
            } else {
                this.lastNameInOrder = functionName;
            }
            this.visitedNames.add(functionName);
        }
    }
}

