/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.admin.instance_comparison.snapshot;

import com.google.common.collect.ImmutableSet;
import com.teamscale.core.analysis.trigger.MaintenanceTriggerBase;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.index.admin.instance_comparison.snapshot.InstanceComparisonSnapshotCreationIndex;
import com.teamscale.index.admin.instance_comparison.snapshot.InstanceComparisonSnapshotCreationOptions;
import com.teamscale.index.admin.instance_comparison.snapshot.InstanceComparisonSnapshotMetaData;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.InstanceComparisonContributionBase;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.global.GlobalComparisonContributorBase;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.global.GlobalComparisonContributorFactory;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.global.MaintenanceLogErrorsComparisonContributor;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.global.UserGroupComparisonContributor;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.FilePathsComparisonContributor;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.FindingsComparisonContributor;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.IComparisonContributorContext;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.MetricsComparisonContributor;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.ParseLogErrorsComparisonContributor;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.ProjectComparisonContributorBase;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.ProjectComparisonContributorFactory;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.ProjectConfigurationComparisonContributor;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.RepositoryActivityComparisonContributor;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.SpecItemComparisonContributor;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.WorkerLogErrorsComparisonContributor;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.tga.TestGapAnalysisComparisonContributor;
import com.teamscale.index.configuration.EAnalysisProfileVersion;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.function.ConsumerWithException;
import org.conqat.lib.commons.string.StringUtils;

public class InstanceComparisonSnapshotCreationTrigger
extends MaintenanceTriggerBase {
    private static final ImmutableSet<GlobalComparisonContributorFactory> GLOBAL_COMPARISON_CONTRIBUTORS = ImmutableSet.of(UserGroupComparisonContributor::new, MaintenanceLogErrorsComparisonContributor::new);
    private static final ImmutableSet<ProjectComparisonContributorFactory> PROJECT_COMPARISON_CONTRIBUTORS = ImmutableSet.of(RepositoryActivityComparisonContributor::new, MetricsComparisonContributor::new, FindingsComparisonContributor::new, FilePathsComparisonContributor::new, WorkerLogErrorsComparisonContributor::new, ParseLogErrorsComparisonContributor::new, (Object[])new ProjectComparisonContributorFactory[]{TestGapAnalysisComparisonContributor::new, ProjectConfigurationComparisonContributor::new, SpecItemComparisonContributor::new});
    private static final int PROJECT_PARALLEL_BATCH_SIZE = 1;

    public void execute() throws Exception {
        String instanceComparisonId = this.jobDescriptor.getParameter();
        CCSMAssert.isFalse((boolean)StringUtils.isEmpty((String)instanceComparisonId), (String)"Could not find instance comparison id (must be supplied as job parameter)");
        InstanceComparisonSnapshotCreationIndex snapshotIndex = (InstanceComparisonSnapshotCreationIndex)this.indexLayer.openGlobalIndex(InstanceComparisonSnapshotCreationIndex.class);
        InstanceComparisonSnapshotMetaData snapshotMetadata = snapshotIndex.getSnapshotMetaData(instanceComparisonId).orElseThrow(() -> new IllegalStateException("No instance comparison metadata found for id %s".formatted(instanceComparisonId)));
        try {
            this.computeSnapshot(snapshotMetadata.getOptions(), (ConsumerWithException<InstanceComparisonContributionBase, ConQATException>)((ConsumerWithException)contribution -> snapshotIndex.storeSnapshotContribution(instanceComparisonId, (InstanceComparisonContributionBase)contribution)));
            snapshotMetadata.setCompleted();
        }
        catch (Throwable e) {
            snapshotMetadata.setFailed(e);
            throw e;
        }
        finally {
            snapshotIndex.storeSnapshotMetaData(snapshotMetadata);
        }
    }

    private void computeSnapshot(InstanceComparisonSnapshotCreationOptions options, ConsumerWithException<InstanceComparisonContributionBase, ConQATException> contributionPersister) throws ConQATException, ExecutionException {
        List<PublicProjectId> publicIds = options.getFilteredProjectsIds();
        this.executeInParallel(CollectionUtils.map(GLOBAL_COMPARISON_CONTRIBUTORS, globalComparisonContributorFactory -> () -> {
            this.verifyNotCanceled();
            this.runGlobalComparisonContributor(options, contributionPersister, (GlobalComparisonContributorFactory)globalComparisonContributorFactory);
        }));
        ProjectIndex projectIndex = (ProjectIndex)this.indexLayer.openGlobalIndex(ProjectIndex.class);
        this.executeInParallelBatches(publicIds, batch -> {
            for (PublicProjectId publicId : batch) {
                this.runProjectComparisonContributorsInParallelForProject(options, contributionPersister, projectIndex, publicId);
            }
        }, 1);
    }

    private void runProjectComparisonContributorsInParallelForProject(InstanceComparisonSnapshotCreationOptions options, ConsumerWithException<InstanceComparisonContributionBase, ConQATException> contributionPersister, ProjectIndex projectIndex, PublicProjectId publicId) throws ExecutionException {
        this.executeInParallel(CollectionUtils.map(PROJECT_COMPARISON_CONTRIBUTORS, projectComparisonContributorFactory -> () -> {
            this.verifyNotCanceled();
            this.runProjectComparisonContributor(options, contributionPersister, projectIndex, publicId, (ProjectComparisonContributorFactory)projectComparisonContributorFactory);
        }));
    }

    private void runProjectComparisonContributor(InstanceComparisonSnapshotCreationOptions options, ConsumerWithException<InstanceComparisonContributionBase, ConQATException> contributionPersister, ProjectIndex projectIndex, PublicProjectId publicId, ProjectComparisonContributorFactory projectComparisonContributor) throws ConQATException {
        ProjectComparisonContributorBase comparisonContributor = projectComparisonContributor.create(new IComparisonContributorContext.ProjectContext(this.indexLayer, options.getEndTimestamp(), options.isDetailedSnapshot(), projectIndex.resolveToInternalId((IProjectId)publicId), publicId, options.getBranchName(), EAnalysisProfileVersion.CURRENT_VERSION));
        contributionPersister.accept((Object)comparisonContributor.createComparisonInput());
    }

    private void runGlobalComparisonContributor(InstanceComparisonSnapshotCreationOptions options, ConsumerWithException<InstanceComparisonContributionBase, ConQATException> contributionPersister, GlobalComparisonContributorFactory globalComparisonContributor) throws ConQATException {
        GlobalComparisonContributorBase comparisonContributor = globalComparisonContributor.create(new IComparisonContributorContext.GlobalContext(this.indexLayer, options.getEndTimestamp(), options.isDetailedSnapshot()));
        contributionPersister.accept((Object)comparisonContributor.createComparisonInput());
    }
}

