/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.admin.instance_comparison.snapshot;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.teamscale.core.migration.IJsonMigration;
import com.teamscale.index.admin.instance_comparison.snapshot.MigrationChanges;
import com.teamscale.index.configuration.AnalysisProfileMigrationCollector;
import com.teamscale.index.configuration.EAnalysisProfileVersion;
import com.teamscale.index.migration.finding.ConfigurationOptionDeletion;
import com.teamscale.index.migration.finding.ConfigurationOptionReplacement;
import com.teamscale.index.migration.finding.DataDrivenFindingMigration;
import com.teamscale.index.migration.finding.GlobalOptionDeletion;
import com.teamscale.index.migration.finding.GlobalOptionReplacement;
import java.util.ArrayList;
import java.util.List;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.jspecify.annotations.Nullable;

public final class InstanceComparisonUtils {
    public static MigrationChanges collectChangesCausedByMigrations(@Nullable String analysisProfileJson, @Nullable EAnalysisProfileVersion version, GlobalStorageSystem globalStorageSystem) {
        MigrationChanges migrationChanges = MigrationChanges.create();
        if (analysisProfileJson == null) {
            return MigrationChanges.create();
        }
        AnalysisProfileMigrationCollector collector = new AnalysisProfileMigrationCollector(globalStorageSystem);
        List<List<? extends IJsonMigration>> allMigrations = collector.collectMigrations(analysisProfileJson, version);
        for (List<? extends IJsonMigration> migrationsInVersion : allMigrations) {
            for (IJsonMigration iJsonMigration : migrationsInVersion) {
                InstanceComparisonUtils.addMigrationIfSuited(iJsonMigration, migrationChanges);
            }
        }
        return migrationChanges;
    }

    public static List<ObjectNode> getAnalysisProfilesCopeScopeAware(ObjectNode projectConfiguration) {
        ArrayList<ObjectNode> analysisProfileNodes = new ArrayList<ObjectNode>();
        ObjectNode embeddedProfile = (ObjectNode)projectConfiguration.get("embeddedProfile");
        if (embeddedProfile != null) {
            analysisProfileNodes.add(embeddedProfile);
            return analysisProfileNodes;
        }
        ArrayNode codeScopes = (ArrayNode)projectConfiguration.get("codeScopes");
        CCSMAssert.isNotNull((Object)codeScopes, (String)"expected at least one code scope, found none");
        for (JsonNode codeScope : codeScopes) {
            analysisProfileNodes.add((ObjectNode)codeScope.get("embeddedProfile"));
        }
        return analysisProfileNodes;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void addMigrationIfSuited(IJsonMigration migration, MigrationChanges migrationChangesToFill) {
        if (migration instanceof ConfigurationOptionReplacement) {
            ConfigurationOptionReplacement replacement = (ConfigurationOptionReplacement)migration;
            if (replacement.removeOldOption) {
                migrationChangesToFill.addConfigurationOptionRename(replacement);
                return;
            }
        }
        if (migration instanceof GlobalOptionReplacement) {
            GlobalOptionReplacement globalOptionReplacement = (GlobalOptionReplacement)migration;
            migrationChangesToFill.addGlobalOptionReplacement(globalOptionReplacement);
            return;
        }
        if (migration instanceof ConfigurationOptionDeletion) {
            ConfigurationOptionDeletion configurationDeletion = (ConfigurationOptionDeletion)migration;
            migrationChangesToFill.addOptionDeletion(configurationDeletion.getOldGroupName(), configurationDeletion.getOldOptionName());
            return;
        }
        if (migration instanceof GlobalOptionDeletion) {
            GlobalOptionDeletion optionDeletion = (GlobalOptionDeletion)migration;
            migrationChangesToFill.addGlobalOptionDeletion(optionDeletion.getOptionName());
            return;
        }
        if (!(migration instanceof DataDrivenFindingMigration)) return;
        DataDrivenFindingMigration dataDrivenMigration = (DataDrivenFindingMigration)migration;
        dataDrivenMigration.getInnerMigrations().forEach(innerMigration -> InstanceComparisonUtils.addMigrationIfSuited(innerMigration, migrationChangesToFill));
    }

    private InstanceComparisonUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

