/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.admin.instance_comparison.snapshot.contributions.global;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.teamscale.core.log.worker.ShortWorkerLog;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.IDetailedInstanceComparisonContribution;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.InstanceComparisonContributionBase;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.NumberInstanceComparisonValue;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.global.GlobalComparisonContributionBase;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.global.MaintenanceLogErrorsComparisonDetailContribution;
import com.teamscale.index.admin.instance_comparison.util.MultisetToCounterSetDeserializer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@IndexValueClass
public class MaintenanceLogErrorsComparisonContribution
extends GlobalComparisonContributionBase {
    private static final long serialVersionUID = 1L;
    private static final String LOG_ERROR_FREQUENCIES_PROPERTY = "logErrorFrequencies";
    private static final String DETAIL_PROPERTY = "detail";
    @JsonProperty(value="logErrorFrequencies")
    @JsonDeserialize(using=MultisetToCounterSetDeserializer.class)
    private final CounterSet<String> logErrorFrequencies;
    @JsonProperty(value="detail")
    private final @Nullable MaintenanceLogErrorsComparisonDetailContribution detail;

    @JsonCreator
    public MaintenanceLogErrorsComparisonContribution(@JsonProperty(value="contributor") String contributor, @JsonProperty(value="logErrorFrequencies") CounterSet<String> logErrorFrequencies, @JsonProperty(value="detail") @Nullable MaintenanceLogErrorsComparisonDetailContribution detail) {
        super(contributor);
        this.logErrorFrequencies = logErrorFrequencies;
        this.detail = detail;
    }

    public MaintenanceLogErrorsComparisonContribution(String contributor, Collection<ShortWorkerLog> errorLogs, boolean detailed) {
        super(contributor);
        this.logErrorFrequencies = (CounterSet)errorLogs.stream().map(ShortWorkerLog::getTriggerName).collect(CounterSet.toCounterSet());
        if (detailed) {
            this.detail = new MaintenanceLogErrorsComparisonDetailContribution();
            errorLogs.forEach(this.detail::addLogEntry);
        } else {
            this.detail = null;
        }
    }

    public Map<String, NumberInstanceComparisonValue> getValues(InstanceComparisonContributionBase.ComparisonContext context) {
        return MaintenanceLogErrorsComparisonContribution.convertToComparisonValueMap(this.logErrorFrequencies, this.detail, this.contributor);
    }

    public static Map<String, NumberInstanceComparisonValue> convertToComparisonValueMap(CounterSet<String> logErrorFrequencies, @Nullable IDetailedInstanceComparisonContribution detail, String acceptedDeviationKeyOverwrite) {
        HashMap<String, NumberInstanceComparisonValue> result = new HashMap<String, NumberInstanceComparisonValue>();
        for (Pair errorsForTrigger : logErrorFrequencies) {
            result.put((String)errorsForTrigger.getFirst(), new NumberInstanceComparisonValue((String)errorsForTrigger.getFirst(), (Number)errorsForTrigger.getSecond(), detail, NumberInstanceComparisonValue.LOWER_LOCAL_IMPROVEMENT, acceptedDeviationKeyOverwrite));
        }
        return result;
    }
}

