/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.architecture.assessment.shared;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.teamscale.index.architecture.format.ECodeMappingType;
import java.util.List;

public class CodeMapping {
    private final String pattern;
    private final ECodeMappingType type;

    public CodeMapping(String pattern, ECodeMappingType type) {
        this.pattern = pattern;
        this.type = type;
    }

    @JsonCreator
    protected static CodeMapping fromJson(List<String> jsonValue) {
        if (jsonValue.size() != 2) {
            throw new IllegalArgumentException("Invalid JSON format. Expected exactly two list elements, but was: %d".formatted(jsonValue.size()));
        }
        return new CodeMapping(jsonValue.get(1), ECodeMappingType.valueOf(jsonValue.get(0)));
    }

    @JsonValue
    protected List<String> toJson() {
        return List.of(this.type.name(), this.pattern);
    }

    public String getPattern() {
        return this.pattern;
    }

    public ECodeMappingType getType() {
        return this.type;
    }

    public String toString() {
        return "CodeMapping{pattern='" + this.pattern + "', type=" + String.valueOf((Object)this.type) + "}";
    }
}

