/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.architecture.scope;

import com.teamscale.index.architecture.assessment.shared.Dependency;
import com.teamscale.index.architecture.commons.EPolicyType;
import com.teamscale.index.architecture.scope.ArchitectureDefinition;
import com.teamscale.index.architecture.scope.ArchitectureDefinitionParser;
import com.teamscale.index.architecture.scope.ComponentNode;
import com.teamscale.index.architecture.scope.DependencyPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;

public class ArchitectureDefinitionReader {
    private static final Logger LOGGER = LogManager.getLogger();

    private static ArchitectureDefinition parseArchitecture(ArchitectureDefinitionParser parser) throws ConQATException {
        ArchitectureDefinition architecture = parser.parse();
        if (!architecture.isStructureOnly()) {
            ArchitectureDefinitionReader.checkDependencies(architecture);
        }
        return architecture;
    }

    public static ArchitectureDefinition read(String architectureUniformPath, String architectureContent) throws ConQATException {
        ArchitectureDefinitionParser parser = new ArchitectureDefinitionParser(architectureUniformPath, architectureContent);
        return ArchitectureDefinitionReader.parseArchitecture(parser);
    }

    public static ArchitectureDefinition readWithoutValidation(String architectureUniformPath, String architectureContent) throws ConQATException {
        return new ArchitectureDefinitionParser(architectureUniformPath, architectureContent).parse();
    }

    private static void checkDependencies(ArchitectureDefinition architectureDefinition) throws ConQATException {
        ArrayList<DependencyPolicy> policies = new ArrayList<DependencyPolicy>();
        architectureDefinition.collectPolicies(policies);
        String architectureName = architectureDefinition.getName();
        ArchitectureDefinitionReader.checkTreeFollowing(policies, architectureName);
        ArchitectureDefinitionReader.checkDuplicateAndCrossingEdges(policies, architectureName);
    }

    private static void checkTreeFollowing(List<DependencyPolicy> policies, String architectureName) {
        for (Dependency dependency : policies) {
            if (!ArchitectureDefinitionReader.isDependencyBetweenParentAndChild(dependency)) continue;
            LOGGER.warn("Architecture {}: Unnecessary dependency policy between parent and child: {}", (Object)architectureName, (Object)dependency);
        }
    }

    private static boolean isDependencyBetweenParentAndChild(Dependency policy) {
        ComponentNode source = policy.getSource();
        ComponentNode target = policy.getTarget();
        return source.getAncestors().contains(target) || target.getAncestors().contains(source);
    }

    private static void checkDuplicateAndCrossingEdges(List<DependencyPolicy> policies, String architectureName) throws ConQATException {
        for (Dependency dependency : policies) {
            for (Dependency dependency2 : policies) {
                if (dependency == dependency2) continue;
                ArchitectureDefinitionReader.checkPoliciesNotSame(dependency, dependency2, architectureName);
                ArchitectureDefinitionReader.checkPoliciesNotCrossing(dependency, dependency2, architectureName);
                ArchitectureDefinitionReader.checkPoliciesNotCrossing(dependency2, dependency, architectureName);
            }
        }
    }

    private static void checkPoliciesNotSame(Dependency policy, Dependency policy2, String architectureName) throws ConQATException {
        if (policy.getSource() == policy2.getSource() && policy.getTarget() == policy2.getTarget()) {
            String message = String.format("Architecture %s: Duplicate policy for %s", architectureName, policy);
            throw new ConQATException(message);
        }
    }

    private static void checkPoliciesNotCrossing(Dependency policy, Dependency policy2, String architectureName) throws ConQATException {
        if (policy.getType() == EPolicyType.DENY_EXPLICIT && policy2.getType() == EPolicyType.DENY_EXPLICIT) {
            return;
        }
        if (policy.getType() != EPolicyType.DENY_EXPLICIT && policy2.getType() != EPolicyType.DENY_EXPLICIT) {
            return;
        }
        boolean source2IsLower = ArchitectureDefinitionReader.isAncestorOf(policy2.getSource(), policy.getSource());
        boolean target2IsHigher = ArchitectureDefinitionReader.isAncestorOf(policy.getTarget(), policy2.getTarget());
        if (source2IsLower && target2IsHigher) {
            String message = String.format("Architecture %s: The architecture is in an invalid state. Please resolve the contradicting policies \"%s\" and \"%s\"", architectureName, policy, policy2);
            throw new ConQATException(message);
        }
    }

    private static boolean isAncestorOf(ComponentNode component1, ComponentNode component2) {
        Set<ComponentNode> targetAncestors = component2.getAncestors();
        targetAncestors.remove(component2);
        return targetAncestors.contains(component1);
    }
}

