/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.backup;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.core.utils.HistoryUtils;
import com.teamscale.index.external.ExternalUploadIndexBase;
import com.teamscale.index.external.ExternalUploadIndexUtils;
import com.teamscale.index.external.InconsistentCommitException;
import com.teamscale.index.external.tools.ExternalUploadIndexModifier;
import com.teamscale.index.external.update.ExternalAnalysisResultsChangeRetriever;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.conqat.engine.core.cancel.ExecutionCanceledException;
import org.conqat.engine.core.cancel.ICancelable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.SchemaAwareStorageSystem;
import org.conqat.engine.persistence.store.IStorageSystem;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.CommitLayeringBranchingLayer;
import org.conqat.engine.persistence.store.branched.ECommitStatus;
import org.conqat.engine.persistence.store.branched.IBranchCommitInfo;
import org.conqat.engine.persistence.store.branched.IBranchingLayer;
import org.conqat.engine.persistence.store.branched.ICommitLayeringDataLayout;
import org.conqat.engine.persistence.store.branched.PlainCommitLayeringDataLayout;
import org.conqat.engine.persistence.store.util.CompressingStore;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.factory.IFactory;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class ExternalUploadIndexRepairer {
    private static final Logger LOGGER = LogManager.getLogger();

    public static ExternalUploadStoreValidationResult validateStore(CompressingStore externalUploadStore) throws StorageException {
        Map<String, List<ParentedCommitDescriptor>> commitsByBranch = ExternalUploadIndexRepairer.getBranchToCommitsMapping((IStore)externalUploadStore);
        return new ExternalUploadStoreValidationResult(ExternalUploadIndexRepairer.validateParentRelations(commitsByBranch), ExternalUploadIndexRepairer.validateHeadCommits(externalUploadStore, commitsByBranch));
    }

    private static Map<String, Long> validateParentRelations(Map<String, List<ParentedCommitDescriptor>> commitsByBranch) {
        HashMap<String, Long> earliestInconsistentCommitByBranch = new HashMap<String, Long>();
        for (Map.Entry<String, List<ParentedCommitDescriptor>> entry : commitsByBranch.entrySet()) {
            ExternalUploadIndexRepairer.validateCommitsOnBranch(entry.getValue(), earliestInconsistentCommitByBranch);
        }
        return earliestInconsistentCommitByBranch;
    }

    private static Set<String> validateHeadCommits(CompressingStore externalUploadStore, Map<String, List<ParentedCommitDescriptor>> commitsByBranch) throws StorageException {
        HashSet<String> branchesWithInvalidHead = new HashSet<String>();
        CommitLayeringBranchingLayer commitLayeringBranchingLayer = new CommitLayeringBranchingLayer((IStore)externalUploadStore, (ICommitLayeringDataLayout)new PlainCommitLayeringDataLayout());
        for (String branchName : commitsByBranch.keySet()) {
            ExternalUploadIndexRepairer.validateHeadCommitOnBranch(branchName, commitLayeringBranchingLayer, branchesWithInvalidHead);
        }
        return branchesWithInvalidHead;
    }

    private static void validateCommitsOnBranch(List<ParentedCommitDescriptor> commitsOnBranch, Map<String, Long> earliestInconsistentCommitsByBranch) {
        CommitDescriptor expectedFirstParent = null;
        ArrayList orderedCommits = CollectionUtils.sort(commitsOnBranch);
        if (!orderedCommits.isEmpty()) {
            expectedFirstParent = ((ParentedCommitDescriptor)orderedCommits.get(0)).getFirstParentCommit();
        }
        for (ParentedCommitDescriptor commitDescriptor : orderedCommits) {
            CommitDescriptor actualFirstParent = commitDescriptor.getFirstParentCommit();
            if (!Objects.equals(expectedFirstParent, actualFirstParent)) {
                earliestInconsistentCommitsByBranch.put(commitDescriptor.getBranchName(), expectedFirstParent.getTimestamp());
                LOGGER.warn("Found inconsistency for commit " + String.valueOf(commitDescriptor) + ". Should have parent " + String.valueOf(expectedFirstParent) + " but has parent " + String.valueOf(actualFirstParent) + ".");
                break;
            }
            expectedFirstParent = new CommitDescriptor(commitDescriptor.getBranchName(), commitDescriptor.getTimestamp());
        }
    }

    private static void validateHeadCommitOnBranch(String branchName, CommitLayeringBranchingLayer commitLayer, Set<String> branchesWithInvalidHead) throws StorageException {
        IBranchCommitInfo newestCommitOnBranch = commitLayer.getNewestCommitBeforeOrAtBasedOnCommitKeysForBranch(branchName, Long.MAX_VALUE);
        if (newestCommitOnBranch == null) {
            return;
        }
        IBranchCommitInfo currentHeadOnBranch = commitLayer.readHeadCommit(branchName);
        if (currentHeadOnBranch == null || currentHeadOnBranch.getTimestamp() < newestCommitOnBranch.getTimestamp()) {
            branchesWithInvalidHead.add(branchName);
            LOGGER.warn(ExternalUploadIndexRepairer.getWarningMessageForInvalidHead(currentHeadOnBranch, newestCommitOnBranch, branchName));
        }
    }

    private static String getWarningMessageForInvalidHead(@Nullable IBranchCommitInfo currentHeadOnBranch, @NonNull IBranchCommitInfo newestCommitOnBranch, String branchName) {
        StringBuilder builder = new StringBuilder();
        if (currentHeadOnBranch == null) {
            builder.append("Found no head commit");
        } else {
            builder.append("Found invalid head with timestamp '" + currentHeadOnBranch.getTimestamp() + "'");
        }
        builder.append(" on branch '" + branchName + "'. Head commit should have timestamp '" + newestCommitOnBranch.getTimestamp() + "'.");
        return builder.toString();
    }

    public static void recalculateHeadForBranchesIfNeeded(Set<String> branches, CommitLayeringBranchingLayer commitLayeringBranchingLayer) throws StorageException {
        for (String branch : branches) {
            commitLayeringBranchingLayer.recalculateHeadCommitPointer(branch);
        }
    }

    public static void performRollbackForInconsistentBranches(CompressingStore compressingMergedStore, Map<String, Long> inconsistentCommitByBranch) throws StorageException {
        HashMap<String, Long> rollbackMap = new HashMap<String, Long>();
        for (Map.Entry<String, Long> entry : inconsistentCommitByBranch.entrySet()) {
            rollbackMap.put(entry.getKey(), entry.getValue() - 1L);
        }
        LOGGER.debug("performRollbackForInconsistentBranches: inconsistentCommitByBranch=[{}]", new Supplier[]{() -> inconsistentCommitByBranch.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(e -> (String)e.getKey() + "@" + String.valueOf(e.getValue())).collect(Collectors.joining(", "))});
        new CommitLayeringBranchingLayer((IStore)compressingMergedStore, (ICommitLayeringDataLayout)new PlainCommitLayeringDataLayout()).performRollback(rollbackMap);
    }

    private static Map<String, List<ParentedCommitDescriptor>> getBranchToCommitsMapping(IStore store) throws StorageException {
        return HistoryUtils.extractCommitDescriptorsFromRawBranchedStore((IBranchingLayer)new CommitLayeringBranchingLayer(store, (ICommitLayeringDataLayout)new PlainCommitLayeringDataLayout())).stream().collect(Collectors.groupingBy(CommitDescriptor::getBranchName));
    }

    public static <COMMIT extends Serializable> void repair(ExternalUploadStoreValidationResult validationResult, CompressingStore inputStore, IStorageSystem rawProjectStorageSystem, IndexLayer indexLayer, InternalProjectId projectName, boolean projectIsExpectedToExist, String indexName, Class<? extends ExternalUploadIndexBase<COMMIT>> indexClass, ICancelable cancelable, Consumer<String> progressUpdate, IFactory<IStore, StorageException> storeFactory) throws StorageException, ExecutionCanceledException {
        LOGGER.trace("repair: start - projectID='{}', indexName='{}'", (Object)projectName, (Object)indexName);
        ExternalUploadIndexModifier modifier = new ExternalUploadIndexModifier(rawProjectStorageSystem, indexLayer.getStorageCacheProvider().getCacheProvider(projectName.toString()), storeFactory, indexName, indexClass);
        SchemaAwareStorageSystem modificationStorageSystem = modifier.getModificationStorageSystem();
        CompressingStore outputStore = new CompressingStore(modificationStorageSystem.openStore(indexName));
        List<ParentedCommitDescriptor> orderedCommitsToWrite = ExternalUploadIndexRepairer.determineCommitsToWrite(validationResult.invalidParentRelations(), inputStore);
        if (!validationResult.branchesWithInvalidHead().isEmpty() && !orderedCommitsToWrite.isEmpty()) {
            LOGGER.debug("Fixing invalid HEADs on input store for branches: {}", new Supplier[]{() -> validationResult.branchesWithInvalidHead().stream().sorted().collect(Collectors.joining(", "))});
            modifier.recalculateInputHeadCommitsForBranches(validationResult.branchesWithInvalidHead());
        }
        Supplier[] supplierArray = new Supplier[3];
        supplierArray[0] = orderedCommitsToWrite::size;
        supplierArray[1] = validationResult.invalidParentRelations::size;
        supplierArray[2] = () -> validationResult.invalidParentRelations.keySet().stream().sorted().collect(Collectors.joining(", "));
        LOGGER.warn("Rewriting {} commits on {} branches ({})", supplierArray);
        Supplier[] supplierArray2 = new Supplier[1];
        supplierArray2[0] = (Supplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, toString(), ()Ljava/lang/Object;)(orderedCommitsToWrite);
        LOGGER.trace("repair: orderedCommitsToWrite={}", supplierArray2);
        if (LOGGER.getLevel().isLessSpecificThan(Level.DEBUG) && indexName.equals("external-analysis-results")) {
            ExternalUploadIndexRepairer.debugLogExistingCommitsInOutputStore(outputStore, orderedCommitsToWrite);
        }
        int currentCommitNumber = 0;
        for (ParentedCommitDescriptor commit : orderedCommitsToWrite) {
            cancelable.verifyNotCanceled();
            progressUpdate.accept("Repairing commit %d/%d in '%s' ...".formatted(++currentCommitNumber, orderedCommitsToWrite.size(), indexName));
            ExternalUploadIndexModifier.AdditionInfo addition = modifier.prepareForAddition((CommitDescriptor)commit);
            ParentedCommitDescriptor rewriteCommit = addition.getArtificialWriteCommit();
            try {
                LOGGER.trace("repair: processing - commit={}, rewriteCommit={}", (Object)commit.toStringWithParents(), (Object)rewriteCommit.toStringWithParents());
                ExternalUploadIndexUtils.copyCommit(indexName, indexClass, rewriteCommit, (IStore)inputStore, (IStore)outputStore);
            }
            catch (InconsistentCommitException e) {
                throw new StorageException("Commit rewrite failed.", (Throwable)e);
            }
            catch (Throwable th) {
                LOGGER.error("Unexpected exception during repair of '{}' - commit={}, rewriteCommit={}\nIncrease the logging level to DEBUG or TRACE for the components involved in backup imports to obtain more detailed information.", (Object)indexName, (Object)commit.toStringWithParents(), (Object)rewriteCommit.toStringWithParents(), (Object)th);
                throw th;
            }
            modifier.completeAddition(addition);
        }
        if (!validationResult.branchesWithInvalidHead().isEmpty()) {
            modifier.recalculateHeadCommitsForBranches(validationResult.branchesWithInvalidHead());
        }
        if (projectIsExpectedToExist && !modifier.scheduleRollbackIfNeeded(projectName, indexLayer)) {
            ISchedulerCommunicator.getInstance().scheduleExternallyStartedTrigger(indexLayer, projectName, ExternalAnalysisResultsChangeRetriever.class);
        }
        LOGGER.trace("repair: finished - projectID='{}', indexName='{}'", (Object)projectName, (Object)indexName);
    }

    private static List<ParentedCommitDescriptor> determineCommitsToWrite(Map<String, Long> inconsistentCommitsByBranch, CompressingStore inputStore) throws StorageException {
        Map<String, List<ParentedCommitDescriptor>> commitsByBranchName = ExternalUploadIndexRepairer.getBranchToCommitsMapping((IStore)inputStore);
        return commitsByBranchName.entrySet().stream().flatMap(entry -> {
            String branchName = (String)entry.getKey();
            if (inconsistentCommitsByBranch.containsKey(branchName)) {
                long firstInConsistentCommitOnBranch = (Long)inconsistentCommitsByBranch.get(branchName);
                return ((List)entry.getValue()).stream().filter(commit -> commit.getTimestamp() >= firstInConsistentCommitOnBranch);
            }
            return Stream.empty();
        }).distinct().sorted().collect(Collectors.toList());
    }

    private static void debugLogExistingCommitsInOutputStore(CompressingStore outputStore, List<ParentedCommitDescriptor> orderedCommitsToWrite) throws StorageException {
        CommitLayeringBranchingLayer outputBranchingLayer = new CommitLayeringBranchingLayer((IStore)outputStore, (ICommitLayeringDataLayout)new PlainCommitLayeringDataLayout());
        ArrayList<ParentedCommitDescriptor> existingCommitsInOutput = new ArrayList<ParentedCommitDescriptor>(orderedCommitsToWrite.size());
        for (ParentedCommitDescriptor commit : orderedCommitsToWrite) {
            if (!outputBranchingLayer.commitExists(commit.getBranchName(), commit.getTimestamp())) continue;
            existingCommitsInOutput.add(commit);
        }
        if (existingCommitsInOutput.isEmpty()) {
            return;
        }
        LOGGER.debug("repair: {} of {} commits to re-write already exist in outputStore", (Object)existingCommitsInOutput.size(), (Object)orderedCommitsToWrite.size());
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = (Supplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, toString(), ()Ljava/lang/Object;)(existingCommitsInOutput);
        LOGGER.trace("repair: existingCommitsInOutput={}", supplierArray);
        ExternalUploadIndexRepairer.debugLogWritableAndUnwritableCommitsInOutputStore(existingCommitsInOutput, outputBranchingLayer);
    }

    private static void debugLogWritableAndUnwritableCommitsInOutputStore(List<ParentedCommitDescriptor> existingCommitsInOutput, CommitLayeringBranchingLayer outputBranchingLayer) throws StorageException {
        ArrayList<ParentedCommitDescriptor> unwritableCommits = new ArrayList<ParentedCommitDescriptor>();
        for (ParentedCommitDescriptor commit : existingCommitsInOutput) {
            IBranchCommitInfo commitInfo = outputBranchingLayer.readCommit(commit.getBranchName(), commit.getTimestamp());
            if (commitInfo == null) {
                LOGGER.error("Inconsistency in output store: commit info is null even though commit info should exist - commit={}", (Object)commit.toStringWithParents());
                continue;
            }
            if (commitInfo.getStatus() == ECommitStatus.WRITEABLE) continue;
            unwritableCommits.add(commit);
        }
        if (unwritableCommits.isEmpty()) {
            return;
        }
        HashSet writableCommits = CollectionUtils.differenceSet(existingCommitsInOutput, (Collection[])new Collection[]{unwritableCommits});
        LOGGER.debug("repair: {} of {} commits that exist in the output store are NOT writable. {} of {} of the commits are writable. All but the HEAD commits for each branch should NOT be writable.", (Object)unwritableCommits.size(), (Object)existingCommitsInOutput.size(), (Object)writableCommits.size(), (Object)existingCommitsInOutput.size());
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = (Supplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, toString(), ()Ljava/lang/Object;)(unwritableCommits);
        LOGGER.trace("repair: un-writeable existing commits in output store: {}", supplierArray);
        Supplier[] supplierArray2 = new Supplier[1];
        supplierArray2[0] = writableCommits::toString;
        LOGGER.trace("repair: writeable existing commits in output store: {}", supplierArray2);
    }

    public record ExternalUploadStoreValidationResult(Map<String, Long> invalidParentRelations, Set<String> branchesWithInvalidHead) {
        public boolean needsRepair() {
            return !this.invalidParentRelations.isEmpty() || !this.branchesWithInvalidHead.isEmpty();
        }
    }
}

