/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_change;

import com.teamscale.core.utils.XXHashUtils;
import com.teamscale.index.code_change.CodeChangeIndexSynchronizer;
import com.teamscale.index.code_change.MatchRegion;
import com.teamscale.index.code_change.MethodMatchRegionContent;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.typetracker.ITypeInfoExtractor;
import eu.cqse.check.framework.typetracker.TypeInfoExtractorFactory;
import eu.cqse.check.framework.typetracker.TypedVariable;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.tokens.TokenUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.jpountz.xxhash.StreamingXXHash64;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass(containedInBackup=true)
public class MethodMatchRegion
extends MatchRegion {
    private static final long serialVersionUID = 4788766517757689604L;
    public static final char NAMESPACE_SEPARATOR = '#';
    protected final String simpleName;
    private static final Logger LOGGER = LogManager.getLogger();
    private final String fullMethodCallPattern;
    private final String parentName;
    private final List<TypedVariable> parameters;
    protected final boolean hasChildren;
    private final String parameterHash;
    private static final Set<ELanguage> LANGUAGES_WITH_LAMBDA_PROPERTIES = EnumSet.of(ELanguage.CS, ELanguage.JAVA, ELanguage.JAVASCRIPT, ELanguage.SWIFT);

    MethodMatchRegion(long lastChangeTimestamp, TokenElementInfo elementInfo, CodeChangeIndexSynchronizer.ShallowEntityWithRawOffsets entityWithRawOffsets, String originPath, CounterSet<String> idCounters, Map<String, List<IToken>> aliases) {
        super(entityWithRawOffsets.rawStartOffset(), entityWithRawOffsets.rawEndOffset(), lastChangeTimestamp, elementInfo, originPath, MethodMatchRegion.getIdFromEntity(entityWithRawOffsets.entity(), idCounters, aliases), new MethodMatchRegionContent(entityWithRawOffsets.entity(), elementInfo.getLanguage()));
        ShallowEntity entity = entityWithRawOffsets.entity();
        this.simpleName = MethodMatchRegion.buildDisplayNameForMethodEntity(entity);
        this.parentName = MethodMatchRegion.getParentNameFromEntity(entity);
        this.parameters = MethodMatchRegion.getParametersFromEntity(elementInfo, entity);
        this.hasChildren = entity.hasChildren();
        this.parameterHash = MethodMatchRegion.getParameterHash(this.parameters);
        this.fullMethodCallPattern = MethodMatchRegion.getMethodCall(entity) + "#" + this.parameters.size();
    }

    private static String getMethodCall(ShallowEntity entity) {
        StringBuilder builder = new StringBuilder();
        builder.append(entity.getName());
        for (ShallowEntity parent = entity.getParent(); parent != null; parent = parent.getParent()) {
            builder.insert(0, parent.getName() + "#");
        }
        return builder.toString();
    }

    public String getMethodCallPattern() {
        return this.fullMethodCallPattern;
    }

    private static String getParameterHash(List<TypedVariable> parameters) {
        StreamingXXHash64 hash = XXHashUtils.streamingHash64();
        for (TypedVariable parameter : parameters) {
            XXHashUtils.updateHash((StreamingXXHash64)hash, (String)parameter.getTypeNameWithoutGenericTypeParameter());
        }
        return Long.toHexString(hash.getValue());
    }

    private static String getIdFromEntity(ShallowEntity entity, CounterSet<String> idCounters, Map<String, List<IToken>> aliases) {
        StringBuilder builder = new StringBuilder();
        builder.append(entity.getType());
        Object namespace = "";
        for (ShallowEntity parent = entity.getParent(); parent != null; parent = parent.getParent()) {
            namespace = parent.getName() + "#" + (String)namespace;
        }
        builder.append((String)namespace);
        if (entity.getSubtype() != null) {
            builder.append(entity.getSubtype());
        }
        if (entity.getName() != null) {
            builder.append(entity.getName());
        }
        List<IToken> methodStartTokens = MethodMatchRegion.extractStartTokens(entity, aliases);
        for (IToken token : methodStartTokens) {
            if (token.getLanguage().isCaseSensitive() || TokenUtils.ALWAYS_CASE_SENSITIVE_TOKEN_TYPES.contains((Object)token.getType())) {
                builder.append(token.getText());
                continue;
            }
            builder.append(token.getText().toLowerCase());
        }
        String preliminaryId = builder.toString();
        int idCount = idCounters.inc((Object)preliminaryId);
        if (idCount > 1) {
            builder.append(idCount);
        }
        return builder.toString();
    }

    private static List<IToken> extractStartTokens(ShallowEntity entity, Map<String, List<IToken>> aliases) {
        Object methodStartTokens = entity.ownStartTokens();
        if (!methodStartTokens.isEmpty() && ((IToken)methodStartTokens.get(0)).getLanguage().isCppOrC()) {
            methodStartTokens = LanguageFeatureParser.CPP.resolveAliases((List)methodStartTokens, aliases);
        }
        return methodStartTokens;
    }

    private static String buildDisplayNameForMethodEntity(ShallowEntity entity) {
        ELanguage language = TokenStreamUtils.getLanguage((Collection)entity.ownStartTokens());
        String displayName = entity.getName() == null ? (LANGUAGES_WITH_LAMBDA_PROPERTIES.contains(language) && Objects.equals(entity.getSubtype(), "lambda") && entity.getParent() != null ? entity.getParent().getName() : entity.getSubtype()) : (language != null && language.isObjectiveCOrObjectiveCpp() ? MethodMatchRegion.buildDisplayNameForObjectiveCMethod(entity) : entity.getName());
        if (displayName != null) {
            return displayName.replace("/", "!");
        }
        LOGGER.error("Entity name was null\nEntity start tokens:" + String.valueOf(entity.ownStartTokens()) + "\nEntity parent:" + MethodMatchRegion.getParentNameFromEntity(entity) + "\nEntity type:" + String.valueOf(entity.getType()) + "\nEntity subtype:" + entity.getSubtype() + "\n");
        return null;
    }

    private static String buildDisplayNameForObjectiveCMethod(ShallowEntity entity) {
        if (entity.getType() != EShallowEntityType.METHOD) {
            return entity.getName();
        }
        UnmodifiableList entityStartTokens = entity.ownStartTokens();
        List colonIndices = TokenStreamUtils.getTopLevelTokenTypeIndices((List)entityStartTokens, Collections.singleton(ETokenType.COLON), (List)TokenStreamUtils.STANDARD_OPENING_TOKEN_TYPES, (List)TokenStreamUtils.STANDARD_CLOSING_TOKEN_TYPES);
        ArrayList<String> methodNameParts = new ArrayList<String>(colonIndices.size());
        Iterator iterator = colonIndices.iterator();
        while (iterator.hasNext()) {
            int colonIndex = (Integer)iterator.next();
            if (colonIndex <= 0 || ((IToken)entityStartTokens.get(colonIndex - 1)).getType() != ETokenType.IDENTIFIER) continue;
            methodNameParts.add(((IToken)entityStartTokens.get(colonIndex - 1)).getText());
        }
        if (methodNameParts.isEmpty()) {
            return entity.getName();
        }
        return String.join((CharSequence)":", methodNameParts);
    }

    private static String getParentNameFromEntity(ShallowEntity entity) {
        if (entity.getParent() == null) {
            return "entire file";
        }
        return entity.getParent().getName();
    }

    private static List<TypedVariable> getParametersFromEntity(TokenElementInfo elementInfo, ShallowEntity entity) {
        ITypeInfoExtractor entityListExtractor;
        if (TypeInfoExtractorFactory.supportsLanguage((ELanguage)elementInfo.getLanguage()) && (entityListExtractor = TypeInfoExtractorFactory.getTypeInfoExtractor((ELanguage)elementInfo.getLanguage(), elementInfo.getShallowEntitiesWithoutPreprocessorTokens())) != null) {
            return entityListExtractor.extract(entity);
        }
        return CollectionUtils.emptyList();
    }

    @Override
    public String getSimpleName() {
        return this.simpleName;
    }

    @Override
    public String getParentName() {
        return this.parentName;
    }

    public List<TypedVariable> getParameters() {
        return this.parameters;
    }

    @Override
    public MethodMatchRegionContent getContent() {
        return (MethodMatchRegionContent)this.content;
    }

    public String getParameterHash() {
        return this.parameterHash;
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MethodMatchRegion;
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

